/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors.ecl.actions;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.rcptt.ui.editors.ecl.DocumentCharacterIterator;
import org.eclipse.rcptt.ui.editors.ecl.EclEditor;
import org.eclipse.rcptt.ui.editors.ecl.EclWordIterator;
import org.eclipse.rcptt.ui.editors.ecl.actions.EclTextNavigationAction;

abstract class PreviousSubWordAction
extends EclTextNavigationAction {
    protected EclWordIterator fIterator = new EclWordIterator();

    protected PreviousSubWordAction(EclEditor eclEditor, int code) {
        super(eclEditor, eclEditor.doGetSourceViewer().getTextWidget(), code);
    }

    @Override
    public void internalRun(TextViewer viewer) {
        IPreferenceStore store = this.eclEditor.doGetPreferenceStore();
        IDocument document = viewer.getDocument();
        try {
            this.fIterator.setText(new DocumentCharacterIterator(document));
            int position = this.eclEditor.doWidgetOffset2ModelOffset(viewer, viewer.getTextWidget().getCaretOffset());
            if (position == -1) {
                return;
            }
            int previous = this.findPreviousPosition(viewer, position);
            if (this.eclEditor.isBlockSelectionModeEnabled() && document.getLineOfOffset(previous) != document.getLineOfOffset(position)) {
                super.run();
            } else if (previous != -1) {
                this.setCaretPosition(viewer, previous);
                viewer.getTextWidget().showSelection();
                this.fireSelectionChanged();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    protected int findPreviousPosition(TextViewer viewer, int position) {
        int widget = -1;
        int previous = position;
        while (previous != -1 && widget == -1) {
            if ((previous = this.fIterator.preceding(previous)) == -1) continue;
            widget = this.eclEditor.doModelOffset2WidgetOffset(viewer, previous);
        }
        IDocument document = viewer.getDocument();
        LinkedModeModel model = LinkedModeModel.getModel((IDocument)document, (int)position);
        if (model != null) {
            LinkedPosition linkedPosition = model.findPosition(new LinkedPosition(document, position, 0));
            if (linkedPosition != null) {
                int linkedPositionOffset = linkedPosition.getOffset();
                if (position != linkedPositionOffset && previous < linkedPositionOffset) {
                    previous = linkedPositionOffset;
                }
            } else {
                int previousLinkedPositionEnd;
                LinkedPosition previousLinkedPosition = model.findPosition(new LinkedPosition(document, previous, 0));
                if (previousLinkedPosition != null && position != (previousLinkedPositionEnd = previousLinkedPosition.getOffset() + previousLinkedPosition.getLength()) && previous < previousLinkedPositionEnd) {
                    previous = previousLinkedPositionEnd;
                }
            }
        }
        return previous;
    }

    protected abstract void setCaretPosition(TextViewer var1, int var2);
}

