/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.targetdefinition;

import java.util.TreeSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.internal.core.util.VMUtil;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.targetdefinition.TargetEditor;
import org.eclipse.pde.internal.ui.parts.ComboPart;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class JRESection
extends SectionPart {
    private Button fDefaultJREButton;
    private Button fNamedJREButton;
    private Button fExecEnvButton;
    private ComboPart fNamedJREsCombo;
    private ComboPart fExecEnvsCombo;
    private TreeSet<String> fExecEnvChoices;
    private boolean fBlockChanges;
    private Button fConfigureJREButton;
    private final TargetEditor fEditor;
    private static String JRE_PREF_PAGE_ID = "org.eclipse.jdt.debug.ui.preferences.VMPreferencePage";
    private static String EE_PREF_PAGE_ID = "org.eclipse.jdt.debug.ui.jreProfiles";

    public JRESection(FormPage page, Composite parent) {
        super(parent, page.getManagedForm().getToolkit(), 384);
        this.fEditor = (TargetEditor)page.getEditor();
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    private ITargetDefinition getTarget() {
        return this.fEditor.getTarget();
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        section.setText(PDEUIMessages.EnvironmentBlock_jreTitle);
        section.setDescription(PDEUIMessages.JRESection_description);
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(768);
        data.verticalAlignment = 128;
        data.horizontalSpan = 2;
        section.setLayoutData((Object)data);
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 3));
        this.initializeValues();
        this.fDefaultJREButton = toolkit.createButton(client, PDEUIMessages.JRESection_defaultJRE, 16);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this.fDefaultJREButton.setLayoutData((Object)gd);
        this.fDefaultJREButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.updateWidgets();
            if (!this.fBlockChanges) {
                this.getTarget().setJREContainer(null);
                this.markDirty();
            }
        }));
        this.fNamedJREButton = toolkit.createButton(client, PDEUIMessages.JRESection_JREName, 16);
        this.fNamedJREButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.updateWidgets();
            if (!this.fBlockChanges) {
                this.getTarget().setJREContainer(JavaRuntime.newJREContainerPath((IVMInstall)VMUtil.getVMInstall((String)this.fNamedJREsCombo.getSelection())));
                this.markDirty();
            }
        }));
        this.fNamedJREsCombo = new ComboPart();
        this.fNamedJREsCombo.createControl(client, toolkit, 2060);
        this.fNamedJREsCombo.getControl().setLayoutData((Object)new GridData(768));
        String[] installs = VMUtil.getVMInstallNames();
        this.fNamedJREsCombo.setItems(installs);
        this.fNamedJREsCombo.setVisibleItemCount(30);
        this.fNamedJREsCombo.addModifyListener(e -> {
            if (!this.fBlockChanges) {
                this.getTarget().setJREContainer(JavaRuntime.newJREContainerPath((IVMInstall)VMUtil.getVMInstall((String)this.fNamedJREsCombo.getSelection())));
                this.markDirty();
            }
        });
        this.fConfigureJREButton = toolkit.createButton(client, PDEUIMessages.JRESection_jrePreference, 8);
        this.fConfigureJREButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.openPreferencePage(JRE_PREF_PAGE_ID)));
        this.fConfigureJREButton.setLayoutData((Object)new GridData(256));
        SWTFactory.setButtonDimensionHint(this.fConfigureJREButton);
        this.fExecEnvButton = toolkit.createButton(client, PDEUIMessages.JRESection_ExecutionEnv, 16);
        this.fExecEnvButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.updateWidgets();
            if (!this.fBlockChanges) {
                this.getTarget().setJREContainer(JavaRuntime.newJREContainerPath((IExecutionEnvironment)VMUtil.getExecutionEnvironment((String)this.fExecEnvsCombo.getSelection())));
                this.markDirty();
            }
        }));
        this.fExecEnvsCombo = new ComboPart();
        this.fExecEnvsCombo.createControl(client, toolkit, 2060);
        this.fExecEnvsCombo.getControl().setLayoutData((Object)new GridData(768));
        this.fExecEnvsCombo.setItems(this.fExecEnvChoices.toArray(new String[this.fExecEnvChoices.size()]));
        this.fExecEnvsCombo.setVisibleItemCount(30);
        this.fExecEnvsCombo.addModifyListener(e -> {
            if (!this.fBlockChanges) {
                this.getTarget().setJREContainer(JavaRuntime.newJREContainerPath((IExecutionEnvironment)VMUtil.getExecutionEnvironment((String)this.fExecEnvsCombo.getSelection())));
                this.markDirty();
            }
        });
        Button configureEEButton = toolkit.createButton(client, PDEUIMessages.JRESection_eePreference, 8);
        configureEEButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.openPreferencePage(EE_PREF_PAGE_ID)));
        configureEEButton.setLayoutData((Object)new GridData(256));
        SWTFactory.setButtonDimensionHint(configureEEButton);
        this.refresh();
        section.setClient((Control)client);
    }

    protected void initializeValues() {
        IExecutionEnvironment[] envs;
        this.fExecEnvChoices = new TreeSet();
        IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
        IExecutionEnvironment[] iExecutionEnvironmentArray = envs = manager.getExecutionEnvironments();
        int n = envs.length;
        int n2 = 0;
        while (n2 < n) {
            IExecutionEnvironment env = iExecutionEnvironmentArray[n2];
            this.fExecEnvChoices.add(env.getId());
            ++n2;
        }
    }

    protected void updateWidgets() {
        this.fNamedJREsCombo.setEnabled(this.fNamedJREButton.getSelection());
        this.fExecEnvsCombo.setEnabled(this.fExecEnvButton.getSelection());
    }

    public void refresh() {
        this.fBlockChanges = true;
        IPath jrePath = this.getTarget().getJREContainer();
        if (jrePath == null || jrePath.equals((Object)JavaRuntime.newDefaultJREContainerPath())) {
            this.fDefaultJREButton.setSelection(true);
            this.fExecEnvButton.setSelection(false);
            this.fNamedJREButton.setSelection(false);
        } else {
            String ee = JavaRuntime.getExecutionEnvironmentId((IPath)jrePath);
            if (ee != null) {
                this.fExecEnvButton.setSelection(true);
                this.fDefaultJREButton.setSelection(false);
                this.fNamedJREButton.setSelection(false);
                this.fExecEnvsCombo.select(this.fExecEnvsCombo.indexOf(ee));
            } else {
                String vm = JavaRuntime.getVMInstallName((IPath)jrePath);
                if (vm != null) {
                    this.fNamedJREButton.setSelection(true);
                    this.fDefaultJREButton.setSelection(false);
                    this.fExecEnvButton.setSelection(false);
                    this.fNamedJREsCombo.select(this.fNamedJREsCombo.indexOf(vm));
                }
            }
        }
        if (this.fExecEnvsCombo.getSelectionIndex() == -1) {
            this.fExecEnvsCombo.setText(this.fExecEnvChoices.first().toString());
        }
        if (this.fNamedJREsCombo.getSelectionIndex() == -1) {
            this.fNamedJREsCombo.setText(VMUtil.getDefaultVMInstallName());
        }
        this.updateWidgets();
        super.refresh();
        this.fBlockChanges = false;
    }

    private void openPreferencePage(String pageID) {
        this.fBlockChanges = true;
        PreferencesUtil.createPreferenceDialogOn((Shell)this.fEditor.getEditorSite().getShell(), (String)pageID, (String[])new String[]{pageID}, null).open();
        this.fNamedJREsCombo.setItems(VMUtil.getVMInstallNames());
        this.refresh();
        this.fBlockChanges = false;
    }
}

