/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.string;

import java.util.Optional;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.vocabulary.FN;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtility;

public class Substring
implements Function {
    @Override
    public String getURI() {
        return FN.SUBSTRING.toString();
    }

    @Override
    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length < 2 || args.length > 3) {
            throw new ValueExprEvaluationException("Incorrect number of arguments for SUBSTR: " + args.length);
        }
        Value argValue = args[0];
        Value startIndexValue = args[1];
        Value lengthValue = null;
        if (args.length > 2) {
            lengthValue = args[2];
        }
        if (argValue instanceof Literal) {
            Literal literal = (Literal)argValue;
            if (QueryEvaluationUtility.isStringLiteral(literal)) {
                int endIndex;
                int startIndex;
                String lexicalValue;
                block17: {
                    lexicalValue = literal.getLabel();
                    startIndex = 0;
                    if (startIndexValue instanceof Literal) {
                        int startLiteral = Substring.intFromLiteral((Literal)startIndexValue);
                        try {
                            startIndex = startLiteral - 1;
                        }
                        catch (NumberFormatException e) {
                            throw new ValueExprEvaluationException("illegal start index value (expected int value): " + String.valueOf(startIndexValue));
                        }
                    } else if (startIndexValue != null) {
                        throw new ValueExprEvaluationException("illegal start index value (expected literal value): " + String.valueOf(startIndexValue));
                    }
                    endIndex = lexicalValue.length();
                    if (lengthValue instanceof Literal) {
                        try {
                            int length = Substring.intFromLiteral((Literal)lengthValue);
                            if (length < 1) {
                                return this.convert("", literal, valueFactory);
                            }
                            if ((endIndex = Math.min(startIndex + length, endIndex)) < 0) {
                                return this.convert("", literal, valueFactory);
                            }
                            break block17;
                        }
                        catch (NumberFormatException e) {
                            throw new ValueExprEvaluationException("illegal length value (expected int value): " + String.valueOf(lengthValue));
                        }
                    }
                    if (lengthValue != null) {
                        throw new ValueExprEvaluationException("illegal length value (expected literal value): " + String.valueOf(lengthValue));
                    }
                }
                try {
                    startIndex = Math.max(startIndex, 0);
                    lexicalValue = lexicalValue.substring(startIndex, endIndex);
                    return this.convert(lexicalValue, literal, valueFactory);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new ValueExprEvaluationException("could not determine substring, index out of bounds " + startIndex + "length:" + endIndex, e);
                }
            }
            throw new ValueExprEvaluationException("unexpected input value for function substring: " + String.valueOf(argValue));
        }
        throw new ValueExprEvaluationException("unexpected input value for function substring: " + String.valueOf(argValue));
    }

    private Literal convert(String lexicalValue, Literal literal, ValueFactory valueFactory) {
        Optional<String> language = literal.getLanguage();
        if (language.isPresent()) {
            return valueFactory.createLiteral(lexicalValue, language.get());
        }
        if (QueryEvaluationUtility.isSimpleLiteral(literal)) {
            return valueFactory.createLiteral(lexicalValue, (CoreDatatype)CoreDatatype.XSD.STRING);
        }
        return valueFactory.createLiteral(lexicalValue);
    }

    public static int intFromLiteral(Literal literal) throws ValueExprEvaluationException {
        CoreDatatype.XSD datatype = literal.getCoreDatatype().asXSDDatatypeOrNull();
        if (datatype != null && datatype.isNumericDatatype()) {
            if (datatype.isIntegerDatatype()) {
                return literal.intValue();
            }
            throw new ValueExprEvaluationException("unexpected datatype for function operand: " + String.valueOf(literal));
        }
        throw new ValueExprEvaluationException("unexpected input value for function: " + String.valueOf(literal));
    }
}

