/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.optimizer;

import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractSimpleQueryModelVisitor;

public class BindingAssignerOptimizer
implements QueryOptimizer {
    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        if (!bindings.isEmpty()) {
            tupleExpr.visit(new VarVisitor(bindings));
        }
    }

    private static class VarVisitor
    extends AbstractSimpleQueryModelVisitor<RuntimeException> {
        protected BindingSet bindings;

        public VarVisitor(BindingSet bindings) {
            super(true);
            this.bindings = bindings;
        }

        @Override
        public void meet(Var var) {
            if (!var.hasValue() && this.bindings.hasBinding(var.getName())) {
                Value value = this.bindings.getValue(var.getName());
                Var replacement = Var.of(var.getName(), value, var.isAnonymous(), var.isConstant());
                var.replaceWith(replacement);
            }
        }
    }
}

