/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.base;

import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.StampedLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.ModelFactory;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Statements;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.sail.SailConflictException;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.base.SailDatasetImpl;
import org.eclipse.rdf4j.sail.base.SailSink;

@InternalUseOnly
public abstract class Changeset
implements SailSink,
ModelFactory {
    AdderBasedReadWriteLock readWriteLock = new AdderBasedReadWriteLock();
    AdderBasedReadWriteLock refBacksReadWriteLock = new AdderBasedReadWriteLock();
    Semaphore prependLock = new Semaphore(1);
    private List<SailDatasetImpl> refbacks;
    private Set<Changeset> prepend;
    private volatile Set<SimpleStatementPattern> observed;
    private volatile Model approved;
    private volatile boolean approvedEmpty = true;
    private volatile Model deprecated;
    private volatile boolean deprecatedEmpty = true;
    private Set<Resource> approvedContexts;
    private volatile Set<Resource> deprecatedContexts;
    private Map<String, String> addedNamespaces;
    private Set<String> removedPrefixes;
    private volatile boolean namespaceCleared;
    private volatile boolean statementCleared;
    private boolean closed;

    public static boolean isOrderIndependent(Changeset changeset1, Changeset changeset2) {
        Objects.requireNonNull(changeset1, "changeset1");
        Objects.requireNonNull(changeset2, "changeset2");
        boolean c1StatementChanges = Changeset.hasStatementChanges(changeset1);
        boolean c2StatementChanges = Changeset.hasStatementChanges(changeset2);
        boolean c1NamespaceChanges = Changeset.hasNamespaceChanges(changeset1);
        boolean c2NamespaceChanges = Changeset.hasNamespaceChanges(changeset2);
        return c1NamespaceChanges && !c1StatementChanges && c2StatementChanges && !c2NamespaceChanges || c2NamespaceChanges && !c2StatementChanges && c1StatementChanges && !c1NamespaceChanges;
    }

    private static boolean hasNamespaceChanges(Changeset changeset) {
        Map<String, String> addedNamespaces = changeset.getAddedNamespaces();
        Set<String> removedPrefixes = changeset.getRemovedPrefixes();
        return changeset.namespaceCleared || addedNamespaces != null && !addedNamespaces.isEmpty() || removedPrefixes != null && !removedPrefixes.isEmpty();
    }

    private static boolean hasStatementChanges(Changeset changeset) {
        Set<Resource> deprecatedContexts = changeset.getDeprecatedContexts();
        return changeset.statementCleared || changeset.hasApproved() || changeset.hasDeprecated() || deprecatedContexts != null && !deprecatedContexts.isEmpty();
    }

    @Override
    public void close() throws SailException {
        this.closed = true;
        this.refbacks = null;
        this.prepend = null;
        this.observed = null;
        this.approved = null;
        this.deprecated = null;
        this.approvedContexts = null;
        this.deprecatedContexts = null;
        this.addedNamespaces = null;
        this.removedPrefixes = null;
    }

    @Override
    public void prepare() throws SailException {
        assert (!this.closed);
        if (this.prepend != null && this.observed != null) {
            for (SimpleStatementPattern p : this.observed) {
                Resource subj = p.getSubject();
                IRI pred = p.getPredicate();
                Value obj = p.getObject();
                Resource context = p.getContext();
                Resource[] contexts = p.isAllContexts() ? new Resource[]{} : new Resource[]{context};
                for (Changeset changeset : this.prepend) {
                    if (!changeset.hasApproved(subj, pred, obj, contexts) && !changeset.hasDeprecated(subj, pred, obj, contexts)) continue;
                    throw new SailConflictException("Observed State has Changed");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasApproved(Resource subj, IRI pred, Value obj, Resource[] contexts) {
        assert (!this.closed);
        if (this.approved == null || this.approvedEmpty) {
            return false;
        }
        boolean readLock = this.readWriteLock.readLock();
        try {
            boolean bl = this.approved.contains(subj, pred, obj, contexts);
            return bl;
        }
        finally {
            this.readWriteLock.unlockReader(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Experimental
    public boolean hasDeprecated(Resource subj, IRI pred, Value obj, Resource[] contexts) {
        assert (!this.closed);
        if ((this.deprecated == null || this.deprecatedEmpty) && this.deprecatedContexts == null) {
            return false;
        }
        boolean readLock = this.readWriteLock.readLock();
        try {
            if (this.deprecatedContexts != null) {
                for (Resource context : contexts) {
                    if (!this.deprecatedContexts.contains(context)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = this.deprecated.contains(subj, pred, obj, contexts);
            return bl;
        }
        finally {
            this.readWriteLock.unlockReader(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRefback(SailDatasetImpl dataset) {
        assert (!this.closed);
        long writeLock = this.refBacksReadWriteLock.writeLock();
        try {
            if (this.refbacks == null) {
                this.refbacks = new ArrayList<SailDatasetImpl>();
            }
            this.refbacks.add(dataset);
        }
        finally {
            this.refBacksReadWriteLock.unlockWriter(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRefback(SailDatasetImpl dataset) {
        assert (!this.closed);
        long writeLock = this.refBacksReadWriteLock.writeLock();
        try {
            if (this.refbacks != null) {
                this.refbacks.removeIf(d -> d == dataset);
            }
        }
        finally {
            this.refBacksReadWriteLock.unlockWriter(writeLock);
        }
    }

    public boolean isRefback() {
        assert (!this.closed);
        boolean readLock = this.refBacksReadWriteLock.readLock();
        try {
            boolean bl = this.refbacks != null && !this.refbacks.isEmpty();
            return bl;
        }
        finally {
            this.refBacksReadWriteLock.unlockReader(readLock);
        }
    }

    public void prepend(Changeset changeset) {
        assert (!this.closed);
        this.prependLock.acquireUninterruptibly();
        try {
            if (this.prepend == null) {
                this.prepend = Collections.newSetFromMap(new IdentityHashMap());
            }
            this.prepend.add(changeset);
        }
        finally {
            this.prependLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNamespace(String prefix, String name) {
        assert (!this.closed);
        long writeLock = this.readWriteLock.writeLock();
        try {
            if (this.removedPrefixes == null) {
                this.removedPrefixes = new HashSet<String>();
            }
            this.removedPrefixes.add(prefix);
            if (this.addedNamespaces == null) {
                this.addedNamespaces = new HashMap<String, String>();
            }
            this.addedNamespaces.put(prefix, name);
        }
        finally {
            this.readWriteLock.unlockWriter(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNamespace(String prefix) {
        assert (!this.closed);
        long writeLock = this.readWriteLock.writeLock();
        try {
            if (this.addedNamespaces != null) {
                this.addedNamespaces.remove(prefix);
            }
            if (this.removedPrefixes == null) {
                this.removedPrefixes = new HashSet<String>();
            }
            this.removedPrefixes.add(prefix);
        }
        finally {
            this.readWriteLock.unlockWriter(writeLock);
        }
    }

    @Override
    public void clearNamespaces() {
        assert (!this.closed);
        this.namespaceCleared = true;
        long writeLock = this.readWriteLock.writeLock();
        try {
            if (this.removedPrefixes != null) {
                this.removedPrefixes.clear();
            }
            if (this.addedNamespaces != null) {
                this.addedNamespaces.clear();
            }
        }
        finally {
            this.readWriteLock.unlockWriter(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void observe(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailConflictException {
        assert (!this.closed);
        long writeLock = this.readWriteLock.writeLock();
        try {
            if (this.observed == null) {
                this.observed = new HashSet<SimpleStatementPattern>();
            }
            if (contexts == null) {
                this.observed.add(new SimpleStatementPattern(subj, pred, obj, null, false));
            } else if (contexts.length == 0) {
                this.observed.add(new SimpleStatementPattern(subj, pred, obj, null, true));
            } else {
                for (Resource ctx : contexts) {
                    this.observed.add(new SimpleStatementPattern(subj, pred, obj, ctx, false));
                }
            }
        }
        finally {
            this.readWriteLock.unlockWriter(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void observe(Resource subj, IRI pred, Value obj, Resource context) throws SailConflictException {
        assert (!this.closed);
        long writeLock = this.readWriteLock.writeLock();
        try {
            if (this.observed == null) {
                this.observed = new HashSet<SimpleStatementPattern>();
            }
            this.observed.add(new SimpleStatementPattern(subj, pred, obj, context, false));
        }
        finally {
            this.readWriteLock.unlockWriter(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void observeAll(Set<SimpleStatementPattern> observed) {
        assert (!this.closed);
        long writeLock = this.readWriteLock.writeLock();
        try {
            if (this.observed == null) {
                this.observed = new HashSet<SimpleStatementPattern>(observed);
            } else {
                this.observed.addAll(observed);
            }
        }
        finally {
            this.readWriteLock.unlockWriter(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(Resource ... contexts) {
        long writeLock = this.readWriteLock.writeLock();
        try {
            if (contexts != null && contexts.length == 0) {
                this.statementCleared = true;
                if (this.approved != null) {
                    this.approved.clear();
                }
                if (this.approvedContexts != null) {
                    this.approvedContexts.clear();
                }
            } else {
                if (this.deprecatedContexts == null) {
                    this.deprecatedContexts = new HashSet<Resource>();
                }
                if (this.approved != null) {
                    this.approved.remove(null, null, null, contexts);
                }
                if (this.approvedContexts != null && contexts != null) {
                    for (Resource resource : contexts) {
                        this.approvedContexts.remove(resource);
                    }
                }
                if (contexts != null) {
                    this.deprecatedContexts.addAll(Arrays.asList(contexts));
                }
            }
            this.approvedEmpty = this.approved == null || this.approved.isEmpty();
        }
        finally {
            this.readWriteLock.unlockWriter(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void approve(Statement statement) {
        assert (!this.closed);
        long writeLock = this.readWriteLock.writeLock();
        try {
            if (this.deprecated != null) {
                this.deprecated.remove((Object)statement);
                boolean bl = this.deprecatedEmpty = this.deprecated == null || this.deprecated.isEmpty();
            }
            if (this.approved == null) {
                this.approved = this.createEmptyModel();
            }
            this.approved.add((Object)statement);
            boolean bl = this.approvedEmpty = this.approved == null || this.approved.isEmpty();
            if (statement.getContext() != null) {
                if (this.approvedContexts == null) {
                    this.approvedContexts = new HashSet<Resource>();
                }
                this.approvedContexts.add(statement.getContext());
            }
        }
        finally {
            this.readWriteLock.unlockWriter(writeLock);
        }
    }

    @Override
    public void approve(Resource subj, IRI pred, Value obj, Resource ctx) throws SailException {
        this.approve(Statements.statement((Resource)subj, (IRI)pred, (Value)obj, (Resource)ctx));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deprecate(Statement statement) {
        assert (!this.closed);
        long writeLock = this.readWriteLock.writeLock();
        try {
            if (this.approved != null) {
                this.approved.remove((Object)statement);
                boolean bl = this.approvedEmpty = this.approved == null || this.approved.isEmpty();
            }
            if (this.deprecated == null) {
                this.deprecated = this.createEmptyModel();
            }
            this.deprecated.add((Object)statement);
            this.deprecatedEmpty = this.deprecated == null || this.deprecated.isEmpty();
            Resource ctx = statement.getContext();
            if (this.approvedContexts != null && this.approvedContexts.contains(ctx) && !this.approved.contains(null, null, null, new Resource[]{ctx})) {
                this.approvedContexts.remove(ctx);
            }
        }
        finally {
            this.readWriteLock.unlockWriter(writeLock);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.observed != null) {
            sb.append(this.observed.size());
            sb.append(" observations, ");
        }
        if (this.namespaceCleared) {
            sb.append("namespaceCleared, ");
        }
        if (this.removedPrefixes != null) {
            sb.append(this.removedPrefixes.size());
            sb.append(" removedPrefixes, ");
        }
        if (this.addedNamespaces != null) {
            sb.append(this.addedNamespaces.size());
            sb.append(" addedNamespaces, ");
        }
        if (this.statementCleared) {
            sb.append("statementCleared, ");
        }
        if (this.deprecatedContexts != null && !this.deprecatedContexts.isEmpty()) {
            sb.append(this.deprecatedContexts.size());
            sb.append(" deprecatedContexts, ");
        }
        if (this.deprecated != null) {
            sb.append(this.deprecated.size());
            sb.append(" deprecated, ");
        }
        if (this.approved != null) {
            sb.append(this.approved.size());
            sb.append(" approved, ");
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 2);
        }
        return super.toString();
    }

    protected void setChangeset(Changeset from) {
        assert (!this.closed);
        assert (!from.closed);
        this.observed = from.observed;
        this.approved = from.approved;
        this.approvedEmpty = from.approvedEmpty;
        this.deprecated = from.deprecated;
        this.deprecatedEmpty = from.deprecatedEmpty;
        this.approvedContexts = from.approvedContexts;
        this.deprecatedContexts = from.deprecatedContexts;
        this.addedNamespaces = from.addedNamespaces;
        this.removedPrefixes = from.removedPrefixes;
        this.namespaceCleared = from.namespaceCleared;
        this.statementCleared = from.statementCleared;
    }

    public Changeset shallowClone() {
        assert (!this.closed);
        Changeset changeset = new Changeset(){

            @Override
            public void flush() throws SailException {
                throw new UnsupportedOperationException();
            }

            public Model createEmptyModel() {
                return Changeset.this.createEmptyModel();
            }
        };
        changeset.setChangeset(this);
        return changeset;
    }

    public Set<SimpleStatementPattern> getObserved() {
        assert (!this.closed);
        boolean readLock = this.readWriteLock.readLock();
        try {
            Set<SimpleStatementPattern> set = this.observed == null ? null : Collections.unmodifiableSet(this.observed);
            return set;
        }
        finally {
            this.readWriteLock.unlockReader(readLock);
        }
    }

    @Deprecated
    public Set<StatementPattern> getObservations() {
        assert (!this.closed);
        boolean readLock = this.readWriteLock.readLock();
        try {
            if (this.observed == null) {
                Set<StatementPattern> set = null;
                return set;
            }
            Set set = this.observed.stream().map(simpleStatementPattern -> new StatementPattern(Var.of((String)"s", (Value)simpleStatementPattern.getSubject()), Var.of((String)"p", (Value)simpleStatementPattern.getPredicate()), Var.of((String)"o", (Value)simpleStatementPattern.getObject()), simpleStatementPattern.isAllContexts() ? null : Var.of((String)"c", (Value)simpleStatementPattern.getContext()))).collect(Collectors.toCollection(HashSet::new));
            return set;
        }
        finally {
            this.readWriteLock.unlockReader(readLock);
        }
    }

    public Set<Resource> getApprovedContexts() {
        assert (!this.closed);
        boolean readLock = this.readWriteLock.readLock();
        try {
            Set<Resource> set = this.cloneSet(this.approvedContexts);
            return set;
        }
        finally {
            this.readWriteLock.unlockReader(readLock);
        }
    }

    public Set<Resource> getDeprecatedContexts() {
        assert (!this.closed);
        if (this.deprecatedContexts == null) {
            return null;
        }
        boolean readLock = this.readWriteLock.readLock();
        try {
            Set<Resource> set = this.cloneSet(this.deprecatedContexts);
            return set;
        }
        finally {
            this.readWriteLock.unlockReader(readLock);
        }
    }

    public boolean isStatementCleared() {
        assert (!this.closed);
        return this.statementCleared;
    }

    public Map<String, String> getAddedNamespaces() {
        assert (!this.closed);
        boolean readLock = this.readWriteLock.readLock();
        try {
            Map<String, String> map = this.addedNamespaces;
            return map;
        }
        finally {
            this.readWriteLock.unlockReader(readLock);
        }
    }

    public Set<String> getRemovedPrefixes() {
        assert (!this.closed);
        boolean readLock = this.readWriteLock.readLock();
        try {
            Set<String> set = this.cloneSet(this.removedPrefixes);
            return set;
        }
        finally {
            this.readWriteLock.unlockReader(readLock);
        }
    }

    public boolean isNamespaceCleared() {
        assert (!this.closed);
        return this.namespaceCleared;
    }

    public boolean hasDeprecated() {
        assert (!this.closed);
        if (this.deprecatedContexts == null) {
            return this.deprecated != null && !this.deprecatedEmpty;
        }
        boolean readLock = this.readWriteLock.readLock();
        try {
            boolean bl = this.deprecated != null && !this.deprecatedEmpty || !this.deprecatedContexts.isEmpty();
            return bl;
        }
        finally {
            this.readWriteLock.unlockReader(readLock);
        }
    }

    boolean isChanged() {
        assert (!this.closed);
        return this.approved != null || this.deprecated != null || this.approvedContexts != null || this.deprecatedContexts != null || this.addedNamespaces != null || this.removedPrefixes != null || this.statementCleared || this.namespaceCleared || this.observed != null;
    }

    List<Statement> getDeprecatedStatements() {
        assert (!this.closed);
        if (this.deprecated == null || this.deprecatedEmpty) {
            return Collections.emptyList();
        }
        boolean readLock = this.readWriteLock.readLock();
        try {
            ArrayList<Statement> arrayList = new ArrayList<Statement>((Collection<Statement>)this.deprecated);
            return arrayList;
        }
        finally {
            this.readWriteLock.unlockReader(readLock);
        }
    }

    List<Statement> getApprovedStatements() {
        assert (!this.closed);
        if (this.approved == null || this.approvedEmpty) {
            return Collections.emptyList();
        }
        boolean readLock = this.readWriteLock.readLock();
        try {
            ArrayList<Statement> arrayList = new ArrayList<Statement>((Collection<Statement>)this.approved);
            return arrayList;
        }
        finally {
            this.readWriteLock.unlockReader(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasDeprecated(Statement statement) {
        assert (!this.closed);
        if ((this.deprecated == null || this.deprecatedEmpty) && this.deprecatedContexts == null) {
            return false;
        }
        boolean readLock = this.readWriteLock.readLock();
        try {
            if (this.deprecatedContexts != null && this.deprecatedContexts.contains(statement.getContext())) {
                boolean bl = true;
                return bl;
            }
            if (this.deprecated != null) {
                boolean bl = this.deprecated.contains((Object)statement);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readWriteLock.unlockReader(readLock);
        }
    }

    boolean hasApproved() {
        assert (!this.closed);
        return this.approved != null && !this.approvedEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterable<Statement> getApprovedStatements(Resource subj, IRI pred, Value obj, Resource[] contexts) {
        assert (!this.closed);
        if (this.approved == null || this.approvedEmpty) {
            return Collections.emptyList();
        }
        boolean readLock = this.readWriteLock.readLock();
        try {
            Iterable statements = this.approved.getStatements(subj, pred, obj, contexts);
            if (statements instanceof Collection) {
                ArrayList<Statement> arrayList = new ArrayList<Statement>((Collection)statements);
                return arrayList;
            }
            List<Object> ret = List.of();
            for (Statement statement : statements) {
                if (ret.isEmpty()) {
                    ret = List.of(statement);
                    continue;
                }
                if (ret.size() == 1) {
                    ret = new ArrayList<Object>(ret);
                }
                ret.add(statement);
            }
            List<Object> list = ret;
            return list;
        }
        finally {
            this.readWriteLock.unlockReader(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterable<Triple> getApprovedTriples(Resource subj, IRI pred, Value obj) {
        assert (!this.closed);
        if (this.approved == null || this.approvedEmpty) {
            return Collections.emptyList();
        }
        boolean readLock = this.readWriteLock.readLock();
        try {
            Stream<Triple> approvedSubjectTriples = this.approved.parallelStream().filter(st -> st.getSubject().isTriple()).map(st -> (Triple)st.getSubject()).filter(t -> {
                if (subj != null && !subj.equals((Object)t.getSubject())) {
                    return false;
                }
                if (pred != null && !pred.equals((Object)t.getPredicate())) {
                    return false;
                }
                return obj == null || obj.equals((Object)t.getObject());
            });
            Stream<Triple> approvedObjectTriples = this.approved.parallelStream().filter(st -> st.getObject().isTriple()).map(st -> (Triple)st.getObject()).filter(t -> {
                if (subj != null && !subj.equals((Object)t.getSubject())) {
                    return false;
                }
                if (pred != null && !pred.equals((Object)t.getPredicate())) {
                    return false;
                }
                return obj == null || obj.equals((Object)t.getObject());
            });
            Iterable iterable = Stream.concat(approvedSubjectTriples, approvedObjectTriples).collect(Collectors.toList());
            return iterable;
        }
        finally {
            this.readWriteLock.unlockReader(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeApproved(Statement next) {
        block11: {
            assert (!this.closed);
            try {
                Model localApproved = this.approved;
                if (localApproved == null || this.readWriteLock.writeLock.isWriteLocked() || localApproved.contains((Object)next)) break block11;
                boolean readLock = this.readWriteLock.readLock();
                try {
                    if (this.approved != null && !this.approvedEmpty && !this.approved.contains((Object)next)) {
                        return;
                    }
                }
                finally {
                    this.readWriteLock.unlockReader(readLock);
                }
            }
            catch (ConcurrentModificationException localApproved) {
                // empty catch block
            }
        }
        long writeLock = this.readWriteLock.writeLock();
        try {
            if (this.approved != null) {
                this.approved.remove((Object)next);
                this.approvedEmpty = this.approved == null || this.approved.isEmpty();
            }
        }
        finally {
            this.readWriteLock.unlockWriter(writeLock);
        }
    }

    private <T> Set<T> cloneSet(Set<T> set) {
        assert (!this.closed);
        if (set == null) {
            return null;
        }
        return new HashSet<T>(set);
    }

    void sinkApproved(SailSink sink) {
        if (this.approved == null || this.approvedEmpty) {
            return;
        }
        boolean readLock = this.readWriteLock.readLock();
        try {
            if (this.approved != null) {
                sink.approveAll((Set<Statement>)this.approved, this.approvedContexts);
            }
        }
        finally {
            this.readWriteLock.unlockReader(readLock);
        }
    }

    void sinkDeprecated(SailSink sink) {
        if (this.deprecated == null || this.deprecatedEmpty) {
            return;
        }
        boolean readLock = this.readWriteLock.readLock();
        try {
            if (this.deprecated != null) {
                sink.deprecateAll((Set<Statement>)this.deprecated);
            }
        }
        finally {
            this.readWriteLock.unlockReader(readLock);
        }
    }

    public void sinkObserved(SailSink sink) {
        if (this.observed == null) {
            return;
        }
        boolean readLock = this.readWriteLock.readLock();
        try {
            if (this.observed != null) {
                sink.observeAll(this.observed);
            }
        }
        finally {
            this.readWriteLock.unlockReader(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void approveAll(Set<Statement> approve, Set<Resource> approveContexts) {
        long writeLock = this.readWriteLock.writeLock();
        try {
            if (this.deprecated != null) {
                this.deprecated.removeAll(approve);
            }
            if (this.approved == null) {
                this.approved = this.createEmptyModel();
            }
            this.approved.addAll(approve);
            boolean bl = this.approvedEmpty = this.approved == null || this.approved.isEmpty();
            if (approveContexts != null) {
                if (this.approvedContexts == null) {
                    this.approvedContexts = new HashSet<Resource>();
                }
                this.approvedContexts.addAll(approveContexts);
            }
        }
        finally {
            this.readWriteLock.unlockWriter(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deprecateAll(Set<Statement> deprecate) {
        long writeLock = this.readWriteLock.writeLock();
        try {
            if (this.approved != null) {
                this.approved.removeAll(deprecate);
                boolean bl = this.approvedEmpty = this.approved == null || this.approved.isEmpty();
            }
            if (this.deprecated == null) {
                this.deprecated = this.createEmptyModel();
            }
            this.deprecated.addAll(deprecate);
            this.deprecatedEmpty = this.deprecated == null || this.deprecated.isEmpty();
            for (Statement statement : deprecate) {
                Resource ctx = statement.getContext();
                if (this.approvedContexts == null || !this.approvedContexts.contains(ctx) || this.approved.contains(null, null, null, new Resource[]{ctx})) continue;
                this.approvedContexts.remove(ctx);
            }
        }
        finally {
            this.readWriteLock.unlockWriter(writeLock);
        }
    }

    private static class AdderBasedReadWriteLock {
        StampedLock writeLock = new StampedLock();
        private final LongAdder readersLocked = new LongAdder();
        private final LongAdder readersUnlocked = new LongAdder();

        private AdderBasedReadWriteLock() {
        }

        public boolean readLock() {
            block0: while (true) {
                this.readersLocked.increment();
                if (!this.writeLock.isWriteLocked()) {
                    return true;
                }
                this.readersUnlocked.increment();
                while (true) {
                    if (!this.writeLock.isWriteLocked()) continue block0;
                    Thread.onSpinWait();
                }
                break;
            }
        }

        public void unlockReader(boolean locked) {
            if (!locked) {
                throw new IllegalMonitorStateException();
            }
            VarHandle.acquireFence();
            this.readersUnlocked.increment();
        }

        public long writeLock() {
            long stamp = this.writeLock.writeLock();
            while (true) {
                long lockedSum;
                long unlockedSum;
                if ((unlockedSum = this.readersUnlocked.sum()) == (lockedSum = this.readersLocked.sum())) {
                    VarHandle.releaseFence();
                    return stamp;
                }
                Thread.onSpinWait();
            }
        }

        public void unlockWriter(long stamp) {
            this.writeLock.unlockWrite(stamp);
        }
    }

    public static class SimpleStatementPattern {
        private final Resource subject;
        private final IRI predicate;
        private final Value object;
        private final Resource context;
        private final boolean allContexts;

        public SimpleStatementPattern(Resource subject, IRI predicate, Value object, Resource context, boolean allContexts) {
            this.subject = subject;
            this.predicate = predicate;
            this.object = object;
            this.context = context;
            this.allContexts = allContexts;
        }

        public Resource getSubject() {
            return this.subject;
        }

        public IRI getPredicate() {
            return this.predicate;
        }

        public Value getObject() {
            return this.object;
        }

        public Resource getContext() {
            return this.context;
        }

        public boolean isAllContexts() {
            return this.allContexts;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleStatementPattern that = (SimpleStatementPattern)o;
            return this.allContexts == that.allContexts && Objects.equals(this.subject, that.subject) && Objects.equals(this.predicate, that.predicate) && Objects.equals(this.object, that.object) && Objects.equals(this.context, that.context);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.subject == null ? 0 : this.subject.hashCode());
            result = 31 * result + (this.predicate == null ? 0 : this.predicate.hashCode());
            result = 31 * result + (this.object == null ? 0 : this.object.hashCode());
            result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
            result = 31 * result + ((Object)this.allContexts).hashCode();
            return result;
        }
    }
}

