/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir.util.transform;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.queryrender.sparql.TupleExprIRRenderer;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrExists;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrFilter;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrGraph;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrMinus;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrOptional;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrPathTriple;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrService;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrStatementPattern;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrSubSelect;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrUnion;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrValues;
import org.eclipse.rdf4j.queryrender.sparql.ir.util.transform.BaseTransform;

public final class ApplyNegatedPropertySetTransform
extends BaseTransform {
    private ApplyNegatedPropertySetTransform() {
    }

    public static IrBGP apply(IrBGP bgp, TupleExprIRRenderer r) {
        if (bgp == null) {
            return null;
        }
        List<IrNode> in = bgp.getLines();
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        LinkedHashSet<IrNode> consumed = new LinkedHashSet<IrNode>();
        for (int i = 0; i < in.size(); ++i) {
            IrStatementPattern sp;
            String path;
            Var subj;
            IrBGP newInner;
            IrGraph g1;
            IrExists ex;
            IrBGP inner;
            IrFilter fNode;
            String nps;
            IrStatementPattern sp2;
            Var pVar;
            Object ns;
            String condText;
            IrFilter f;
            String nps2;
            NsText ns2;
            String condText2;
            IrFilter f2;
            IrNode n = in.get(i);
            if (consumed.contains(n)) continue;
            if (n instanceof IrFilter) {
                f2 = (IrFilter)n;
                condText2 = f2.getConditionText();
                NsText nsText = ns2 = condText2 == null ? null : ApplyNegatedPropertySetTransform.parseNegatedSetText(condText2);
                if (ns2 != null && !ns2.items.isEmpty() && ApplyNegatedPropertySetTransform.isAnonPathName(ns2.varName) && !out.isEmpty()) {
                    IrBGP grp;
                    IrNode last = (IrNode)out.get(out.size() - 1);
                    if (last instanceof IrBGP && (grp = (IrBGP)last).getLines().size() >= 2 && grp.getLines().get(0) instanceof IrValues && grp.getLines().get(1) instanceof IrGraph) {
                        IrStatementPattern sp3;
                        Var pVar2;
                        IrValues vals = (IrValues)grp.getLines().get(0);
                        IrGraph g = (IrGraph)grp.getLines().get(1);
                        if (g.getWhere() != null && g.getWhere().getLines().size() == 1 && g.getWhere().getLines().get(0) instanceof IrStatementPattern && (BaseTransform.isAnonPathVar(pVar2 = (sp3 = (IrStatementPattern)g.getWhere().getLines().get(0)).getPredicate()) || BaseTransform.isAnonPathInverseVar(pVar2))) {
                            boolean inv = BaseTransform.isAnonPathInverseVar(pVar2);
                            nps2 = inv ? "!(^" + ApplyNegatedPropertySetTransform.joinIrisWithPreferredOrder(ns2.items, r) + ")" : "!(" + ApplyNegatedPropertySetTransform.joinIrisWithPreferredOrder(ns2.items, r) + ")";
                            IrBGP inner2 = new IrBGP(false);
                            inner2.add(vals);
                            inner2.add(inv ? new IrPathTriple(sp3.getObject(), sp3.getObjectOverride(), nps2, sp3.getSubject(), sp3.getSubjectOverride(), IrPathTriple.fromStatementPatterns(sp3), false) : new IrPathTriple(sp3.getSubject(), sp3.getSubjectOverride(), nps2, sp3.getObject(), sp3.getObjectOverride(), IrPathTriple.fromStatementPatterns(sp3), false));
                            out.remove(out.size() - 1);
                            out.add(new IrGraph(g.getGraph(), inner2, g.isNewScope()));
                            continue;
                        }
                    }
                    if (out.size() >= 2 && out.get(out.size() - 2) instanceof IrValues && out.get(out.size() - 1) instanceof IrGraph) {
                        IrStatementPattern sp4;
                        Var pVar3;
                        IrValues vals = (IrValues)out.get(out.size() - 2);
                        IrGraph g = (IrGraph)out.get(out.size() - 1);
                        if (g.getWhere() != null && g.getWhere().getLines().size() == 1 && g.getWhere().getLines().get(0) instanceof IrStatementPattern && (BaseTransform.isAnonPathVar(pVar3 = (sp4 = (IrStatementPattern)g.getWhere().getLines().get(0)).getPredicate()) || BaseTransform.isAnonPathInverseVar(pVar3))) {
                            boolean inv = BaseTransform.isAnonPathInverseVar(pVar3);
                            String nps3 = inv ? "!(^" + ApplyNegatedPropertySetTransform.joinIrisWithPreferredOrder(ns2.items, r) + ")" : "!(" + ApplyNegatedPropertySetTransform.joinIrisWithPreferredOrder(ns2.items, r) + ")";
                            IrBGP inner3 = new IrBGP(!bgp.isNewScope());
                            inner3.add(vals);
                            inner3.add(inv ? new IrPathTriple(sp4.getObject(), sp4.getObjectOverride(), nps3, sp4.getSubject(), sp4.getSubjectOverride(), IrPathTriple.fromStatementPatterns(sp4), false) : new IrPathTriple(sp4.getSubject(), sp4.getSubjectOverride(), nps3, sp4.getObject(), sp4.getObjectOverride(), IrPathTriple.fromStatementPatterns(sp4), false));
                            out.remove(out.size() - 1);
                            out.remove(out.size() - 1);
                            out.add(new IrGraph(g.getGraph(), inner3, g.isNewScope()));
                            continue;
                        }
                    }
                }
            }
            if (n instanceof IrValues && i + 2 < in.size() && in.get(i + 1) instanceof IrGraph && in.get(i + 2) instanceof IrFilter) {
                IrValues vals = (IrValues)n;
                IrGraph g = (IrGraph)in.get(i + 1);
                f = (IrFilter)in.get(i + 2);
                condText = f.getConditionText();
                Object object = ns = condText == null ? null : ApplyNegatedPropertySetTransform.parseNegatedSetText(condText);
                if (ns != null && g.getWhere() != null && g.getWhere().getLines().size() == 1 && g.getWhere().getLines().get(0) instanceof IrStatementPattern && (BaseTransform.isAnonPathVar(pVar = (sp2 = (IrStatementPattern)g.getWhere().getLines().get(0)).getPredicate()) || BaseTransform.isAnonPathInverseVar(pVar)) && ApplyNegatedPropertySetTransform.isAnonPathName(((NsText)ns).varName) && !((NsText)ns).items.isEmpty()) {
                    IrPathTriple pt;
                    boolean inv = BaseTransform.isAnonPathInverseVar(pVar);
                    nps = inv ? "!(^" + ApplyNegatedPropertySetTransform.joinIrisWithPreferredOrder(((NsText)ns).items, r) + ")" : "!(" + ApplyNegatedPropertySetTransform.joinIrisWithPreferredOrder(((NsText)ns).items, r) + ")";
                    IrBGP newInner2 = new IrBGP(false);
                    newInner2.add(vals);
                    if (inv) {
                        pt = new IrPathTriple(sp2.getObject(), sp2.getObjectOverride(), nps, sp2.getSubject(), sp2.getSubjectOverride(), IrPathTriple.fromStatementPatterns(sp2), false);
                        newInner2.add(pt);
                    } else {
                        pt = new IrPathTriple(sp2.getSubject(), sp2.getSubjectOverride(), nps, sp2.getObject(), sp2.getObjectOverride(), IrPathTriple.fromStatementPatterns(sp2), false);
                        newInner2.add(pt);
                    }
                    out.add(new IrGraph(g.getGraph(), newInner2, g.isNewScope()));
                    i += 2;
                    continue;
                }
            }
            if (n instanceof IrFilter && i + 1 < in.size() && in.get(i + 1) instanceof IrBGP) {
                IrFilter f22 = (IrFilter)n;
                String condText22 = f22.getConditionText();
                NsText ns22 = condText22 == null ? null : ApplyNegatedPropertySetTransform.parseNegatedSetText(condText22);
                IrBGP grp2 = (IrBGP)in.get(i + 1);
                if (ns22 != null && grp2.getLines().size() >= 2 && grp2.getLines().get(0) instanceof IrValues && grp2.getLines().get(1) instanceof IrGraph) {
                    IrStatementPattern sp22;
                    Var pVar2;
                    IrValues vals2 = (IrValues)grp2.getLines().get(0);
                    IrGraph g2 = (IrGraph)grp2.getLines().get(1);
                    if (g2.getWhere() != null && g2.getWhere().getLines().size() == 1 && g2.getWhere().getLines().get(0) instanceof IrStatementPattern && (BaseTransform.isAnonPathVar(pVar2 = (sp22 = (IrStatementPattern)g2.getWhere().getLines().get(0)).getPredicate()) || BaseTransform.isAnonPathInverseVar(pVar2)) && ApplyNegatedPropertySetTransform.isAnonPathName(ns22.varName) && !ns22.items.isEmpty()) {
                        HashSet<Var> set2;
                        IrPathTriple pt2;
                        boolean inv2 = BaseTransform.isAnonPathInverseVar(pVar2);
                        String nps22 = inv2 ? "!(^" + ApplyNegatedPropertySetTransform.joinIrisWithPreferredOrder(ns22.items, r) + ")" : "!(" + ApplyNegatedPropertySetTransform.joinIrisWithPreferredOrder(ns22.items, r) + ")";
                        IrBGP newInner2 = new IrBGP(false);
                        newInner2.add(vals2);
                        if (inv2) {
                            pt2 = new IrPathTriple(sp22.getObject(), nps22, sp22.getSubject(), false, IrPathTriple.fromStatementPatterns(sp22));
                            set2 = new HashSet<Var>();
                            if (sp22.getPredicate() != null) {
                                set2.add(sp22.getPredicate());
                            }
                            pt2.setPathVars(set2);
                            newInner2.add(pt2);
                        } else {
                            pt2 = new IrPathTriple(sp22.getSubject(), nps22, sp22.getObject(), false, IrPathTriple.fromStatementPatterns(sp22));
                            set2 = new HashSet();
                            if (sp22.getPredicate() != null) {
                                set2.add(sp22.getPredicate());
                            }
                            pt2.setPathVars(set2);
                            newInner2.add(pt2);
                        }
                        out.add(new IrGraph(g2.getGraph(), newInner2, g2.isNewScope()));
                        ++i;
                        continue;
                    }
                }
            }
            if (n instanceof IrFilter && i + 2 < in.size() && in.get(i + 1) instanceof IrValues && in.get(i + 2) instanceof IrGraph) {
                f2 = (IrFilter)n;
                condText2 = f2.getConditionText();
                ns2 = condText2 == null ? null : ApplyNegatedPropertySetTransform.parseNegatedSetText(condText2);
                IrValues vals = (IrValues)in.get(i + 1);
                IrGraph g = (IrGraph)in.get(i + 2);
                if (ns2 != null && g.getWhere() != null && g.getWhere().getLines().size() == 1 && g.getWhere().getLines().get(0) instanceof IrStatementPattern && (BaseTransform.isAnonPathVar(pVar = (sp2 = (IrStatementPattern)g.getWhere().getLines().get(0)).getPredicate()) || BaseTransform.isAnonPathInverseVar(pVar)) && ApplyNegatedPropertySetTransform.isAnonPathName(ns2.varName) && !ns2.items.isEmpty()) {
                    boolean inv = BaseTransform.isAnonPathInverseVar(pVar);
                    nps = inv ? "!(^" + ApplyNegatedPropertySetTransform.joinIrisWithPreferredOrder(ns2.items, r) + ")" : "!(" + ApplyNegatedPropertySetTransform.joinIrisWithPreferredOrder(ns2.items, r) + ")";
                    IrBGP newInner3 = new IrBGP(false);
                    newInner3.add(vals);
                    if (inv) {
                        newInner3.add(new IrPathTriple(sp2.getObject(), sp2.getObjectOverride(), nps, sp2.getSubject(), sp2.getSubjectOverride(), IrPathTriple.fromStatementPatterns(sp2), false));
                    } else {
                        newInner3.add(new IrPathTriple(sp2.getSubject(), sp2.getSubjectOverride(), nps, sp2.getObject(), sp2.getObjectOverride(), IrPathTriple.fromStatementPatterns(sp2), false));
                    }
                    out.add(new IrGraph(g.getGraph(), newInner3, g.isNewScope()));
                    i += 2;
                    continue;
                }
            }
            if (n instanceof IrFilter && (fNode = (IrFilter)n).getBody() instanceof IrExists && (inner = (ex = (IrExists)fNode.getBody()).getWhere()) != null) {
                IrBGP orig = inner;
                inner = ApplyNegatedPropertySetTransform.rewriteSimpleNpsOnly(inner, r);
                inner = ApplyNegatedPropertySetTransform.fuseEligibleUnionInsideExists(inner, orig);
                IrFilter nf = new IrFilter(new IrExists(inner, ex.isNewScope()), fNode.isNewScope());
                out.add(nf);
                i += 0;
                continue;
            }
            if (n instanceof IrGraph && i + 1 < in.size() && in.get(i + 1) instanceof IrFilter) {
                MatchTriple mt0;
                NsText ns0;
                g1 = (IrGraph)n;
                IrFilter f3 = (IrFilter)in.get(i + 1);
                String condText0 = f3.getConditionText();
                NsText nsText = ns0 = condText0 == null ? null : ApplyNegatedPropertySetTransform.parseNegatedSetText(condText0);
                if (ns0 != null && ns0.varName != null && !ns0.items.isEmpty() && (mt0 = ApplyNegatedPropertySetTransform.findTripleWithPredicateVar(g1.getWhere(), ns0.varName)) != null) {
                    IrBGP inner4 = new IrBGP(false);
                    ApplyNegatedPropertySetTransform.copyAllExcept(g1.getWhere(), inner4, null);
                    inner4.add(f3);
                    out.add(new IrGraph(g1.getGraph(), inner4, g1.isNewScope()));
                    ++i;
                    continue;
                }
            }
            if (n instanceof IrGraph) {
                int j;
                g1 = (IrGraph)n;
                ns2 = null;
                for (j = i + 1; j < in.size() && in.get(j) instanceof IrFilter; ++j) {
                    NsText cand;
                    IrFilter f4 = (IrFilter)in.get(j);
                    String condText3 = f4.getConditionText();
                    if (condText3 == null || !condText3.contains("_anon_path_") || (cand = ApplyNegatedPropertySetTransform.parseNegatedSetText(condText3)) == null || cand.varName == null || cand.items.isEmpty()) continue;
                    ns2 = cand;
                    break;
                }
                if (ns2 != null) {
                    IrStatementPattern sp23;
                    int k;
                    MatchTriple mt1 = ApplyNegatedPropertySetTransform.findTripleWithPredicateVar(g1.getWhere(), ns2.varName);
                    if (mt1 == null) {
                        out.add(n);
                        continue;
                    }
                    boolean consumedG2 = false;
                    MatchTriple mt2 = null;
                    for (k = j + 1; k < in.size() && in.get(k) instanceof IrFilter; ++k) {
                    }
                    if (k < in.size() && in.get(k) instanceof IrGraph) {
                        IrGraph g2 = (IrGraph)in.get(k);
                        if (ApplyNegatedPropertySetTransform.sameVarOrValue(g1.getGraph(), g2.getGraph())) {
                            mt2 = ApplyNegatedPropertySetTransform.findTripleWithConstPredicateReusingObject(g2.getWhere(), mt1.object);
                            consumedG2 = mt2 != null;
                        }
                    } else if (k < in.size() && in.get(k) instanceof IrStatementPattern && ApplyNegatedPropertySetTransform.isConstantIriPredicate(sp23 = (IrStatementPattern)in.get(k)) && (ApplyNegatedPropertySetTransform.sameVar(mt1.object, sp23.getSubject()) || ApplyNegatedPropertySetTransform.sameVar(mt1.object, sp23.getObject()))) {
                        mt2 = new MatchTriple(sp23, sp23.getSubject(), sp23.getPredicate(), sp23.getObject());
                        consumedG2 = true;
                    }
                    newInner = new IrBGP(false);
                    subj = mt1.subject;
                    Var obj = mt1.object;
                    String npsTxt = "!(" + ApplyNegatedPropertySetTransform.joinIrisWithPreferredOrder(ns2.items, r) + ")";
                    if (mt2 != null) {
                        boolean inverse;
                        boolean forward = ApplyNegatedPropertySetTransform.sameVar(mt1.object, mt2.subject);
                        boolean bl = inverse = !forward && ApplyNegatedPropertySetTransform.sameVar(mt1.object, mt2.object);
                        if (forward || inverse) {
                            String step = ApplyNegatedPropertySetTransform.iri(mt2.predicate, r);
                            String path2 = npsTxt + "/" + (inverse ? "^" : "") + step;
                            Var end = forward ? mt2.object : mt2.subject;
                            IrStatementPattern srcSp = mt1.node instanceof IrStatementPattern ? (IrStatementPattern)mt1.node : null;
                            newInner.add(new IrPathTriple(subj, path2, end, false, IrPathTriple.fromStatementPatterns(srcSp)));
                        } else {
                            IrStatementPattern srcSp = mt1.node instanceof IrStatementPattern ? (IrStatementPattern)mt1.node : null;
                            newInner.add(new IrPathTriple(subj, npsTxt, obj, false, IrPathTriple.fromStatementPatterns(srcSp)));
                        }
                    } else {
                        IrStatementPattern srcSp = mt1.node instanceof IrStatementPattern ? (IrStatementPattern)mt1.node : null;
                        newInner.add(new IrPathTriple(subj, npsTxt, obj, false, IrPathTriple.fromStatementPatterns(srcSp)));
                    }
                    ApplyNegatedPropertySetTransform.copyAllExcept(g1.getWhere(), newInner, mt1.node);
                    if (consumedG2) {
                        IrGraph g2 = (IrGraph)in.get(k);
                        ApplyNegatedPropertySetTransform.copyAllExcept(g2.getWhere(), newInner, mt2.node);
                    }
                    out.add(new IrGraph(g1.getGraph(), newInner, g1.isNewScope()));
                    for (int t = i + 1; t < j; ++t) {
                        out.add(in.get(t));
                    }
                    i = consumedG2 ? k : j;
                    continue;
                }
            }
            if (n instanceof IrGraph && i + 2 < in.size() && in.get(i + 1) instanceof IrGraph && in.get(i + 2) instanceof IrFilter) {
                IrStatementPattern srcSp;
                g1 = (IrGraph)n;
                IrGraph g2 = (IrGraph)in.get(i + 1);
                f = (IrFilter)in.get(i + 2);
                String condText23 = f.getConditionText();
                if (condText23 == null) {
                    out.add(n);
                    continue;
                }
                ns = ApplyNegatedPropertySetTransform.parseNegatedSetText(condText23);
                if (ns == null || ((NsText)ns).varName == null || ((NsText)ns).items.isEmpty()) {
                    out.add(n);
                    continue;
                }
                if (!ApplyNegatedPropertySetTransform.sameVarOrValue(g1.getGraph(), g2.getGraph())) {
                    out.add(n);
                    continue;
                }
                MatchTriple mt1 = ApplyNegatedPropertySetTransform.findTripleWithPredicateVar(g1.getWhere(), ((NsText)ns).varName);
                MatchTriple mt2 = ApplyNegatedPropertySetTransform.findTripleWithConstPredicateReusingObject(g2.getWhere(), mt1 == null ? null : mt1.object);
                if (mt1 == null) {
                    out.add(n);
                    continue;
                }
                newInner = new IrBGP(false);
                subj = mt1.subject;
                Var obj = mt1.object;
                nps2 = "!(" + ApplyNegatedPropertySetTransform.joinIrisWithPreferredOrder(((NsText)ns).items, r) + ")";
                IrStatementPattern irStatementPattern = srcSp = mt1.node instanceof IrStatementPattern ? (IrStatementPattern)mt1.node : null;
                if (mt2 != null) {
                    boolean forward = ApplyNegatedPropertySetTransform.sameVar(mt1.object, mt2.subject);
                    boolean inverse = !forward && ApplyNegatedPropertySetTransform.sameVar(mt1.object, mt2.object);
                    String step = ApplyNegatedPropertySetTransform.iri(mt2.predicate, r);
                    path = nps2 + "/" + (inverse ? "^" : "") + step;
                    Var end = forward ? mt2.object : mt2.subject;
                    newInner.add(new IrPathTriple(subj, path, end, false, IrPathTriple.fromStatementPatterns(srcSp)));
                } else {
                    newInner.add(new IrPathTriple(subj, nps2, obj, false, IrPathTriple.fromStatementPatterns(srcSp)));
                }
                ApplyNegatedPropertySetTransform.copyAllExcept(g1.getWhere(), newInner, mt1.node);
                if (mt2 != null) {
                    ApplyNegatedPropertySetTransform.copyAllExcept(g2.getWhere(), newInner, mt2.node);
                }
                out.add(new IrGraph(g1.getGraph(), newInner, g1.isNewScope()));
                i += 2;
                continue;
            }
            if (n instanceof IrUnion) {
                IrUnion u = (IrUnion)n;
                boolean shareCommonAnon = ApplyNegatedPropertySetTransform.unionBranchesShareCommonAnonPathVarName(u);
                boolean allHaveAnon = ApplyNegatedPropertySetTransform.unionBranchesAllHaveAnonPathBridge(u);
                IrUnion u2 = new IrUnion(u.isNewScope());
                u2.setNewScope(u.isNewScope());
                ns = u.getBranches().iterator();
                while (ns.hasNext()) {
                    IrBGP b = (IrBGP)ns.next();
                    IrBGP rb = ApplyNegatedPropertySetTransform.rewriteSimpleNpsOnly(b, r);
                    if (rb != null) {
                        IrBGP inner5;
                        rb.setNewScope(b.isNewScope());
                        IrBGP cur = rb;
                        while (!cur.isNewScope() && cur.getLines().size() == 1 && cur.getLines().get(0) instanceof IrBGP && !(inner5 = (IrBGP)cur.getLines().get(0)).isNewScope()) {
                            cur = inner5;
                        }
                        rb = cur;
                    }
                    u2.addBranch(rb);
                }
                IrNode fused = null;
                if (ApplyNegatedPropertySetTransform.unionIsExplicitAndAllBranchesScoped(u)) {
                    out.add(u2);
                    continue;
                }
                if (u2.getBranches().size() == 2) {
                    boolean allow;
                    boolean bl = allow = !u.isNewScope() && allHaveAnon || u.isNewScope() && shareCommonAnon;
                    if (allow) {
                        fused = ApplyNegatedPropertySetTransform.tryFuseTwoNpsBranches(u2);
                    }
                }
                out.add(fused != null ? fused : u2);
                continue;
            }
            if (n instanceof IrGraph && i + 1 < in.size() && in.get(i + 1) instanceof IrFilter) {
                IrStatementPattern sp5;
                Var pVar4;
                NsText ns3;
                IrGraph g = (IrGraph)n;
                IrFilter f5 = (IrFilter)in.get(i + 1);
                String condText4 = f5.getConditionText();
                NsText nsText = ns3 = condText4 == null ? null : ApplyNegatedPropertySetTransform.parseNegatedSetText(condText4);
                if (ns3 != null && g.getWhere() != null && g.getWhere().getLines().size() == 1 && g.getWhere().getLines().get(0) instanceof IrStatementPattern && (BaseTransform.isAnonPathVar(pVar4 = (sp5 = (IrStatementPattern)g.getWhere().getLines().get(0)).getPredicate()) || BaseTransform.isAnonPathInverseVar(pVar4)) && pVar4.getName().equals(ns3.varName) && !ns3.items.isEmpty()) {
                    boolean inv = BaseTransform.isAnonPathInverseVar(pVar4);
                    String nps4 = inv ? "!(^" + ApplyNegatedPropertySetTransform.joinIrisWithPreferredOrder(ns3.items, r) + ")" : "!(" + ApplyNegatedPropertySetTransform.joinIrisWithPreferredOrder(ns3.items, r) + ")";
                    IrBGP newInner4 = new IrBGP(false);
                    if (!out.isEmpty() && out.get(out.size() - 1) instanceof IrValues) {
                        IrValues prevVals = (IrValues)out.remove(out.size() - 1);
                        newInner4.add(prevVals);
                    }
                    if (inv) {
                        newInner4.add(new IrPathTriple(sp5.getObject(), sp5.getObjectOverride(), nps4, sp5.getSubject(), sp5.getSubjectOverride(), IrPathTriple.fromStatementPatterns(sp5), false));
                    } else {
                        newInner4.add(new IrPathTriple(sp5.getSubject(), sp5.getSubjectOverride(), nps4, sp5.getObject(), sp5.getObjectOverride(), IrPathTriple.fromStatementPatterns(sp5), false));
                    }
                    out.add(new IrGraph(g.getGraph(), newInner4, g.isNewScope()));
                    ++i;
                    continue;
                }
            }
            if (n instanceof IrStatementPattern && i + 1 < in.size() && in.get(i + 1) instanceof IrFilter) {
                boolean hasTail;
                sp = (IrStatementPattern)n;
                Var pVar5 = sp.getPredicate();
                f = (IrFilter)in.get(i + 1);
                condText = f.getConditionText();
                ns = condText == null ? null : ApplyNegatedPropertySetTransform.parseNegatedSetText(condText);
                boolean bl = hasTail = i + 2 < in.size() && in.get(i + 2) instanceof IrStatementPattern && ((IrStatementPattern)in.get(i + 2)).getPredicate() != null && ((IrStatementPattern)in.get(i + 2)).getPredicate().hasValue();
                if (!hasTail && BaseTransform.isAnonPathVar(pVar5) && ns != null && pVar5.getName().equals(((NsText)ns).varName) && !((NsText)ns).items.isEmpty()) {
                    String nps5;
                    if (ApplyNegatedPropertySetTransform.isAnonPathInverseVar(pVar5)) {
                        nps5 = "!(^" + ApplyNegatedPropertySetTransform.joinIrisWithPreferredOrder(((NsText)ns).items, r) + ")";
                        out.add(new IrPathTriple(sp.getObject(), sp.getObjectOverride(), nps5, sp.getSubject(), sp.getSubjectOverride(), IrPathTriple.fromStatementPatterns(sp), false));
                        ++i;
                        continue;
                    }
                    nps5 = "!(" + ApplyNegatedPropertySetTransform.joinIrisWithPreferredOrder(((NsText)ns).items, r) + ")";
                    out.add(new IrPathTriple(sp.getSubject(), sp.getSubjectOverride(), nps5, sp.getObject(), sp.getObjectOverride(), IrPathTriple.fromStatementPatterns(sp), false));
                    ++i;
                    continue;
                }
            }
            if (n instanceof IrStatementPattern && i + 2 < in.size() && in.get(i + 1) instanceof IrFilter && in.get(i + 2) instanceof IrStatementPattern) {
                Var tp;
                sp = (IrStatementPattern)n;
                Var pVar6 = sp.getPredicate();
                f = (IrFilter)in.get(i + 1);
                condText = f.getConditionText();
                ns = condText == null ? null : ApplyNegatedPropertySetTransform.parseNegatedSetText(condText);
                IrStatementPattern tail = (IrStatementPattern)in.get(i + 2);
                if (BaseTransform.isAnonPathVar(pVar6) && ns != null && pVar6.getName() != null && pVar6.getName().equals(((NsText)ns).varName) && !((NsText)ns).items.isEmpty() && (tp = tail.getPredicate()) != null && tp.hasValue() && tp.getValue() instanceof IRI && BaseTransform.sameVar(sp.getSubject(), tail.getSubject())) {
                    String base = "!(" + ApplyNegatedPropertySetTransform.joinIrisWithPreferredOrder(((NsText)ns).items, r) + ")";
                    String inv = ApplyNegatedPropertySetTransform.invertNegatedPropertySet(base);
                    String step = ApplyNegatedPropertySetTransform.iri(tp, r);
                    String path3 = inv + "/" + step;
                    IrPathTriple pt3 = new IrPathTriple(sp.getObject(), sp.getObjectOverride(), path3, tail.getObject(), tail.getObjectOverride(), IrPathTriple.fromStatementPatterns(sp, tail), false);
                    out.add(pt3);
                    i += 2;
                    continue;
                }
            }
            if (n instanceof IrStatementPattern && i + 1 < in.size() && in.get(i + 1) instanceof IrFilter) {
                NsText ns23;
                IrStatementPattern spVar = (IrStatementPattern)n;
                Var pVar7 = spVar.getPredicate();
                IrFilter f23 = (IrFilter)in.get(i + 1);
                String condText3 = f23.getConditionText();
                NsText nsText = ns23 = condText3 == null ? null : ApplyNegatedPropertySetTransform.parseNegatedSetText(condText3);
                if (BaseTransform.isAnonPathVar(pVar7) && ns23 != null && pVar7.getName().equals(ns23.varName) && !ns23.items.isEmpty()) {
                    IrStatementPattern k1 = null;
                    boolean k1Inverse = false;
                    Var startVar = null;
                    for (int j = 0; j < in.size(); ++j) {
                        IrStatementPattern sp6;
                        IrNode cand;
                        if (j == i || !((cand = in.get(j)) instanceof IrStatementPattern) || !ApplyNegatedPropertySetTransform.isConstantIriPredicate(sp6 = (IrStatementPattern)cand)) continue;
                        if (ApplyNegatedPropertySetTransform.sameVar(sp6.getSubject(), spVar.getSubject()) && !ApplyNegatedPropertySetTransform.isAnonPathVar(sp6.getObject())) {
                            k1 = sp6;
                            k1Inverse = true;
                            startVar = sp6.getObject();
                            break;
                        }
                        if (!ApplyNegatedPropertySetTransform.sameVar(sp6.getObject(), spVar.getSubject()) || ApplyNegatedPropertySetTransform.isAnonPathVar(sp6.getSubject())) continue;
                        k1 = sp6;
                        k1Inverse = false;
                        startVar = sp6.getSubject();
                        break;
                    }
                    IrStatementPattern k2 = null;
                    boolean k2Inverse = false;
                    Var endVar = null;
                    for (int j = i + 2; j < in.size(); ++j) {
                        IrStatementPattern sp7;
                        IrNode cand = in.get(j);
                        if (!(cand instanceof IrStatementPattern) || !ApplyNegatedPropertySetTransform.isConstantIriPredicate(sp7 = (IrStatementPattern)cand)) continue;
                        if (ApplyNegatedPropertySetTransform.sameVar(sp7.getSubject(), spVar.getObject()) && !ApplyNegatedPropertySetTransform.isAnonPathVar(sp7.getObject())) {
                            k2 = sp7;
                            k2Inverse = false;
                            endVar = sp7.getObject();
                            break;
                        }
                        if (!ApplyNegatedPropertySetTransform.sameVar(sp7.getObject(), spVar.getObject()) || ApplyNegatedPropertySetTransform.isAnonPathVar(sp7.getSubject())) continue;
                        k2 = sp7;
                        k2Inverse = true;
                        endVar = sp7.getSubject();
                        break;
                    }
                    if (k1 != null && k2 != null && startVar != null && endVar != null) {
                        String k1Step = ApplyNegatedPropertySetTransform.iri(k1.getPredicate(), r);
                        String k2Step = ApplyNegatedPropertySetTransform.iri(k2.getPredicate(), r);
                        ArrayList<String> rev = new ArrayList<String>(ns23.items);
                        String nps6 = "!(" + String.join((CharSequence)"|", rev) + ")";
                        path = (String)(k1Inverse ? "^" + k1Step : k1Step) + "/" + nps6 + "/" + (String)(k2Inverse ? "^" + k2Step : k2Step);
                        out.add(new IrPathTriple(startVar, "(" + path + ")", endVar, false, IrPathTriple.fromStatementPatterns(spVar)));
                        for (int rm = out.size() - 1; rm >= 0; --rm) {
                            if (out.get(rm) != k1) continue;
                            out.remove(rm);
                            break;
                        }
                        consumed.add(spVar);
                        consumed.add(in.get(i + 1));
                        consumed.add(k1);
                        consumed.add(k2);
                        ++i;
                        continue;
                    }
                }
            }
            if (n instanceof IrBGP) {
                out.add(ApplyNegatedPropertySetTransform.apply((IrBGP)n, r));
                continue;
            }
            if (n instanceof IrGraph || n instanceof IrOptional || n instanceof IrMinus || n instanceof IrSubSelect || n instanceof IrService) {
                n = n.transformChildren(child -> {
                    if (child instanceof IrBGP) {
                        return ApplyNegatedPropertySetTransform.apply((IrBGP)child, r);
                    }
                    return child;
                });
            }
            out.add(n);
        }
        return BaseTransform.bgpWithLines(bgp, out);
    }

    private static IrNode tryFuseTwoNpsBranches(IrUnion u) {
        IrNode fused;
        String pB;
        if (u == null || u.getBranches().size() != 2) {
            return null;
        }
        if (ApplyNegatedPropertySetTransform.unionIsExplicitAndAllBranchesScoped(u)) {
            return u;
        }
        PT a = ApplyNegatedPropertySetTransform.extractNpsPath(u.getBranches().get(0));
        PT b = ApplyNegatedPropertySetTransform.extractNpsPath(u.getBranches().get(1));
        if (a == null || b == null) {
            return null;
        }
        if (a.g == null && b.g != null || a.g != null && b.g == null || a.g != null && !ApplyNegatedPropertySetTransform.sameVarOrValue(a.g, b.g)) {
            return null;
        }
        String pA = ApplyNegatedPropertySetTransform.normalizeCompactNpsLocal(a.pt.getPathText());
        String toAddB = pB = ApplyNegatedPropertySetTransform.normalizeCompactNpsLocal(b.pt.getPathText());
        if (ApplyNegatedPropertySetTransform.sameVar(a.pt.getSubject(), b.pt.getObject()) && ApplyNegatedPropertySetTransform.sameVar(a.pt.getObject(), b.pt.getSubject())) {
            String inv = ApplyNegatedPropertySetTransform.invertNegatedPropertySet(pB);
            if (inv == null) {
                return null;
            }
            toAddB = inv;
        } else if (!ApplyNegatedPropertySetTransform.sameVar(a.pt.getSubject(), b.pt.getSubject()) || !ApplyNegatedPropertySetTransform.sameVar(a.pt.getObject(), b.pt.getObject())) {
            return null;
        }
        ArrayList<String> mem = new ArrayList<String>();
        ApplyNegatedPropertySetTransform.addMembers(pA, mem);
        ApplyNegatedPropertySetTransform.addMembers(toAddB, mem);
        String merged = "!(" + String.join((CharSequence)"|", mem) + ")";
        IrPathTriple mergedPt = new IrPathTriple(a.pt.getSubject(), merged, a.pt.getObject(), false, IrPathTriple.mergePathVars(a.pt, b.pt));
        if (a.g != null) {
            IrBGP inner = new IrBGP(false);
            inner.add(mergedPt);
            fused = new IrGraph(a.g, inner, false);
        } else {
            fused = mergedPt;
        }
        if (u.isNewScope()) {
            IrBGP grp = new IrBGP(false);
            grp.add(fused);
            return grp;
        }
        return fused;
    }

    private static PT extractNpsPath(IrBGP b) {
        IrNode only;
        PT res = new PT();
        if (b == null) {
            return null;
        }
        IrNode irNode = only = b.getLines().size() == 1 ? b.getLines().get(0) : null;
        if (only instanceof IrGraph) {
            IrGraph g = (IrGraph)only;
            if (g.getWhere() == null || g.getWhere().getLines().size() != 1) {
                return null;
            }
            IrNode inner = g.getWhere().getLines().get(0);
            if (!(inner instanceof IrPathTriple)) {
                return null;
            }
            res.g = g.getGraph();
            res.pt = (IrPathTriple)inner;
            return res;
        }
        if (only instanceof IrPathTriple) {
            res.g = null;
            res.pt = (IrPathTriple)only;
            return res;
        }
        return null;
    }

    private static IrBGP fuseEligibleUnionInsideExists(IrBGP rewritten, IrBGP original) {
        if (rewritten == null || original == null) {
            return rewritten;
        }
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        boolean fusedOnce = false;
        for (IrNode ln : rewritten.getLines()) {
            IrNode fused;
            if (!fusedOnce && ln instanceof IrUnion && (fused = ApplyNegatedPropertySetTransform.tryFuseTwoNpsBranches((IrUnion)ln)) != null) {
                out.add(fused);
                fusedOnce = true;
                continue;
            }
            out.add(ln);
        }
        if (!fusedOnce) {
            return rewritten;
        }
        return BaseTransform.bgpWithLines(rewritten, out);
    }

    private static String normalizeCompactNpsLocal(String path) {
        if (path == null) {
            return null;
        }
        String t = path.trim();
        if (t.isEmpty()) {
            return null;
        }
        if (t.startsWith("!(") && t.endsWith(")")) {
            return t;
        }
        if (t.startsWith("!^")) {
            String inner = t.substring(1);
            return "!(" + inner + ")";
        }
        if (t.startsWith("!") && t.length() > 1 && t.charAt(1) != '(') {
            return "!(" + t.substring(1) + ")";
        }
        return t;
    }

    private static boolean isAnonPathName(String name) {
        return name != null && (name.startsWith("_anon_path_") || name.startsWith("_anon_path_inverse_"));
    }

    private static void addMembers(String npsPath, List<String> out) {
        if (npsPath == null) {
            return;
        }
        int s = npsPath.indexOf(40);
        int e = npsPath.lastIndexOf(41);
        if (s < 0 || e < 0 || e <= s) {
            return;
        }
        String inner = npsPath.substring(s + 1, e);
        for (String tok : inner.split("\\|")) {
            String t = tok.trim();
            if (t.isEmpty()) continue;
            out.add(t);
        }
    }

    public static IrBGP rewriteSimpleNpsOnly(IrBGP bgp, TupleExprIRRenderer r) {
        if (bgp == null) {
            return null;
        }
        List<IrNode> in = bgp.getLines();
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        HashSet<IrNode> consumed = new HashSet<IrNode>();
        boolean propagateScopeFromConsumedFilter = false;
        for (int i = 0; i < in.size(); ++i) {
            IrNode n = in.get(i);
            if (consumed.contains(n)) continue;
            if (n instanceof IrStatementPattern && i + 1 < in.size() && in.get(i + 1) instanceof IrFilter) {
                NsText ns;
                IrStatementPattern sp = (IrStatementPattern)n;
                Var pVar = sp.getPredicate();
                IrFilter f = (IrFilter)in.get(i + 1);
                String condText4 = f.getConditionText();
                NsText nsText = ns = condText4 == null ? null : ApplyNegatedPropertySetTransform.parseNegatedSetText(condText4);
                if (BaseTransform.isAnonPathVar(pVar) && ns != null && pVar.getName().equals(ns.varName) && !ns.items.isEmpty()) {
                    String maybe;
                    Object nps = "!(" + ApplyNegatedPropertySetTransform.joinIrisWithPreferredOrder(ns.items, r) + ")";
                    boolean inv = BaseTransform.isAnonPathInverseVar(pVar);
                    if (inv && (maybe = ApplyNegatedPropertySetTransform.invertNegatedPropertySet((String)nps)) != null) {
                        nps = maybe;
                    }
                    Var sVar = inv ? sp.getObject() : sp.getSubject();
                    Var oVar = inv ? sp.getSubject() : sp.getObject();
                    out.add(new IrPathTriple(sVar, (String)nps, oVar, false, IrPathTriple.fromStatementPatterns(sp)));
                    consumed.add(sp);
                    consumed.add(in.get(i + 1));
                    ++i;
                    continue;
                }
            }
            if (n instanceof IrGraph && i + 1 < in.size() && in.get(i + 1) instanceof IrFilter) {
                IrStatementPattern sp;
                Var pVar;
                NsText ns;
                IrGraph g = (IrGraph)n;
                IrFilter f = (IrFilter)in.get(i + 1);
                String condText5 = f.getConditionText();
                NsText nsText = ns = condText5 == null ? null : ApplyNegatedPropertySetTransform.parseNegatedSetText(condText5);
                if (ns != null && ns.varName != null && !ns.items.isEmpty() && g.getWhere() != null && g.getWhere().getLines().size() == 1 && g.getWhere().getLines().get(0) instanceof IrStatementPattern && BaseTransform.isAnonPathVar(pVar = (sp = (IrStatementPattern)g.getWhere().getLines().get(0)).getPredicate()) && pVar.getName().equals(ns.varName)) {
                    String maybe;
                    Object nps = "!(" + ApplyNegatedPropertySetTransform.joinIrisWithPreferredOrder(ns.items, r) + ")";
                    boolean inv = BaseTransform.isAnonPathInverseVar(pVar);
                    if (inv && (maybe = ApplyNegatedPropertySetTransform.invertNegatedPropertySet((String)nps)) != null) {
                        nps = maybe;
                    }
                    IrBGP newInner = new IrBGP(false);
                    Var sVar = inv ? sp.getObject() : sp.getSubject();
                    Var oVar = inv ? sp.getSubject() : sp.getObject();
                    IrNode sOverride = inv ? sp.getObjectOverride() : sp.getSubjectOverride();
                    IrNode oOverride = inv ? sp.getSubjectOverride() : sp.getObjectOverride();
                    newInner.add(new IrPathTriple(sVar, sOverride, (String)nps, oVar, oOverride, IrPathTriple.fromStatementPatterns(sp), false));
                    out.add(new IrGraph(g.getGraph(), newInner, g.isNewScope()));
                    consumed.add(g);
                    consumed.add(in.get(i + 1));
                    if (f.isNewScope()) {
                        propagateScopeFromConsumedFilter = true;
                    }
                    ++i;
                    continue;
                }
            }
            n = n.transformChildren(child -> {
                if (child instanceof IrBGP) {
                    return ApplyNegatedPropertySetTransform.rewriteSimpleNpsOnly((IrBGP)child, r);
                }
                return child;
            });
            out.add(n);
        }
        IrBGP res = new IrBGP(bgp.isNewScope());
        for (IrNode n : out) {
            if (consumed.contains(n)) continue;
            res.add(n);
        }
        if (propagateScopeFromConsumedFilter) {
            res.setNewScope(true);
        } else {
            res.setNewScope(bgp.isNewScope());
        }
        return res;
    }

    public static NsText parseNegatedSetText(String condText) {
        ArrayList<String> items;
        if (condText == null) {
            return null;
        }
        String s = condText.trim();
        Matcher mNotIn = Pattern.compile("(?i)(\\?[A-Za-z_]\\w*)\\s+NOT\\s+IN\\s*\\(([^)]*)\\)").matcher(s);
        if (mNotIn.find()) {
            String var = mNotIn.group(1);
            String inner = mNotIn.group(2);
            items = new ArrayList<String>();
            for (String t : inner.split(",")) {
                String tok = t.trim();
                if (tok.isEmpty()) continue;
                if (tok.startsWith("<") || tok.matches("[A-Za-z_][\\w.-]*:[^\\s,()]+")) {
                    items.add(tok);
                    continue;
                }
                return null;
            }
            if (!items.isEmpty()) {
                return new NsText(var.startsWith("?") ? var.substring(1) : var, items);
            }
        }
        if (s.contains("||")) {
            return null;
        }
        String[] parts = s.split("&&");
        String var = null;
        items = new ArrayList();
        Pattern pLeft = Pattern.compile("[\\s()]*\\?(?<var>[A-Za-z_]\\w*)\\s*!=\\s*(?<iri>[^\\s()]+)[\\s()]*");
        Pattern pRight = Pattern.compile("[\\s()]*(?<iri>[^\\s()]+)\\s*!=\\s*\\?(?<var>[A-Za-z_]\\w*)[\\s()]*");
        for (String part : parts) {
            String iriTxt;
            String vName;
            String term = part.trim();
            if (term.isEmpty()) {
                return null;
            }
            Matcher ml = pLeft.matcher(term);
            Matcher mr = pRight.matcher(term);
            if (ml.find()) {
                vName = ml.group("var");
                iriTxt = ml.group("iri");
            } else if (mr.find()) {
                vName = mr.group("var");
                iriTxt = mr.group("iri");
            } else {
                return null;
            }
            if (vName == null || vName.isEmpty()) {
                return null;
            }
            String tok = iriTxt;
            if (!tok.startsWith("<") && !tok.matches("[A-Za-z_][\\w.-]*:[^\\s,()]+")) {
                return null;
            }
            if (var == null) {
                var = vName;
            } else if (!var.equals(vName)) {
                return null;
            }
            items.add(tok);
        }
        if (var != null) {
            return new NsText(var, items);
        }
        return null;
    }

    public static MatchTriple findTripleWithConstPredicateReusingObject(IrBGP w, Var obj) {
        if (w == null || obj == null) {
            return null;
        }
        for (IrNode ln : w.getLines()) {
            IrStatementPattern sp;
            Var p;
            if (!(ln instanceof IrStatementPattern) || (p = (sp = (IrStatementPattern)ln).getPredicate()) == null || !p.hasValue() || !(p.getValue() instanceof IRI) || !ApplyNegatedPropertySetTransform.sameVar(obj, sp.getSubject()) && !ApplyNegatedPropertySetTransform.sameVar(obj, sp.getObject())) continue;
            return new MatchTriple(ln, sp.getSubject(), sp.getPredicate(), sp.getObject());
        }
        return null;
    }

    public static MatchTriple findTripleWithPredicateVar(IrBGP w, String varName) {
        if (w == null || varName == null) {
            return null;
        }
        for (IrNode ln : w.getLines()) {
            IrStatementPattern sp;
            Var p;
            if (!(ln instanceof IrStatementPattern) || (p = (sp = (IrStatementPattern)ln).getPredicate()) == null || p.hasValue() || !varName.equals(p.getName())) continue;
            return new MatchTriple(ln, sp.getSubject(), sp.getPredicate(), sp.getObject());
        }
        return null;
    }

    public static String joinIrisWithPreferredOrder(List<String> tokens, TupleExprIRRenderer r) {
        ArrayList<String> rendered = new ArrayList<String>(tokens.size());
        for (String tok : tokens) {
            String t;
            String string = t = tok == null ? "" : tok.trim();
            if (t.startsWith("<") && t.endsWith(">") && t.length() > 2) {
                String iriTxt = t.substring(1, t.length() - 1);
                try {
                    IRI iri = SimpleValueFactory.getInstance().createIRI(iriTxt);
                    rendered.add(r.convertIRIToString(iri));
                }
                catch (IllegalArgumentException e) {
                    rendered.add(tok);
                }
                continue;
            }
            rendered.add(t);
        }
        return String.join((CharSequence)"|", rendered);
    }

    public static final class NsText {
        public final String varName;
        public final List<String> items;

        NsText(String varName, List<String> items) {
            this.varName = varName;
            this.items = items;
        }
    }

    public static final class MatchTriple {
        public final IrNode node;
        public final Var subject;
        public final Var predicate;
        public final Var object;

        MatchTriple(IrNode node, Var s, Var p, Var o) {
            this.node = node;
            this.subject = s;
            this.predicate = p;
            this.object = o;
        }
    }

    private static final class PT {
        Var g;
        IrPathTriple pt;

        private PT() {
        }
    }
}

