/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.app;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Properties;
import org.eclipse.rdf4j.RDF4J;
import org.eclipse.rdf4j.common.app.AppVersion;
import org.eclipse.rdf4j.common.app.config.Configuration;
import org.eclipse.rdf4j.common.app.logging.LogConfiguration;
import org.eclipse.rdf4j.common.app.net.ProxySettings;
import org.eclipse.rdf4j.common.app.util.ConfigurationUtil;
import org.eclipse.rdf4j.common.platform.PlatformFactory;

public class AppConfiguration
implements Configuration {
    private static final String APP_CONFIG_FILE = "application.properties";
    private static final String DEFAULT_PREFIX = "RDF4J";
    private static final String DEFAULT_LOGGING = "org.eclipse.rdf4j.common.app.logging.logback.LogbackConfiguration";
    private String applicationId;
    private String longName;
    private String fullName;
    private AppVersion version;
    private String[] commandLineArgs;
    private String dataDirName;
    private File dataDir;
    private LogConfiguration loggingConfiguration;
    private ProxySettings proxySettings;
    private Properties properties;

    public AppConfiguration() {
    }

    public AppConfiguration(String applicationId) {
        this();
        this.setApplicationId(applicationId);
    }

    public AppConfiguration(String applicationId, AppVersion version) {
        this(applicationId);
        this.setVersion(version);
    }

    public AppConfiguration(String applicationId, String longName) {
        this(applicationId);
        this.setLongName(longName);
    }

    public AppConfiguration(String applicationId, String longName, AppVersion version) {
        this(applicationId, version);
        this.setLongName(longName);
    }

    @Override
    public void load() throws IOException {
        this.properties = ConfigurationUtil.loadConfigurationProperties(APP_CONFIG_FILE, null);
        File f = Paths.get(this.getDataDir().toString(), "conf", APP_CONFIG_FILE).toFile();
        this.properties = ConfigurationUtil.loadConfigurationProperties(f, this.properties);
    }

    @Override
    public void save() throws IOException {
        if (this.loggingConfiguration != null) {
            this.loggingConfiguration.save();
        }
        if (this.properties != null) {
            File f = Paths.get(this.getDataDir().toString(), "conf", APP_CONFIG_FILE).toFile();
            ConfigurationUtil.saveConfigurationProperties(this.properties, f, false);
        }
        this.proxySettings.save();
    }

    @Override
    public void init() throws IOException {
        this.init(true);
    }

    public void init(boolean loadLogConfig) throws IOException {
        if (this.longName == null) {
            this.setLongName("RDF4J " + this.applicationId);
        }
        this.setFullName();
        this.configureDataDir();
        this.load();
        if (loadLogConfig) {
            try {
                this.loggingConfiguration = this.loadLogConfiguration();
                this.loggingConfiguration.setBaseDir(this.getDataDir());
                this.loggingConfiguration.setAppConfiguration(this);
                this.loggingConfiguration.init();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        this.proxySettings = new ProxySettings(this.getDataDir());
        this.proxySettings.init();
        this.save();
    }

    @Override
    public void destroy() throws IOException {
        this.loggingConfiguration.destroy();
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public final void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public void setDataDirName(String dataDirName) {
        this.dataDirName = dataDirName;
    }

    public String getLongName() {
        return this.longName;
    }

    public final void setLongName(String longName) {
        this.longName = longName;
    }

    public String getFullName() {
        return this.fullName;
    }

    private void setFullName() {
        this.fullName = this.longName;
        if (this.version != null) {
            this.fullName = this.fullName + " " + this.version.toString();
        }
    }

    public AppVersion getVersion() {
        if (this.version == null) {
            this.version = AppVersion.parse(RDF4J.getVersion());
        }
        return this.version;
    }

    public final void setVersion(AppVersion version) {
        this.version = version;
        this.fullName = this.longName + " " + version.toString();
    }

    public String[] getCommandLineArgs() {
        return (String[])this.commandLineArgs.clone();
    }

    public void setCommandLineArgs(String[] args) {
        this.commandLineArgs = (String[])args.clone();
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public LogConfiguration getLogConfiguration() {
        return this.loggingConfiguration;
    }

    public ProxySettings getProxySettings() {
        return this.proxySettings;
    }

    public void setProxySettings(ProxySettings proxySettings) {
        this.proxySettings = proxySettings;
    }

    private void configureDataDir() {
        if (this.dataDirName != null) {
            this.dataDirName = this.dataDirName.trim();
            if (!"".equals(this.dataDirName)) {
                File dataDirCandidate = new File(this.dataDirName);
                dataDirCandidate.mkdirs();
                File file = this.dataDir = dataDirCandidate.canRead() && dataDirCandidate.canWrite() ? dataDirCandidate : this.dataDir;
            }
        }
        if (this.dataDir == null) {
            this.dataDir = PlatformFactory.getPlatform().getApplicationDataDir(this.applicationId);
        }
    }

    private LogConfiguration loadLogConfiguration() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> logImplClass;
        Object logImpl;
        String classname = this.properties.getProperty("feature.logging.impl");
        if (classname == null) {
            classname = DEFAULT_LOGGING;
        }
        if ((logImpl = (logImplClass = Class.forName(classname)).newInstance()) instanceof LogConfiguration) {
            return (LogConfiguration)logImpl;
        }
        throw new InstantiationException(classname + " is not valid LogConfiguration instance!");
    }

    public Properties getProperties() {
        return this.properties;
    }
}

