/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sparqlbuilder.graphpattern;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.rdf4j.sparqlbuilder.constraint.Expression;
import org.eclipse.rdf4j.sparqlbuilder.core.QueryElementCollection;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.Filter;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GraphName;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GraphPattern;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GraphPatternNotTriples;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GraphPatterns;
import org.eclipse.rdf4j.sparqlbuilder.util.SparqlBuilderUtils;

class GroupGraphPattern
extends QueryElementCollection<GraphPattern>
implements GraphPattern {
    private static final String OPTIONAL = "OPTIONAL";
    private static final String GRAPH = "GRAPH ";
    private Optional<GraphName> from = Optional.empty();
    private List<Filter> filters = new ArrayList<Filter>();
    protected boolean isOptional = false;

    GroupGraphPattern() {
        this(false);
    }

    GroupGraphPattern(boolean isOptional) {
        this.isOptional = isOptional;
    }

    GroupGraphPattern(GraphPattern original) {
        if (original instanceof GroupGraphPattern) {
            this.copy((GroupGraphPattern)original);
        } else if (original != null && !original.isEmpty()) {
            this.elements.add(original);
        }
    }

    protected void copy(GroupGraphPattern original) {
        this.elements = original.elements;
        this.isOptional = original.isOptional;
        this.from = original.from;
        this.filters = new ArrayList<Filter>(original.filters);
    }

    @Override
    public GroupGraphPattern and(GraphPattern ... patterns) {
        if (this.isEmpty() && patterns.length == 1 && GroupGraphPattern.isGGP(patterns[0])) {
            GroupGraphPattern ggp = GraphPatterns.extractOrConvertToGGP(patterns[0]);
            if (ggp.getClass() == GroupGraphPattern.class) {
                this.copy(ggp);
            } else {
                this.addElements(patterns);
            }
        } else {
            this.addElements(patterns);
        }
        return this;
    }

    @Override
    public GroupGraphPattern optional(boolean isOptional) {
        this.isOptional = isOptional;
        return this;
    }

    @Override
    public GroupGraphPattern from(GraphName name) {
        this.from = Optional.of(name);
        return this;
    }

    @Override
    public GroupGraphPattern filter(Expression<?> constraint) {
        this.filters.add(new Filter(constraint));
        return this;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty();
    }

    @Override
    public String getQueryString() {
        StringBuilder pattern = new StringBuilder();
        StringBuilder innerPattern = new StringBuilder();
        if (this.isOptional) {
            pattern.append(OPTIONAL).append(" ");
        }
        SparqlBuilderUtils.appendQueryElementIfPresent(this.from, pattern, GRAPH, " ");
        innerPattern.append(super.getQueryString());
        this.filters.forEach(filter -> SparqlBuilderUtils.appendQueryElementIfPresent(Optional.of(filter), innerPattern, "\n", null));
        if (this.bracketInner()) {
            pattern.append(SparqlBuilderUtils.getBracedString(innerPattern.toString()));
        } else {
            pattern.append(innerPattern.toString());
        }
        return pattern.toString();
    }

    private static boolean isGGP(GraphPattern pattern) {
        if (pattern instanceof GroupGraphPattern) {
            return true;
        }
        if (pattern instanceof GraphPatternNotTriples) {
            return ((GraphPatternNotTriples)pattern).gp instanceof GroupGraphPattern;
        }
        return false;
    }

    private boolean bracketInner() {
        return this.elements.size() != 1 || !(this.elements.iterator().next() instanceof GroupGraphPattern);
    }
}

