/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.jayes.rcp;

import java.io.InputStream;
import java.text.DecimalFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.recommenders.internal.jayes.rcp.CPTDialog;
import org.eclipse.recommenders.jayes.BayesNet;
import org.eclipse.recommenders.jayes.BayesNode;
import org.eclipse.recommenders.jayes.inference.jtree.JunctionTreeAlgorithm;
import org.eclipse.recommenders.jayes.inference.jtree.JunctionTreeBuilder;
import org.eclipse.recommenders.jayes.io.jbif.JayesBifReader;
import org.eclipse.recommenders.jayes.util.triangulation.IEliminationHeuristic;
import org.eclipse.recommenders.jayes.util.triangulation.MinDegree;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class JayesEditor
extends EditorPart {
    private TreeViewer viewer;
    private BayesNet net;
    private JunctionTreeAlgorithm junctionTree;

    public void createPartControl(Composite parent) {
        this.createTreeViewer(parent);
        this.registerContextMenu();
        this.setViewerInput();
    }

    private void setViewerInput() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IURIEditorInput) {
            IURIEditorInput fei = (IURIEditorInput)input;
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStream is = fei.getURI().toURL().openStream();){
                    JayesBifReader r = new JayesBifReader(is);
                    this.net = r.read();
                    r.close();
                    this.junctionTree = new JunctionTreeAlgorithm();
                    this.junctionTree.setJunctionTreeBuilder(JunctionTreeBuilder.forHeuristic((IEliminationHeuristic)new MinDegree()));
                    this.junctionTree.setNetwork(this.net);
                    this.viewer.setInput((Object)this.net);
                    this.setPartName(fei.getName());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void createTreeViewer(Composite parent) {
        this.viewer = new TreeViewer(parent, 2048);
        Tree tree = this.viewer.getTree();
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        MyViewerSorter sorter = new MyViewerSorter();
        this.viewer.setComparator((ViewerComparator)sorter);
        TreeViewerColumn nameColumn = this.createNameColumn(tree, sorter);
        TreeViewerColumn valueColumn = this.createValueColumn(tree, sorter);
        TreeColumnLayout treeLayout = new TreeColumnLayout();
        treeLayout.setColumnData((Widget)nameColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(4, 200, true));
        treeLayout.setColumnData((Widget)valueColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, 50, true));
        parent.setLayout((Layout)treeLayout);
        this.viewer.setContentProvider((IContentProvider)new BayesNodesContentProvider());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                for (Object o : selection.toList()) {
                    if (!(o instanceof OutcomeNode)) continue;
                    OutcomeNode n = (OutcomeNode)o;
                    if (JayesEditor.this.hasEvidence(n)) {
                        JayesEditor.this.junctionTree.removeEvidence(n.node);
                        continue;
                    }
                    JayesEditor.this.junctionTree.addEvidence(n.node, n.outcomeName);
                }
                JayesEditor.this.viewer.refresh();
            }
        });
    }

    private TreeViewerColumn createNameColumn(final Tree tree, final MyViewerSorter sorter) {
        final TreeViewerColumn nameColumn = new TreeViewerColumn(this.viewer, 16384);
        nameColumn.getColumn().setText("Nodes");
        nameColumn.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                tree.setSortDirection(1024);
                tree.setSortColumn(nameColumn.getColumn());
                sorter.criterion = 0;
                JayesEditor.this.viewer.refresh();
            }
        });
        nameColumn.setLabelProvider((CellLabelProvider)new NameColumnLabelProvider());
        return nameColumn;
    }

    private TreeViewerColumn createValueColumn(final Tree tree, final MyViewerSorter sorter) {
        final TreeViewerColumn valueColumn = new TreeViewerColumn(this.viewer, 16384);
        valueColumn.getColumn().setText("Value");
        valueColumn.setLabelProvider((CellLabelProvider)new ValueColumnLabelProvider());
        valueColumn.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                tree.setSortDirection(1024);
                tree.setSortColumn(valueColumn.getColumn());
                sorter.criterion = 1;
                JayesEditor.this.viewer.refresh();
            }
        });
        return valueColumn;
    }

    private void registerContextMenu() {
        MenuManager mgr = new MenuManager();
        mgr.setRemoveAllWhenShown(true);
        mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)new Action("Collapse all"){

                    public void run() {
                        JayesEditor.this.viewer.collapseAll();
                    }
                });
                manager.add((IAction)new Action("Expand all"){

                    public void run() {
                        JayesEditor.this.viewer.expandToLevel(2);
                    }
                });
                manager.add((IAction)new Action("Show CPT"){
                    private BayesNode node;

                    public void run() {
                        IStructuredSelection selection = (IStructuredSelection)JayesEditor.this.viewer.getSelection();
                        Object e = selection.getFirstElement();
                        this.node = e instanceof BayesNode ? (this.node = (BayesNode)e) : ((OutcomeNode)e).node;
                        new CPTDialog(JayesEditor.this.getSite().getShell(), this.node).open();
                    }
                });
            }
        });
        Menu menu = mgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    private boolean hasEvidence(BayesNode node) {
        return this.junctionTree.getEvidence().containsKey(node);
    }

    private boolean hasEvidence(OutcomeNode node) {
        String state = (String)this.junctionTree.getEvidence().get(node.node);
        return node.outcomeName.equals(state);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setInput(input);
        this.setSite((IWorkbenchPartSite)site);
    }

    public void setFocus() {
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    private Color getNodeForegroundColor(Object element) {
        if (element instanceof BayesNode) {
            boolean observed = this.junctionTree.getEvidence().containsKey(element);
            if (observed) {
                return Display.getDefault().getSystemColor(11);
            }
        } else if (element instanceof OutcomeNode) {
            OutcomeNode node = (OutcomeNode)element;
            String state = (String)this.junctionTree.getEvidence().get(node.node);
            if (node.outcomeName.equals(state)) {
                return Display.getDefault().getSystemColor(11);
            }
        }
        return null;
    }

    private Font getNodeFont(Object element) {
        boolean evidence = element instanceof BayesNode ? this.hasEvidence((BayesNode)element) : this.hasEvidence((OutcomeNode)element);
        return evidence ? JFaceResources.getBannerFont() : null;
    }

    public class BayesNodesContentProvider
    implements ITreeContentProvider {
        public Object[] getElements(Object net) {
            return ((BayesNet)net).getNodes().toArray();
        }

        public boolean hasChildren(Object element) {
            return element instanceof BayesNode;
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof BayesNode) {
                BayesNode node = (BayesNode)parent;
                Object[] res = new OutcomeNode[node.getOutcomeCount()];
                int i = 0;
                while (i < res.length) {
                    res[i] = new OutcomeNode(node, i);
                    ++i;
                }
                return res;
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof OutcomeNode) {
                OutcomeNode outcome = (OutcomeNode)element;
                return outcome.node;
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private final class MyViewerSorter
    extends ViewerComparator {
        private static final int SORT_BY_NAME = 0;
        private static final int SORT_BY_VALUE = 1;
        int criterion = 0;

        private MyViewerSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof BayesNode && e2 instanceof BayesNode) {
                return ((BayesNode)e1).getName().compareTo(((BayesNode)e2).getName());
            }
            if (e1 instanceof OutcomeNode && e2 instanceof OutcomeNode) {
                OutcomeNode l1 = (OutcomeNode)e1;
                OutcomeNode l2 = (OutcomeNode)e2;
                switch (this.criterion) {
                    case 0: {
                        return l1.outcomeName.compareTo(l2.outcomeName);
                    }
                    case 1: {
                        double[] beliefs = JayesEditor.this.junctionTree.getBeliefs(l1.node);
                        int compare = -1 * Double.compare(beliefs[l1.outcomeIndex], beliefs[l2.outcomeIndex]);
                        if (compare == 0) {
                            return l1.outcomeName.compareTo(l2.outcomeName);
                        }
                        return compare;
                    }
                }
            }
            return super.compare(viewer, e1, e2);
        }
    }

    private final class NameColumnLabelProvider
    extends ColumnLabelProvider {
        private NameColumnLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof BayesNode) {
                return ((BayesNode)element).getName();
            }
            if (element instanceof OutcomeNode) {
                return ((OutcomeNode)element).outcomeName;
            }
            return super.getText(element);
        }

        public Color getForeground(Object element) {
            return JayesEditor.this.getNodeForegroundColor(element);
        }

        public Font getFont(Object element) {
            return JayesEditor.this.getNodeFont(element);
        }
    }

    public static class OutcomeNode {
        public BayesNode node;
        public int outcomeIndex;
        public String outcomeName;

        public OutcomeNode(BayesNode node, int outcomeIndex) {
            this.node = node;
            this.outcomeIndex = outcomeIndex;
            this.outcomeName = node.getOutcomeName(outcomeIndex);
        }
    }

    private final class ValueColumnLabelProvider
    extends ColumnLabelProvider {
        DecimalFormat outcomeNumberFormat = new DecimalFormat("0.0000");
        DecimalFormat nodeNumberFormat = new DecimalFormat("0.0000");

        private ValueColumnLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof BayesNode) {
                BayesNode n = (BayesNode)element;
                double[] beliefs = JayesEditor.this.junctionTree.getBeliefs(n);
                double max = 0.0;
                int maxIndex = 0;
                int i = 0;
                while (i < beliefs.length) {
                    if (beliefs[i] > max) {
                        max = beliefs[i];
                        maxIndex = i;
                    }
                    ++i;
                }
                String outcomeName = n.getOutcomeName(maxIndex);
                return "p(" + outcomeName + ") \u2248 " + this.nodeNumberFormat.format(beliefs[maxIndex]);
            }
            if (element instanceof OutcomeNode) {
                OutcomeNode n = (OutcomeNode)element;
                if (JayesEditor.this.hasEvidence(n)) {
                    return "\u23da";
                }
                double[] beliefs = JayesEditor.this.junctionTree.getBeliefs(n.node);
                return this.outcomeNumberFormat.format(beliefs[n.outcomeIndex]);
            }
            return null;
        }

        public Color getForeground(Object element) {
            return JayesEditor.this.getNodeForegroundColor(element);
        }

        public Font getFont(Object element) {
            return JayesEditor.this.getNodeFont(element);
        }
    }
}

