/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.testing;

import org.eclipse.recommenders.utils.Recommendation;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public final class RecommendationMatchers {
    private static final double DELTA = 0.01;

    private RecommendationMatchers() {
    }

    public static <T> Matcher<Recommendation<T>> recommendation(T method, double relevance) {
        return new RecommendationMatcher<T>(method, relevance);
    }

    private static class RecommendationMatcher<T>
    extends BaseMatcher<Recommendation<T>> {
        private final T expectedProposal;
        private final double expectedRelevance;

        public RecommendationMatcher(T expectedProposal, double expectedRelevance) {
            this.expectedProposal = expectedProposal;
            this.expectedRelevance = expectedRelevance;
        }

        public boolean matches(Object object) {
            if (object instanceof Recommendation) {
                Recommendation recommendation = (Recommendation)object;
                return recommendation.getProposal().equals(this.expectedProposal) && this.inRange(recommendation.getRelevance(), this.expectedRelevance);
            }
            return false;
        }

        public void describeTo(Description description) {
            description.appendText("a recommendation of ").appendValue(this.expectedProposal).appendText(String.format(" with relevance %1.2f +/- %1.2f", this.expectedRelevance, 0.01));
        }

        public boolean inRange(double actual, double expected) {
            return actual == expected || Math.abs(expected - actual) <= 0.01;
        }
    }
}

