/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.commons.math.genetics;

/**
 * Algorithm used to determine when to stop evolution.
 *
 * @since 2.0
 * @version $Revision: 1.1.2.1 $ $Date: 2011/02/07 02:19:29 $
 */
public interface StoppingCondition {
    /**
     * Determine whether or not the given population satisfies the stopping
     * condition.
     *
     * @param population the population to test.
     * @return <code>true</code> if this stopping condition is met by the
     *         given population. <code>false</code> otherwise.
     */
    boolean isSatisfied(Population population);
}
