/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.models;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.recommenders.models.IInputStreamTransformer;
import org.eclipse.recommenders.models.IModelArchiveCoordinateAdvisor;
import org.eclipse.recommenders.models.IModelProvider;
import org.eclipse.recommenders.models.IModelRepository;
import org.eclipse.recommenders.models.IUniqueName;
import org.eclipse.recommenders.models.ModelCoordinate;
import org.eclipse.recommenders.utils.IOUtils;
import org.eclipse.recommenders.utils.Zips;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SimpleModelProvider<K extends IUniqueName<?>, M>
implements IModelProvider<K, M> {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleModelProvider.class);
    private static final int CACHE_SIZE = 10;
    private final LoadingCache<ModelCoordinate, ZipFile> openZips = CacheBuilder.newBuilder().maximumSize(10L).expireAfterAccess(1L, TimeUnit.MINUTES).removalListener((RemovalListener)new ZipRemovalListener()).build((CacheLoader)new ZipCacheLoader());
    private final IModelRepository repository;
    private final IModelArchiveCoordinateAdvisor index;
    private final String modelType;
    private final Map<String, IInputStreamTransformer> transformers;

    public SimpleModelProvider(IModelRepository cache, IModelArchiveCoordinateAdvisor index, String modelType, Map<String, IInputStreamTransformer> transformers) {
        this.repository = cache;
        this.index = index;
        this.modelType = modelType;
        this.transformers = transformers;
    }

    @Override
    public Optional<M> acquireModel(K key) {
        try {
            ZipFile zip;
            ModelCoordinate mc = (ModelCoordinate)this.index.suggest(key.getProjectCoordinate(), this.modelType).orNull();
            if (mc == null) {
                return Optional.absent();
            }
            try {
                zip = (ZipFile)this.openZips.get((Object)mc);
            }
            catch (UncheckedExecutionException e) {
                if (IllegalStateException.class.equals(e.getCause().getClass())) {
                    return Optional.absent();
                }
                throw e;
            }
            return this.doAcquireModel(key, zip);
        }
        catch (Exception e) {
            LOG.error("Exception while loading model " + key, (Throwable)e);
            return Optional.absent();
        }
    }

    @VisibleForTesting
    protected Optional<M> doAcquireModel(K key, ZipFile zip) throws IOException {
        Optional optional;
        InputStream in;
        block6: {
            in = null;
            String basePath = this.getBasePath(key);
            in = (InputStream)this.getInputStream(zip, basePath).orNull();
            if (in != null) break block6;
            Optional optional2 = Optional.absent();
            IOUtils.closeQuietly((Closeable)in);
            return optional2;
        }
        try {
            optional = Optional.of(this.loadModel(in, key));
        }
        catch (UncheckedExecutionException e) {
            block7: {
                Optional optional3;
                try {
                    if (!IllegalStateException.class.equals(e.getCause().getClass())) break block7;
                    optional3 = Optional.absent();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)in);
                return optional3;
            }
            throw e;
        }
        IOUtils.closeQuietly((Closeable)in);
        return optional;
    }

    protected abstract String getBasePath(K var1);

    @VisibleForTesting
    protected Optional<InputStream> getInputStream(ZipFile zip, String basePath) throws IOException {
        for (Map.Entry<String, IInputStreamTransformer> transformer : this.transformers.entrySet()) {
            ZipEntry toTransform = zip.getEntry(String.valueOf(basePath) + "." + transformer.getKey());
            if (toTransform == null) continue;
            return Optional.of((Object)transformer.getValue().transform(zip.getInputStream(toTransform)));
        }
        ZipEntry entry = zip.getEntry(basePath);
        if (entry == null) {
            return Optional.absent();
        }
        return Optional.of((Object)zip.getInputStream(entry));
    }

    protected abstract M loadModel(InputStream var1, K var2) throws IOException;

    @Override
    public void releaseModel(M value) {
    }

    public void open() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.openZips.invalidateAll();
    }

    private final class ZipCacheLoader
    extends CacheLoader<ModelCoordinate, ZipFile> {
        private ZipCacheLoader() {
        }

        public ZipFile load(ModelCoordinate key) throws Exception {
            File location = (File)SimpleModelProvider.this.repository.getLocation(key, true).get();
            ByteStreams.toByteArray((InputSupplier)Files.newInputStreamSupplier((File)location));
            return new ZipFile(location);
        }
    }

    private final class ZipRemovalListener
    implements RemovalListener<ModelCoordinate, ZipFile> {
        private ZipRemovalListener() {
        }

        public void onRemoval(RemovalNotification<ModelCoordinate, ZipFile> notification) {
            Zips.closeQuietly((ZipFile)((ZipFile)notification.getValue()));
        }
    }
}

