/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.commons.math.analysis.interpolation;

import org.apache.commons.math.MathException;
import org.apache.commons.math.analysis.BivariateRealFunction;

/**
 * Interface representing a bivariate real interpolating function where the
 * sample points must be specified on a regular grid.
 *
 * @version $Revision: 1.1.2.1 $ $Date: 2011/02/07 02:19:14 $
 */
public interface BivariateRealGridInterpolator {

    /**
     * Computes an interpolating function for the data set.
     *
     * @param xval all the x-coordinates of the interpolation points, sorted
     * in increasing order.
     * @param yval all the y-coordinates of the interpolation points, sorted
     * in increasing order.
     * @param zval the values of the interpolation points on all the grid knots:
     * {@code zval[i][j] = f(xval[i], yval[j])}
     * @return a function which interpolates the data set
     * @throws MathException if arguments violate assumptions made by the
     *         interpolation algorithm
     */
    BivariateRealFunction interpolate(double[] xval, double[] yval, double[][] zval)
        throws MathException;
}
