/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.statics;

import com.google.common.base.Optional;

public final class MethodNameUtils {
    private MethodNameUtils() {
    }

    public static Optional<String> extractVerb(String methodName) {
        if (MethodNameUtils.isInternalName(methodName)) {
            return Optional.absent();
        }
        int start = 0;
        while (start < methodName.length() && MethodNameUtils.isIgnoreablePrefix(methodName.charAt(start))) {
            ++start;
        }
        int end = start;
        if (start < methodName.length() && Character.isUpperCase(methodName.charAt(start))) {
            ++end;
        }
        while (end < methodName.length() && !MethodNameUtils.isWordDelimiter(methodName.charAt(end))) {
            ++end;
        }
        if (end - start > 1) {
            return Optional.of((Object)methodName.substring(start, end).toLowerCase());
        }
        return Optional.absent();
    }

    private static boolean isIgnoreablePrefix(char c) {
        return c == '_';
    }

    private static boolean isWordDelimiter(char c) {
        return Character.isDigit(c) || Character.isUpperCase(c) || c == '_';
    }

    private static boolean isInternalName(String methodName) {
        return methodName.contains("$");
    }
}

