/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils.gson;

import com.google.common.base.Optional;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class OptionalJsonTypeAdapter<T>
implements JsonSerializer<Optional<T>>,
JsonDeserializer<Optional<T>> {
    private static final String ABSENT = "ABSENT";

    public JsonElement serialize(Optional<T> src, Type typeOfSrc, JsonSerializationContext context) {
        if (src.isPresent()) {
            return context.serialize(src.get());
        }
        return new JsonPrimitive(ABSENT);
    }

    public Optional<T> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.getAsString().equals(ABSENT)) {
            return Optional.absent();
        }
        Object entry = context.deserialize(json, ((ParameterizedType)typeOfT).getActualTypeArguments()[0]);
        return Optional.fromNullable((Object)entry);
    }
}

