/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp.completion;

import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.recommenders.coordinates.DependencyInfo;
import org.eclipse.recommenders.coordinates.IDependencyListener;
import org.eclipse.recommenders.coordinates.rcp.DependencyInfos;
import org.eclipse.recommenders.internal.snipmatch.rcp.Repositories;
import org.eclipse.recommenders.internal.snipmatch.rcp.completion.AbstractContentAssistProcessor;
import org.eclipse.recommenders.internal.snipmatch.rcp.completion.TextContentAssistInvocationContext;
import org.eclipse.recommenders.internal.snipmatch.rcp.completion.TextTemplateContextType;
import org.eclipse.recommenders.models.rcp.IProjectCoordinateProvider;
import org.eclipse.recommenders.rcp.SharedImages;
import org.eclipse.recommenders.snipmatch.Location;
import org.eclipse.recommenders.snipmatch.rcp.model.SnippetRepositoryConfigurations;

public class TextContentAssistProcessor
extends AbstractContentAssistProcessor<TextContentAssistInvocationContext> {
    @Inject
    public TextContentAssistProcessor(SnippetRepositoryConfigurations configs, Repositories repos, IProjectCoordinateProvider pcProvider, IDependencyListener dependencyListener, SharedImages images) {
        super(TextTemplateContextType.getInstance(), configs, repos, pcProvider, dependencyListener, images);
    }

    @Override
    protected Set<DependencyInfo> calculateAvailableDependencies(TextContentAssistInvocationContext context) {
        IJavaProject project = (IJavaProject)context.getProject().orNull();
        if (project == null) {
            return Collections.emptySet();
        }
        DependencyInfo dependencyInfo = (DependencyInfo)DependencyInfos.createProjectDependencyInfo((IJavaProject)project).orNull();
        if (dependencyInfo == null) {
            return Collections.emptySet();
        }
        return this.dependencyListener.getDependenciesForProject(dependencyInfo);
    }

    @Override
    protected TemplateContext getTemplateContext(IDocument document, Position position) {
        return new DocumentTemplateContext(this.templateContextType, document, position);
    }

    @Override
    protected Location getLocation() {
        return Location.FILE;
    }
}

