/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.testing.rcp.completion.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.recommenders.testing.rcp.completion.rules.TemporaryProject;
import org.junit.rules.ExternalResource;

public class TemporaryWorkspace
extends ExternalResource {
    private List<TemporaryProject> tempProjects;
    private IWorkspace workspace;

    public TemporaryProject createProject() {
        TemporaryProject project = new TemporaryProject(this, this.getNewRandomName());
        this.tempProjects.add(project);
        return project;
    }

    IWorkspace getWorkspace() {
        return this.workspace;
    }

    private String getNewRandomName() {
        String name = RandomStringUtils.randomAlphanumeric((int)16);
        while (this.isNameAlreadyUsed(name)) {
            name = RandomStringUtils.randomAlphanumeric((int)16);
        }
        return name;
    }

    private boolean isNameAlreadyUsed(String name) {
        for (TemporaryProject tempProject : this.tempProjects) {
            if (!tempProject.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    protected void before() throws Throwable {
        this.workspace = ResourcesPlugin.getWorkspace();
        this.tempProjects = new ArrayList<TemporaryProject>();
    }

    protected void after() {
        IProject[] projects;
        IProject[] iProjectArray = projects = this.workspace.getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                project.delete(true, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        this.workspace = null;
    }
}

