/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.preferences;

import java.util.regex.Pattern;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddConfigEntryDialog
extends TitleAreaDialog {
    private static final Pattern VALID_KEY = Pattern.compile("(\\h|\\v)*[-\\p{Alnum}]+(?:\\..*)?\\.\\p{Alpha}[-\\p{Alnum}]*(\\h|\\v)*");
    private Text keyText;
    private Text valueText;
    private String key;
    private String value;
    private final String suggestedKey;

    public AddConfigEntryDialog(Shell parentShell, String suggestedKey) {
        super(parentShell);
        this.setHelpAvailable(false);
        this.suggestedKey = suggestedKey;
        this.setHelpAvailable(false);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(UIText.AddConfigEntryDialog_AddConfigTitle);
        this.setTitle(UIText.AddConfigEntryDialog_AddConfigTitle);
        this.setMessage(UIText.AddConfigEntryDialog_DialogMessage);
        Composite titleParent = (Composite)super.createDialogArea(parent);
        Composite main = new Composite(titleParent, 0);
        main.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        Label keyLabel = new Label(main, 0);
        keyLabel.setText(UIText.AddConfigEntryDialog_KeyLabel);
        keyLabel.setToolTipText(UIText.AddConfigEntryDialog_ConfigKeyTooltip);
        this.keyText = new Text(main, 2048);
        if (this.suggestedKey != null) {
            this.keyText.setText(this.trimKey(this.suggestedKey));
            this.keyText.selectAll();
        }
        this.keyText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddConfigEntryDialog.this.check();
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.keyText);
        new Label(main, 0).setText(UIText.AddConfigEntryDialog_ValueLabel);
        this.valueText = new Text(main, 2048);
        this.valueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddConfigEntryDialog.this.check();
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.valueText);
        AddConfigEntryDialog.applyDialogFont((Control)main);
        return main;
    }

    private boolean isValidKey(String keyValue) {
        return keyValue != null && VALID_KEY.matcher(keyValue).matches();
    }

    private String trimKey(String keyValue) {
        return keyValue.replaceAll("^(?:\\h|\\v)*|(?:\\h|\\v)*$", "");
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
    }

    private void check() {
        boolean hasError;
        block8: {
            block7: {
                block6: {
                    block5: {
                        this.setErrorMessage(null);
                        hasError = false;
                        try {
                            if (this.keyText.getText().length() != 0) break block5;
                            this.setErrorMessage(UIText.AddConfigEntryDialog_MustEnterKeyMessage);
                            hasError = true;
                        }
                        catch (Throwable throwable) {
                            this.getButton(0).setEnabled(!hasError);
                            throw throwable;
                        }
                        this.getButton(0).setEnabled(!hasError);
                        return;
                    }
                    if (this.keyText.getText().indexOf(46) >= 0) break block6;
                    this.setErrorMessage(UIText.AddConfigEntryDialog_KeyComponentsMessage);
                    hasError = true;
                    this.getButton(0).setEnabled(!hasError);
                    return;
                }
                if (this.isValidKey(this.keyText.getText())) break block7;
                this.setErrorMessage(UIText.AddConfigEntryDialog_InvalidKeyMessage);
                hasError = true;
                this.getButton(0).setEnabled(!hasError);
                return;
            }
            if (this.valueText.getText().length() != 0) break block8;
            this.setErrorMessage(UIText.AddConfigEntryDialog_EnterValueMessage);
            hasError = true;
            this.getButton(0).setEnabled(!hasError);
            return;
        }
        this.getButton(0).setEnabled(!hasError);
    }

    protected void okPressed() {
        this.key = this.trimKey(this.keyText.getText());
        this.value = this.valueText.getText();
        super.okPressed();
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, UIText.AddConfigEntryDialog_ButtonOK, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }
}

