/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.StringJoiner;
import org.eclipse.emf.common.util.Diagnostic;

public final class DiagnosticMessageExtractor {
    private static final Comparator<Diagnostic> HIGEST_SEVERITY_FIRST = Comparator.comparingInt(Diagnostic::getSeverity).reversed().thenComparing(Diagnostic::getMessage);

    private DiagnosticMessageExtractor() {
    }

    public static String getMessage(Diagnostic diagnostic) {
        if (diagnostic.getSeverity() == 0) {
            return "";
        }
        if (diagnostic.getChildren() != null && diagnostic.getChildren().isEmpty()) {
            return diagnostic.getMessage();
        }
        StringJoiner sb = new StringJoiner("\n");
        for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
            sb.add(childDiagnostic.getMessage());
        }
        return sb.toString();
    }

    public static String getMessage(Collection<Diagnostic> diagnostics) {
        ArrayList<Diagnostic> diagnosticList = new ArrayList<Diagnostic>(diagnostics);
        diagnosticList.sort(HIGEST_SEVERITY_FIRST);
        StringJoiner sb = new StringJoiner("\n");
        for (Diagnostic diagnostic : diagnosticList) {
            if (diagnostic.getSeverity() == 0) continue;
            sb.add(DiagnosticMessageExtractor.getMessage(diagnostic));
        }
        return sb.toString();
    }
}

