/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.admin;

import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.query.UserVisibleRootQuery;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.ui.Policy;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class ProvAdminUIActivator
extends AbstractUIPlugin {
    private static ProvAdminUIActivator plugin;
    private static BundleContext context;
    public static final String PLUGIN_ID = "org.eclipse.equinox.internal.provisional.p2.ui.admin";
    public static final String PERSPECTIVE_ID = "org.eclipse.equinox.internal.provisional.p2.ui.admin.ProvisioningPerspective";
    private IPropertyChangeListener preferenceListener;
    Policy policy;

    public static BundleContext getContext() {
        return context;
    }

    public static ProvAdminUIActivator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return ProvAdminUIActivator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        context = bundleContext;
        this.initializePolicy();
        this.getPreferenceStore().addPropertyChangeListener(this.getPreferenceListener());
    }

    public void stop(BundleContext bundleContext) throws Exception {
        plugin = null;
        this.getPreferenceStore().removePropertyChangeListener(this.preferenceListener);
        super.stop(bundleContext);
        this.policy = null;
    }

    private IPropertyChangeListener getPreferenceListener() {
        if (this.preferenceListener == null) {
            this.preferenceListener = event -> this.updateForPreferences();
        }
        return this.preferenceListener;
    }

    void updateForPreferences() {
        if (this.getPreferenceStore().getBoolean("org.eclipse.equinox.internal.provisional.p2.ui.admin.showGroupsOnly")) {
            this.policy.setVisibleAvailableIUQuery(QueryUtil.createIUGroupQuery());
        } else {
            this.policy.setVisibleAvailableIUQuery(QueryUtil.createIUAnyQuery());
        }
        if (this.getPreferenceStore().getBoolean("org.eclipse.equinox.internal.provisional.p2.ui.admin.showInstallRoots")) {
            this.policy.setVisibleInstalledIUQuery((IQuery)new UserVisibleRootQuery());
        } else {
            this.policy.setVisibleInstalledIUQuery(QueryUtil.createIUAnyQuery());
        }
        RepositoryTracker tracker = this.getRepositoryTracker();
        if (this.getPreferenceStore().getBoolean("org.eclipse.equinox.internal.provisional.p2.ui.admin.hideSystemRepos")) {
            tracker.setArtifactRepositoryFlags(2);
            tracker.setMetadataRepositoryFlags(2);
        } else {
            tracker.setArtifactRepositoryFlags(0);
            tracker.setMetadataRepositoryFlags(0);
        }
        this.policy.setShowLatestVersionsOnly(this.getPreferenceStore().getBoolean("org.eclipse.equinox.internal.provisional.p2.ui.admin.collapseIUVersions"));
        this.policy.setGroupByCategory(this.getPreferenceStore().getBoolean("org.eclipse.equinox.internal.provisional.p2.ui.admin.useCategories"));
    }

    private RepositoryTracker getRepositoryTracker() {
        return ProvisioningUI.getDefaultUI().getRepositoryTracker();
    }

    void initializePolicy() {
        this.policy = new Policy();
        this.updateForPreferences();
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public IProfileRegistry getProfileRegistry() {
        IProvisioningAgent agent = (IProvisioningAgent)ServiceHelper.getService((BundleContext)context, IProvisioningAgent.class);
        return (IProfileRegistry)agent.getService(IProfileRegistry.class);
    }

    public ProvisioningUI getProvisioningUI(String profileId) {
        return new ProvisioningUI(ProvisioningUI.getDefaultUI().getSession(), profileId, this.policy);
    }
}

