/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.admin.dialogs;

import org.eclipse.equinox.internal.p2.ui.admin.ProvAdminUIMessages;
import org.eclipse.equinox.internal.p2.ui.admin.dialogs.IUGroup;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class IUPropertiesGroup
extends IUGroup {
    private Table propertiesTable;

    public IUPropertiesGroup(Composite parent, IInstallableUnit iu, ModifyListener listener) {
        super(parent, iu, listener);
    }

    @Override
    protected Composite createGroupComposite(Composite parent, ModifyListener listener) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.widthHint = 400;
        composite.setLayoutData((Object)data);
        this.propertiesTable = new Table(composite, 2816);
        data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        this.propertiesTable.setLayoutData((Object)data);
        this.propertiesTable.setHeaderVisible(true);
        TableColumn nameColumn = new TableColumn(this.propertiesTable, 0);
        nameColumn.setResizable(true);
        nameColumn.setWidth(200);
        TableColumn valueColumn = new TableColumn(this.propertiesTable, 0);
        valueColumn.setResizable(true);
        valueColumn.setWidth(250);
        this.initializeFields();
        return composite;
    }

    private void initializeFields() {
        if (this.iuElement == null) {
            return;
        }
        String[] propNames = new String[]{"org.eclipse.equinox.p2.name", "org.eclipse.equinox.p2.description", "org.eclipse.equinox.p2.provider"};
        String[] userPropNames = new String[]{ProvAdminUIMessages.IUPropertiesGroup_NamePropertyLabel, ProvAdminUIMessages.IUPropertiesGroup_DescriptionPropertyLabel, ProvAdminUIMessages.IUPropertiesGroup_ProviderPropertyLabel};
        int i = 0;
        while (i < propNames.length) {
            TableItem item = new TableItem(this.propertiesTable, 0);
            String value = this.getIU().getProperty(propNames[i], null);
            if (value != null) {
                item.setText(new String[]{userPropNames[i], value});
            }
            ++i;
        }
    }
}

