package org.eclipse.gef.dot.internal.language.parser.antlr.lexer;

// Hack: Use our own Lexer superclass by means of import. 
// Currently there is no other way to specify the superclass for the lexer.
import org.eclipse.xtext.parser.antlr.Lexer;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

@SuppressWarnings("all")
public class InternalDotRecordLabelLexer extends Lexer {
    public static final int GreaterThanSign=5;
    public static final int RULE_WS=10;
    public static final int LeftCurlyBracket=6;
    public static final int LessThanSign=4;
    public static final int VerticalLine=7;
    public static final int RULE_NON_WS_STRING=9;
    public static final int RightCurlyBracket=8;
    public static final int EOF=-1;

    // delegates
    // delegators

    public InternalDotRecordLabelLexer() {;} 
    public InternalDotRecordLabelLexer(CharStream input) {
        this(input, new RecognizerSharedState());
    }
    public InternalDotRecordLabelLexer(CharStream input, RecognizerSharedState state) {
        super(input,state);

    }
    public String getGrammarFileName() { return "InternalDotRecordLabelLexer.g"; }

    // $ANTLR start "LessThanSign"
    public final void mLessThanSign() throws RecognitionException {
        try {
            int _type = LessThanSign;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // InternalDotRecordLabelLexer.g:14:14: ( '<' )
            // InternalDotRecordLabelLexer.g:14:16: '<'
            {
            match('<'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "LessThanSign"

    // $ANTLR start "GreaterThanSign"
    public final void mGreaterThanSign() throws RecognitionException {
        try {
            int _type = GreaterThanSign;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // InternalDotRecordLabelLexer.g:16:17: ( '>' )
            // InternalDotRecordLabelLexer.g:16:19: '>'
            {
            match('>'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "GreaterThanSign"

    // $ANTLR start "LeftCurlyBracket"
    public final void mLeftCurlyBracket() throws RecognitionException {
        try {
            int _type = LeftCurlyBracket;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // InternalDotRecordLabelLexer.g:18:18: ( '{' )
            // InternalDotRecordLabelLexer.g:18:20: '{'
            {
            match('{'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "LeftCurlyBracket"

    // $ANTLR start "VerticalLine"
    public final void mVerticalLine() throws RecognitionException {
        try {
            int _type = VerticalLine;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // InternalDotRecordLabelLexer.g:20:14: ( '|' )
            // InternalDotRecordLabelLexer.g:20:16: '|'
            {
            match('|'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "VerticalLine"

    // $ANTLR start "RightCurlyBracket"
    public final void mRightCurlyBracket() throws RecognitionException {
        try {
            int _type = RightCurlyBracket;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // InternalDotRecordLabelLexer.g:22:19: ( '}' )
            // InternalDotRecordLabelLexer.g:22:21: '}'
            {
            match('}'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "RightCurlyBracket"

    // $ANTLR start "RULE_NON_WS_STRING"
    public final void mRULE_NON_WS_STRING() throws RecognitionException {
        try {
            int _type = RULE_NON_WS_STRING;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // InternalDotRecordLabelLexer.g:24:20: ( ( '\\\\' . | ~ ( ( '|' | '{' | '}' | '<' | '>' | '\\\\' | ' ' | '\\t' | '\\r' | '\\n' ) ) )* )
            // InternalDotRecordLabelLexer.g:24:22: ( '\\\\' . | ~ ( ( '|' | '{' | '}' | '<' | '>' | '\\\\' | ' ' | '\\t' | '\\r' | '\\n' ) ) )*
            {
            // InternalDotRecordLabelLexer.g:24:22: ( '\\\\' . | ~ ( ( '|' | '{' | '}' | '<' | '>' | '\\\\' | ' ' | '\\t' | '\\r' | '\\n' ) ) )*
            loop1:
            do {
                int alt1=3;
                int LA1_0 = input.LA(1);

                if ( (LA1_0=='\\') ) {
                    alt1=1;
                }
                else if ( ((LA1_0>='\u0000' && LA1_0<='\b')||(LA1_0>='\u000B' && LA1_0<='\f')||(LA1_0>='\u000E' && LA1_0<='\u001F')||(LA1_0>='!' && LA1_0<=';')||LA1_0=='='||(LA1_0>='?' && LA1_0<='[')||(LA1_0>=']' && LA1_0<='z')||(LA1_0>='~' && LA1_0<='\uFFFF')) ) {
                    alt1=2;
                }


                switch (alt1) {
            	case 1 :
            	    // InternalDotRecordLabelLexer.g:24:23: '\\\\' .
            	    {
            	    match('\\'); 
            	    matchAny(); 

            	    }
            	    break;
            	case 2 :
            	    // InternalDotRecordLabelLexer.g:24:30: ~ ( ( '|' | '{' | '}' | '<' | '>' | '\\\\' | ' ' | '\\t' | '\\r' | '\\n' ) )
            	    {
            	    if ( (input.LA(1)>='\u0000' && input.LA(1)<='\b')||(input.LA(1)>='\u000B' && input.LA(1)<='\f')||(input.LA(1)>='\u000E' && input.LA(1)<='\u001F')||(input.LA(1)>='!' && input.LA(1)<=';')||input.LA(1)=='='||(input.LA(1)>='?' && input.LA(1)<='[')||(input.LA(1)>=']' && input.LA(1)<='z')||(input.LA(1)>='~' && input.LA(1)<='\uFFFF') ) {
            	        input.consume();

            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;}


            	    }
            	    break;

            	default :
            	    break loop1;
                }
            } while (true);


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "RULE_NON_WS_STRING"

    // $ANTLR start "RULE_WS"
    public final void mRULE_WS() throws RecognitionException {
        try {
            int _type = RULE_WS;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // InternalDotRecordLabelLexer.g:26:9: ( ( ' ' | '\\t' | '\\r' | '\\n' )+ )
            // InternalDotRecordLabelLexer.g:26:11: ( ' ' | '\\t' | '\\r' | '\\n' )+
            {
            // InternalDotRecordLabelLexer.g:26:11: ( ' ' | '\\t' | '\\r' | '\\n' )+
            int cnt2=0;
            loop2:
            do {
                int alt2=2;
                int LA2_0 = input.LA(1);

                if ( ((LA2_0>='\t' && LA2_0<='\n')||LA2_0=='\r'||LA2_0==' ') ) {
                    alt2=1;
                }


                switch (alt2) {
            	case 1 :
            	    // InternalDotRecordLabelLexer.g:
            	    {
            	    if ( (input.LA(1)>='\t' && input.LA(1)<='\n')||input.LA(1)=='\r'||input.LA(1)==' ' ) {
            	        input.consume();

            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;}


            	    }
            	    break;

            	default :
            	    if ( cnt2 >= 1 ) break loop2;
                        EarlyExitException eee =
                            new EarlyExitException(2, input);
                        throw eee;
                }
                cnt2++;
            } while (true);


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "RULE_WS"

    public void mTokens() throws RecognitionException {
        // InternalDotRecordLabelLexer.g:1:8: ( LessThanSign | GreaterThanSign | LeftCurlyBracket | VerticalLine | RightCurlyBracket | RULE_NON_WS_STRING | RULE_WS )
        int alt3=7;
        switch ( input.LA(1) ) {
        case '<':
            {
            alt3=1;
            }
            break;
        case '>':
            {
            alt3=2;
            }
            break;
        case '{':
            {
            alt3=3;
            }
            break;
        case '|':
            {
            alt3=4;
            }
            break;
        case '}':
            {
            alt3=5;
            }
            break;
        case '\t':
        case '\n':
        case '\r':
        case ' ':
            {
            alt3=7;
            }
            break;
        default:
            alt3=6;}

        switch (alt3) {
            case 1 :
                // InternalDotRecordLabelLexer.g:1:10: LessThanSign
                {
                mLessThanSign(); 

                }
                break;
            case 2 :
                // InternalDotRecordLabelLexer.g:1:23: GreaterThanSign
                {
                mGreaterThanSign(); 

                }
                break;
            case 3 :
                // InternalDotRecordLabelLexer.g:1:39: LeftCurlyBracket
                {
                mLeftCurlyBracket(); 

                }
                break;
            case 4 :
                // InternalDotRecordLabelLexer.g:1:56: VerticalLine
                {
                mVerticalLine(); 

                }
                break;
            case 5 :
                // InternalDotRecordLabelLexer.g:1:69: RightCurlyBracket
                {
                mRightCurlyBracket(); 

                }
                break;
            case 6 :
                // InternalDotRecordLabelLexer.g:1:87: RULE_NON_WS_STRING
                {
                mRULE_NON_WS_STRING(); 

                }
                break;
            case 7 :
                // InternalDotRecordLabelLexer.g:1:106: RULE_WS
                {
                mRULE_WS(); 

                }
                break;

        }

    }


 

}