/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.preferences;

import org.eclipse.core.runtime.Assert;
import org.eclipse.gef.dot.internal.ui.preferences.BooleanFieldEditor2;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DotExportRadioGroupFieldEditor
extends RadioGroupFieldEditor {
    private String[][] labelsAndValues;
    private int numColumns;
    private int indent = 8;
    private String value;
    private Composite radioBox;
    private Button[] radioButtons;
    private boolean useGroup;
    private Composite parent;
    private Label dotExportHintLabel;
    private String dotExportHintText;
    private BooleanFieldEditor2 openExportedFileBooleanFieldEditor;

    protected DotExportRadioGroupFieldEditor() {
    }

    public DotExportRadioGroupFieldEditor(String name, String labelText, String dotExportHintText, int numColumns, String[][] labelsAndValues, Composite parent) {
        this(name, labelText, dotExportHintText, numColumns, labelsAndValues, parent, false);
    }

    public DotExportRadioGroupFieldEditor(String name, String labelText, String dotExportHintText, int numColumns, String[][] labelsAndValues, Composite parent, boolean useGroup) {
        this.init(name, labelText);
        if (labelsAndValues != null) {
            Assert.isTrue((boolean)this.checkArray(labelsAndValues));
        }
        this.labelsAndValues = labelsAndValues;
        this.numColumns = numColumns;
        this.useGroup = useGroup;
        this.parent = parent;
        this.dotExportHintText = dotExportHintText;
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        if (control != null) {
            ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        }
        ((GridData)this.radioBox.getLayoutData()).horizontalSpan = numColumns;
    }

    private boolean checkArray(String[][] table) {
        if (table == null) {
            return false;
        }
        int i = 0;
        while (i < table.length) {
            String[] array = table[i];
            if (array == null || array.length != 2) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        if (this.useGroup) {
            Composite control = this.getRadioBoxControl(parent);
            GridData gd = new GridData(768);
            control.setLayoutData((Object)gd);
        } else {
            Label control = this.getLabelControl(parent);
            GridData gd = new GridData();
            gd.horizontalSpan = numColumns;
            control.setLayoutData((Object)gd);
            control = this.getRadioBoxControl(parent);
            gd = new GridData();
            gd.horizontalSpan = numColumns;
            gd.horizontalIndent = this.indent;
            control.setLayoutData((Object)gd);
        }
    }

    protected void doLoad() {
        this.updateValue(this.getPreferenceStore().getString(this.getPreferenceName()));
    }

    protected void doLoadDefault() {
    }

    protected void doStore() {
        if (this.value == null) {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
            return;
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.value);
    }

    public Composite getRadioBoxControl(Composite parent) {
        if (this.radioBox == null) {
            Font font = parent.getFont();
            if (this.useGroup) {
                Group group = new Group(parent, 0);
                group.setFont(font);
                String text = this.getLabelText();
                if (text != null) {
                    group.setText(text);
                }
                this.radioBox = group;
                GridLayout layout = new GridLayout();
                layout.horizontalSpacing = 8;
                layout.numColumns = this.numColumns;
                this.radioBox.setLayout((Layout)layout);
            } else {
                this.radioBox = new Composite(parent, 0);
                GridLayout layout = new GridLayout();
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                layout.horizontalSpacing = 8;
                layout.numColumns = this.numColumns;
                this.radioBox.setLayout((Layout)layout);
                this.radioBox.setFont(font);
            }
            this.dotExportHintLabel = new Label(parent, 0);
            this.dotExportHintLabel.setText(this.dotExportHintText);
            FontData fontData = this.dotExportHintLabel.getFont().getFontData()[0];
            Font boldFont = new Font((Device)Display.getCurrent(), new FontData(fontData.getName(), fontData.getHeight() - 1, 1));
            this.dotExportHintLabel.setFont(boldFont);
            GridData gridData = new GridData();
            gridData.horizontalSpan = 2;
            this.dotExportHintLabel.setLayoutData((Object)gridData);
            if (this.labelsAndValues != null) {
                this.radioButtons = new Button[this.labelsAndValues.length];
                int i = 0;
                while (i < this.labelsAndValues.length) {
                    Button radio;
                    this.radioButtons[i] = radio = new Button(this.radioBox, 16400);
                    String[] labelAndValue = this.labelsAndValues[i];
                    radio.setText(labelAndValue[0]);
                    radio.setData((Object)labelAndValue[1]);
                    radio.setFont(font);
                    radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            String oldValue = DotExportRadioGroupFieldEditor.this.value;
                            DotExportRadioGroupFieldEditor.this.value = (String)event.widget.getData();
                            DotExportRadioGroupFieldEditor.this.setPresentsDefaultValue(false);
                            DotExportRadioGroupFieldEditor.this.fireValueChanged("field_editor_value", oldValue, DotExportRadioGroupFieldEditor.this.value);
                        }
                    });
                    ++i;
                }
                this.hideDotExportHintLabel();
            }
            this.radioBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    DotExportRadioGroupFieldEditor.this.radioBox = null;
                    DotExportRadioGroupFieldEditor.this.radioButtons = null;
                }
            });
        } else {
            this.checkParent((Control)this.radioBox, parent);
        }
        return this.radioBox;
    }

    public void setIndent(int indent) {
        this.indent = indent < 0 ? 0 : indent;
    }

    private void updateValue(String selectedValue) {
        this.value = selectedValue;
        if (this.radioButtons == null) {
            return;
        }
        if (this.value != null) {
            boolean found = false;
            int i = 0;
            while (i < this.radioButtons.length) {
                Button radio = this.radioButtons[i];
                boolean selection = false;
                if (((String)radio.getData()).equals(this.value)) {
                    selection = true;
                    found = true;
                }
                radio.setSelection(selection);
                ++i;
            }
            if (found) {
                return;
            }
        }
        if (this.radioButtons.length > 0) {
            this.radioButtons[0].setSelection(true);
            this.value = (String)this.radioButtons[0].getData();
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        if (!this.useGroup) {
            super.setEnabled(enabled, parent);
        }
        int i = 0;
        while (i < this.radioButtons.length) {
            this.radioButtons[i].setEnabled(enabled);
            ++i;
        }
    }

    public void update(final String[][] newLabelsAndValues) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                DotExportRadioGroupFieldEditor.this.clear();
                DotExportRadioGroupFieldEditor.this.labelsAndValues = newLabelsAndValues;
                if (DotExportRadioGroupFieldEditor.this.radioBox == null) {
                    if (DotExportRadioGroupFieldEditor.this.parent.isDisposed()) {
                        return;
                    }
                    if (DotExportRadioGroupFieldEditor.this.useGroup) {
                        Group group = new Group(DotExportRadioGroupFieldEditor.this.parent, 0);
                        String text = DotExportRadioGroupFieldEditor.this.getLabelText();
                        if (text != null) {
                            group.setText(text);
                        }
                        DotExportRadioGroupFieldEditor.this.radioBox = (Composite)group;
                        GridLayout layout = new GridLayout();
                        layout.horizontalSpacing = 8;
                        layout.numColumns = DotExportRadioGroupFieldEditor.this.numColumns;
                        DotExportRadioGroupFieldEditor.this.radioBox.setLayout((Layout)layout);
                    } else {
                        DotExportRadioGroupFieldEditor.this.radioBox = new Composite(DotExportRadioGroupFieldEditor.this.parent, 0);
                        GridLayout layout = new GridLayout();
                        layout.marginWidth = 0;
                        layout.marginHeight = 0;
                        layout.horizontalSpacing = 8;
                        layout.numColumns = DotExportRadioGroupFieldEditor.this.numColumns;
                        DotExportRadioGroupFieldEditor.this.radioBox.setLayout((Layout)layout);
                    }
                }
                if (DotExportRadioGroupFieldEditor.this.labelsAndValues != null) {
                    DotExportRadioGroupFieldEditor.this.radioButtons = new Button[DotExportRadioGroupFieldEditor.this.labelsAndValues.length];
                    int i = 0;
                    while (i < DotExportRadioGroupFieldEditor.this.labelsAndValues.length) {
                        Button radio;
                        ((DotExportRadioGroupFieldEditor)DotExportRadioGroupFieldEditor.this).radioButtons[i] = radio = new Button(DotExportRadioGroupFieldEditor.this.radioBox, 16400);
                        String[] labelAndValue = DotExportRadioGroupFieldEditor.this.labelsAndValues[i];
                        radio.setText(labelAndValue[0]);
                        radio.setData((Object)labelAndValue[1]);
                        radio.setFont(DotExportRadioGroupFieldEditor.this.parent.getFont());
                        radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent event) {
                                String oldValue = DotExportRadioGroupFieldEditor.this.value;
                                DotExportRadioGroupFieldEditor.this.value = (String)event.widget.getData();
                                DotExportRadioGroupFieldEditor.this.setPresentsDefaultValue(false);
                                DotExportRadioGroupFieldEditor.this.fireValueChanged("field_editor_value", oldValue, DotExportRadioGroupFieldEditor.this.value);
                            }
                        });
                        ++i;
                    }
                    DotExportRadioGroupFieldEditor.this.load();
                    DotExportRadioGroupFieldEditor.this.hideDotExportHintLabel();
                    DotExportRadioGroupFieldEditor.this.showOpenExportedFileBooleanFieldEditor();
                    DotExportRadioGroupFieldEditor.this.parent.layout();
                }
            }
        });
    }

    protected void hideDotExportHintLabel() {
        this.dotExportHintLabel.setVisible(false);
        ((GridData)this.dotExportHintLabel.getLayoutData()).exclude = true;
    }

    protected void showDotExportHintLabel() {
        this.dotExportHintLabel.setVisible(true);
        ((GridData)this.dotExportHintLabel.getLayoutData()).exclude = false;
    }

    protected void hideOpenExportedFileBooleanFieldEditor() {
        Button checkBox = this.openExportedFileBooleanFieldEditor.getChangeControl(this.parent);
        checkBox.setVisible(false);
        ((GridData)checkBox.getLayoutData()).exclude = true;
    }

    protected void showOpenExportedFileBooleanFieldEditor() {
        Button checkBox = this.openExportedFileBooleanFieldEditor.getChangeControl(this.parent);
        checkBox.setVisible(true);
        ((GridData)checkBox.getLayoutData()).exclude = false;
    }

    protected void addOpenExportedFileBooleanFieldEditor(BooleanFieldEditor2 openExportedFileBooleanFieldEditor) {
        this.openExportedFileBooleanFieldEditor = openExportedFileBooleanFieldEditor;
    }

    public void clear() {
        this.labelsAndValues = null;
        if (this.radioButtons != null) {
            Button[] buttonArray = this.radioButtons;
            int n = this.radioButtons.length;
            int n2 = 0;
            while (n2 < n) {
                Button radioButton = buttonArray[n2];
                radioButton.dispose();
                ++n2;
            }
            this.showDotExportHintLabel();
            this.hideOpenExportedFileBooleanFieldEditor();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    DotExportRadioGroupFieldEditor.this.parent.layout();
                }
            });
        }
    }
}

