/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import org.eclipse.gef.fx.nodes.Connection;
import org.eclipse.gef.geometry.planar.Line;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.geometry.planar.Polyline;
import org.eclipse.gef.mvc.fx.models.SnappingModel;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.providers.ISnappingLocationProvider;

public class ConnectionSnappingLocationProvider
implements ISnappingLocationProvider {
    protected Connection getConnection(IContentPart<? extends Node> part) {
        Object visual = part.getVisual();
        if (visual instanceof Connection) {
            return (Connection)visual;
        }
        return null;
    }

    @Override
    public List<SnappingModel.SnappingLocation> getHorizontalSnappingLocations(IContentPart<? extends Node> part) {
        return this.getSnappingLocations(part, Orientation.HORIZONTAL);
    }

    protected List<SnappingModel.SnappingLocation> getSnappingLocations(IContentPart<? extends Node> part, Orientation orientation) {
        Connection connection = this.getConnection(part);
        if (connection == null) {
            return Collections.emptyList();
        }
        ArrayList<SnappingModel.SnappingLocation> locs = new ArrayList<SnappingModel.SnappingLocation>();
        Polyline polyline = new Polyline((Point[])connection.getPointsUnmodifiable().toArray((Object[])new Point[0]));
        Line[] lineArray = polyline.toBezier();
        int n = lineArray.length;
        int n2 = 0;
        while (n2 < n) {
            Line segment = lineArray[n2];
            Point p1 = segment.getP1();
            Point p2 = segment.getP2();
            if (p1.x == p2.x && orientation == Orientation.HORIZONTAL) {
                locs.add(new SnappingModel.SnappingLocation(part, orientation, p1.x));
            } else if (p1.y == p2.y && orientation == Orientation.VERTICAL) {
                locs.add(new SnappingModel.SnappingLocation(part, orientation, p1.y));
            }
            ++n2;
        }
        return locs;
    }

    @Override
    public List<SnappingModel.SnappingLocation> getVerticalSnappingLocations(IContentPart<? extends Node> part) {
        return this.getSnappingLocations(part, Orientation.VERTICAL);
    }
}

