/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit5.runner;

import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jdt.internal.junit.runner.ITestIdentifier;
import org.eclipse.jdt.internal.junit.runner.ITestReference;
import org.eclipse.jdt.internal.junit.runner.IVisitsTestTrees;
import org.eclipse.jdt.internal.junit.runner.RemoteTestRunner;
import org.eclipse.jdt.internal.junit.runner.TestExecution;
import org.eclipse.jdt.internal.junit5.runner.JUnit5Identifier;
import org.eclipse.jdt.internal.junit5.runner.JUnit5TestListener;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

public class JUnit5TestReference
implements ITestReference {
    private LauncherDiscoveryRequest fRequest;
    private Launcher fLauncher;
    private TestPlan fTestPlan;
    private RemoteTestRunner fRemoteTestRunner;

    public JUnit5TestReference(LauncherDiscoveryRequest request, Launcher launcher, RemoteTestRunner remoteTestRunner) {
        this.fRequest = request;
        this.fLauncher = launcher;
        this.fRemoteTestRunner = remoteTestRunner;
        this.fTestPlan = this.fLauncher.discover(this.fRequest);
    }

    public int countTestCases() {
        return (int)this.fTestPlan.countTestIdentifiers(TestIdentifier::isTest);
    }

    public void sendTree(IVisitsTestTrees notified) {
        for (TestIdentifier root : this.fTestPlan.getRoots()) {
            for (TestIdentifier child : this.fTestPlan.getChildren(root)) {
                this.sendTree(notified, child);
            }
        }
    }

    private void sendTree(IVisitsTestTrees notified, TestIdentifier testIdentifier) {
        JUnit5Identifier identifier = new JUnit5Identifier(testIdentifier);
        String parentId = this.getParentId(testIdentifier, this.fTestPlan);
        if (testIdentifier.isTest()) {
            notified.visitTreeEntry((ITestIdentifier)identifier, false, 1, false, parentId);
        } else {
            Set children = this.fTestPlan.getChildren(testIdentifier);
            notified.visitTreeEntry((ITestIdentifier)identifier, true, children.size(), false, parentId);
            for (TestIdentifier child : children) {
                this.sendTree(notified, child);
            }
        }
    }

    private String getParentId(TestIdentifier testIdentifier, TestPlan testPlan) {
        return testPlan.getParent(testIdentifier).map(parent -> this.fRemoteTestRunner.getTestId((ITestIdentifier)new JUnit5Identifier((TestIdentifier)parent))).orElse("-1");
    }

    public void run(TestExecution execution) {
        boolean foundMethodThatAvoidsRedundantDiscovery;
        JUnit5TestReference.registerStopListener(this.fLauncher, execution);
        try {
            this.fLauncher.getClass().getMethod("execute", TestPlan.class, TestExecutionListener[].class);
            foundMethodThatAvoidsRedundantDiscovery = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            foundMethodThatAvoidsRedundantDiscovery = false;
        }
        if (foundMethodThatAvoidsRedundantDiscovery) {
            this.fLauncher.execute(this.fTestPlan, new TestExecutionListener[]{new JUnit5TestListener(execution.getListener(), this.fRemoteTestRunner)});
        } else {
            this.fLauncher.execute(this.fRequest, new TestExecutionListener[]{new JUnit5TestListener(execution.getListener(), this.fRemoteTestRunner)});
        }
    }

    public ITestIdentifier getIdentifier() {
        return new JUnit5Identifier((TestIdentifier)this.fTestPlan.getRoots().iterator().next());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JUnit5TestReference)) {
            return false;
        }
        JUnit5TestReference ref = (JUnit5TestReference)obj;
        return ref.fRequest.equals(this.fRequest);
    }

    public int hashCode() {
        return this.fRequest.hashCode();
    }

    public String toString() {
        return this.fRequest.toString();
    }

    private static void registerStopListener(Launcher launcher, TestExecution execution) {
        final AtomicBoolean stopped = new AtomicBoolean(false);
        execution.addStopListener(() -> stopped.set(true));
        launcher.registerTestExecutionListeners(new TestExecutionListener[]{new TestExecutionListener(){

            public void executionStarted(TestIdentifier testIdentifier) {
                if (stopped.get()) {
                    throw new OutOfMemoryError("Junit5 test stopped by user");
                }
            }
        }});
    }
}

