/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.linuxtools.internal.rpm.ui.editor.Activator;
import org.eclipse.linuxtools.internal.rpm.ui.editor.Messages;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileLog;
import org.eclipse.linuxtools.internal.rpm.ui.editor.scanners.SpecfileScanner;
import org.eclipse.linuxtools.rpm.core.utils.Utils;

public class RpmMacroProposalsList {
    private static final String EMPTY_STRING = "";
    private Map<String, String> macroMap = new HashMap<String, String>();
    private String toStringStr;

    public RpmMacroProposalsList() {
        this.buildMacroList();
    }

    public final void buildMacroList() {
        String[] stringArray = SpecfileScanner.DEFINED_MACROS;
        int n = SpecfileScanner.DEFINED_MACROS.length;
        int n2 = 0;
        while (n2 < n) {
            String definedMacro = stringArray[n2];
            this.macroMap.put(definedMacro, Messages.RpmMacroProposalsList_0);
            ++n2;
        }
        String macroProposalsPaths = Activator.getDefault().getPreferenceStore().getString("macroProposalsFilespath");
        String[] paths = macroProposalsPaths.split(";");
        String[] stringArray2 = paths = this.reverseStringArray(paths);
        int n3 = paths.length;
        int n4 = 0;
        while (n4 < n3) {
            File pathFile;
            String path = stringArray2[n4];
            if (!path.equals(EMPTY_STRING) && (pathFile = new File(path)).exists()) {
                if (pathFile.isDirectory()) {
                    File[] macrosFiles;
                    File[] fileArray = macrosFiles = pathFile.listFiles();
                    int n5 = macrosFiles.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        File macrosFile = fileArray[n6];
                        this.addMacroToMap(macrosFile.getAbsolutePath());
                        ++n6;
                    }
                } else {
                    this.addMacroToMap(path);
                }
            }
            ++n4;
        }
    }

    private void addMacroToMap(String filename) {
        String line = EMPTY_STRING;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));){
                line = reader.readLine();
                String key = EMPTY_STRING;
                Object value = EMPTY_STRING;
                while (line != null) {
                    if (line.startsWith("%")) {
                        String[] item = line.split("\t+| ", 2);
                        try {
                            if (line.trim().endsWith("\\")) {
                                value = "\n";
                                boolean isKeyLine = true;
                                while (line.trim().endsWith("\\")) {
                                    if (isKeyLine) {
                                        isKeyLine = false;
                                        key = item[0];
                                        if (item.length > 1) {
                                            value = (String)value + item[1].replace("\\", "\n\n");
                                        }
                                    } else {
                                        value = (String)value + line.substring(0, line.length() - 1).trim() + "\n\t";
                                    }
                                    line = reader.readLine();
                                }
                            } else {
                                key = item[0];
                                value = item[1];
                            }
                            key = key.trim();
                            value = ((String)value).trim();
                            this.macroMap.put(key, (String)value);
                            this.toStringStr = String.valueOf(this.toStringStr) + key + ": " + (String)value + "\n";
                        }
                        catch (Exception e) {
                            line = reader.readLine();
                            continue;
                        }
                        value = EMPTY_STRING;
                        key = EMPTY_STRING;
                    }
                    line = reader.readLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            SpecfileLog.logError(e);
        }
    }

    private String[] reverseStringArray(String[] stringArrayToReverse) {
        int left = 0;
        int right = stringArrayToReverse.length - 1;
        while (left < right) {
            String tmp = stringArrayToReverse[left];
            stringArrayToReverse[left] = stringArrayToReverse[right];
            stringArrayToReverse[right] = tmp;
            ++left;
            --right;
        }
        return stringArrayToReverse;
    }

    public Map<String, String> getProposals(String prefix) {
        HashMap<String, String> proposalsMap = new HashMap<String, String>(this.macroMap.size());
        for (Map.Entry<String, String> entry : this.macroMap.entrySet()) {
            if (!entry.getKey().startsWith(prefix.replaceFirst("\\{", EMPTY_STRING))) continue;
            proposalsMap.put(entry.getKey(), entry.getValue());
        }
        return new TreeMap<String, String>(proposalsMap);
    }

    public String getValue(String key) {
        String value = this.macroMap.get("%" + key);
        if (value == null) {
            value = this.macroMap.get(("%" + key).replaceFirst("\\?", EMPTY_STRING));
        }
        return value;
    }

    public boolean findKey(String keyToFind) {
        return this.macroMap.containsKey(keyToFind);
    }

    public static String getMacroEval(String macroName) {
        String eval = EMPTY_STRING;
        try {
            eval = Utils.runCommandToString((String[])new String[]{"rpm", "--eval", macroName});
        }
        catch (IOException e) {
            SpecfileLog.logError(e);
        }
        return eval.trim();
    }

    public String toString() {
        return this.toStringStr;
    }
}

