/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor.scanners;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.linuxtools.internal.rpm.ui.editor.Activator;
import org.eclipse.linuxtools.internal.rpm.ui.editor.detectors.PackageWordDetector;
import org.eclipse.linuxtools.internal.rpm.ui.editor.detectors.TagWordDetector;
import org.eclipse.linuxtools.internal.rpm.ui.editor.rules.MacroRule;
import org.eclipse.ui.PlatformUI;

public class SpecfilePackagesScanner
extends RuleBasedScanner {
    protected static final String[] PACKAGES_TAGS = new String[]{"BuildRequires", "BuildConflicts", "BuildPreReq", "Enhances", "Recommends", "Requires", "Requires(post)", "Requires(postun)", "Requires(pre)", "Requires(preun)", "Requires(hint)", "Conflicts", "Obsoletes", "Prereq", "Suggests", "Supplements"};

    public SpecfilePackagesScanner() {
        ColorRegistry colors = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        Token packageToken = new Token((Object)new TextAttribute(colors.get("org.eclipse.linuxtools.rpm.editor.color.packages"), null, 0));
        Token tagToken = new Token((Object)new TextAttribute(colors.get("org.eclipse.linuxtools.rpm.editor.color.tags")));
        Token macroToken = new Token((Object)new TextAttribute(colors.get("org.eclipse.linuxtools.rpm.editor.color.macros")));
        ArrayList<MacroRule> rules = new ArrayList<MacroRule>();
        rules.add(new MacroRule((IToken)macroToken));
        WordRule wordRule = new WordRule((IWordDetector)new TagWordDetector(), Token.UNDEFINED);
        String[] stringArray = PACKAGES_TAGS;
        int n = PACKAGES_TAGS.length;
        int n2 = 0;
        while (n2 < n) {
            String packageTag = stringArray[n2];
            wordRule.addWord(packageTag + ":", (IToken)tagToken);
            ++n2;
        }
        rules.add((MacroRule)wordRule);
        wordRule = new WordRule((IWordDetector)new PackageWordDetector(), Token.UNDEFINED);
        List<String[]> rpmPackages = Activator.getDefault().getRpmPackageList().getProposals("");
        char[] startWith = new char[]{' ', '\t', ',', ':'};
        for (String[] item : rpmPackages) {
            char[] cArray = startWith;
            int n3 = startWith.length;
            int n4 = 0;
            while (n4 < n3) {
                char startChar = cArray[n4];
                wordRule.addWord(startChar + item[0], (IToken)packageToken);
                ++n4;
            }
        }
        rules.add((MacroRule)wordRule);
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
        this.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(colors.get("org.eclipse.linuxtools.rpm.edtor.color.default"))));
    }
}

