/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.ui;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.commons.ui.E4CssParseException;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class E4ThemeColor {
    private static boolean loggedError = false;

    public static RGB getRGBFromCssString(String cssValue) {
        try {
            if (cssValue.startsWith("rgb(")) {
                String[] rgbValues;
                String rest = cssValue.substring(4, cssValue.length());
                int idx = rest.indexOf("rgb(");
                if (idx != -1) {
                    rest = rest.substring(idx + 4, rest.length());
                }
                if ((idx = rest.indexOf(")")) != -1) {
                    rest = rest.substring(0, idx);
                }
                if ((rgbValues = rest.split(",")).length == 3) {
                    return new RGB(Integer.parseInt(rgbValues[0].trim()), Integer.parseInt(rgbValues[1].trim()), Integer.parseInt(rgbValues[2].trim()));
                }
            } else if (cssValue.startsWith("#")) {
                String rest;
                int idx;
                if (cssValue.equals("#org-eclipse-ui-workbench-DARK_BACKGROUND")) {
                    cssValue = "#515658";
                }
                if (cssValue.equals("#org-eclipse-ui-workbench-DARK_FOREGROUND")) {
                    cssValue = "#eeeeee";
                }
                if ((idx = (rest = cssValue.substring(1, cssValue.length())).indexOf("#")) != -1) {
                    rest = rest.substring(idx + 1, rest.length());
                }
                if (rest.length() > 5) {
                    return new RGB(Integer.parseInt(rest.substring(0, 2), 16), Integer.parseInt(rest.substring(2, 4), 16), Integer.parseInt(rest.substring(4, 6), 16));
                }
            }
            throw new E4CssParseException("RGB", cssValue);
        }
        catch (NumberFormatException | E4CssParseException e) {
            E4ThemeColor.logOnce(e);
            return null;
        }
    }

    public static String getCssValueFromTheme(Display display, String value) {
        BundleContext context = FrameworkUtil.getBundle(E4ThemeColor.class).getBundleContext();
        try {
            CSSValue cssValue;
            CSSStyleDeclaration shellStyle;
            Object themeEngine;
            Object iThemeManager;
            Object reference = MethodUtils.invokeMethod((Object)context, (String)"getServiceReference", (Object[])new Object[]{"org.eclipse.e4.ui.css.swt.theme.IThemeManager"});
            if (reference != null && (iThemeManager = MethodUtils.invokeMethod((Object)context, (String)"getService", (Object[])new Object[]{reference})) != null && (themeEngine = MethodUtils.invokeMethod((Object)iThemeManager, (String)"getEngineForDisplay", (Object[])new Object[]{display})) != null && (shellStyle = E4ThemeColor.getStyleDeclaration(themeEngine, display)) != null && (cssValue = shellStyle.getPropertyCSSValue(value)) != null) {
                return cssValue.getCssText();
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            E4ThemeColor.logOnce(e);
            return null;
        }
        return null;
    }

    private static CSSStyleDeclaration getStyleDeclaration(Object themeEngine, Display display) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Shell shell = display.getActiveShell();
        CSSStyleDeclaration shellStyle = null;
        if (shell != null) {
            shellStyle = E4ThemeColor.retrieveStyleFromShell(themeEngine, shell);
        } else {
            Shell[] shellArray = display.getShells();
            int n = shellArray.length;
            int n2 = 0;
            while (n2 < n) {
                Shell input = shellArray[n2];
                shellStyle = E4ThemeColor.retrieveStyleFromShell(themeEngine, input);
                if (shellStyle != null) break;
                ++n2;
            }
        }
        return shellStyle;
    }

    private static CSSStyleDeclaration retrieveStyleFromShell(Object themeEngine, Shell shell) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object shellStyle = MethodUtils.invokeMethod((Object)themeEngine, (String)"getStyle", (Object[])new Object[]{shell});
        if (shellStyle instanceof CSSStyleDeclaration) {
            return (CSSStyleDeclaration)shellStyle;
        }
        return null;
    }

    private static void logOnce(Exception e) {
        if (!loggedError) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.commons.ui", e.getMessage(), (Throwable)e));
            loggedError = true;
        }
    }
}

