/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.dialogs.Messages;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TaskRepositoryCredentialsDialog
extends TitleAreaDialog {
    private static final String DIALOG_TITLE = Messages.TaskRepositoryCredentialsDialog_Enter_Credentials;
    private static final String IMAGE_FILE_KEYLOCK = "icons/wizban/secur_role_wiz.gif";
    public static final int TASK_REPOSITORY_CHANGED = 1000;
    private static final String MESSAGE = Messages.TaskRepositoryCredentialsDialog_Enter_repository_credentials;
    private static final String TITLE = Messages.TaskRepositoryCredentialsDialog_Repository_Authentication;
    private Image keyLockImage;
    private String message;
    private String password = "";
    private boolean savePassword;
    private TaskRepository taskRepository;
    private String username = "";
    private Button certBrowseButton;
    private boolean isFileDialog;

    public static TaskRepositoryCredentialsDialog createDialog(Shell shell) {
        return new TaskRepositoryCredentialsDialog(shell);
    }

    private TaskRepositoryCredentialsDialog(Shell parentShell) {
        super(parentShell);
    }

    public boolean close() {
        if (this.keyLockImage != null) {
            this.keyLockImage.dispose();
        }
        return super.close();
    }

    private void createLinkArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(768));
        Link link = new Link(composite, 64);
        link.setText(Messages.TaskRepositoryCredentialsDialog_HTML_Open_Repository_Properties);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskRepositoryCredentialsDialog.this.close();
                int returnCode = TasksUiUtil.openEditRepositoryWizard(TaskRepositoryCredentialsDialog.this.taskRepository);
                if (returnCode == 0) {
                    TaskRepositoryCredentialsDialog.this.setReturnCode(1000);
                } else {
                    TaskRepositoryCredentialsDialog.this.setReturnCode(returnCode);
                }
            }
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(this.convertHorizontalDLUsToPixels(300), -1).grab(true, false).applyTo((Control)link);
    }

    private void createCenterArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(768));
        if (this.taskRepository != null) {
            Composite labelComposite = new Composite(composite, 0);
            GridLayout layout = new GridLayout(3, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            labelComposite.setLayout((Layout)layout);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(3, 1).applyTo((Control)labelComposite);
            Label label = new Label(labelComposite, 0);
            label.setImage(TasksUiPlugin.getDefault().getBrandManager().getBrandingIcon(this.taskRepository));
            label = new Label(labelComposite, 0);
            label.setText(Messages.TaskRepositoryCredentialsDialog_Task_Repository);
            label = new Label(labelComposite, 0);
            label.setText(this.taskRepository.getRepositoryLabel());
        }
        if (this.isFileDialog) {
            new Label(composite, 0).setText(Messages.TaskRepositoryCredentialsDialog_Filename);
        } else {
            new Label(composite, 0).setText(Messages.TaskRepositoryCredentialsDialog_User_ID);
        }
        final Text usernameField = new Text(composite, 2048);
        usernameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TaskRepositoryCredentialsDialog.this.username = usernameField.getText();
            }
        });
        usernameField.setText(this.username);
        if (this.username.length() == 0) {
            usernameField.setFocus();
        }
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(this.convertHorizontalDLUsToPixels(200), -1).grab(true, false).applyTo((Control)usernameField);
        if (this.isFileDialog) {
            this.certBrowseButton = new Button(composite, 8);
            this.certBrowseButton.setText(Messages.TaskRepositoryCredentialsDialog_ChooseCertificateFile);
            this.certBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FileDialog fileDialog = new FileDialog(TaskRepositoryCredentialsDialog.this.getShell(), 4096);
                    fileDialog.setFilterPath(System.getProperty("user.home", "."));
                    String returnFile = fileDialog.open();
                    if (returnFile != null) {
                        TaskRepositoryCredentialsDialog.this.username = returnFile;
                        usernameField.setText(returnFile);
                    }
                }
            });
        } else {
            new Label(composite, 0).setText(" ");
        }
        new Label(composite, 0).setText(Messages.TaskRepositoryCredentialsDialog_Password);
        final Text passwordField = new Text(composite, 0x400800);
        passwordField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TaskRepositoryCredentialsDialog.this.password = passwordField.getText();
            }
        });
        passwordField.setText(this.password);
        if (this.username.length() > 0) {
            passwordField.setFocus();
        }
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(this.convertHorizontalDLUsToPixels(200), -1).grab(true, false).applyTo((Control)passwordField);
        final Button savePasswordButton = new Button(composite, 32);
        savePasswordButton.setText(Messages.TaskRepositoryCredentialsDialog_Save_Password);
        savePasswordButton.setSelection(this.savePassword);
        savePasswordButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskRepositoryCredentialsDialog.this.savePassword = savePasswordButton.getSelection();
            }
        });
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)savePasswordButton);
        this.createWarningMessage(composite);
    }

    protected Control createContents(Composite parent) {
        ImageDescriptor descriptor;
        AbstractRepositoryConnector connector;
        this.getShell().setText(DIALOG_TITLE);
        this.setTitle(TITLE);
        Control control = super.createContents(parent);
        if (this.taskRepository != null && (connector = TasksUi.getRepositoryManager().getRepositoryConnector(this.taskRepository.getConnectorKind())) != null) {
            this.setTitle(connector.getShortLabel() + " " + TITLE);
        }
        if ((descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.mylyn.tasks.ui", (String)IMAGE_FILE_KEYLOCK)) != null) {
            this.keyLockImage = descriptor.createImage();
            this.setTitleImage(this.keyLockImage);
        }
        if (this.message != null) {
            super.setMessage(this.message);
        } else {
            super.setMessage(MESSAGE);
        }
        TaskRepositoryCredentialsDialog.applyDialogFont((Control)control);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parent2 = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parent2, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)composite);
        this.createCenterArea(composite);
        if (this.taskRepository != null) {
            this.createLinkArea(composite);
        }
        composite.pack();
        return parent;
    }

    private void createWarningMessage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)composite);
        Label label = new Label(composite, 0);
        label.setImage(Dialog.getImage((String)"dialog_messasge_warning_image"));
        label.setLayoutData((Object)new GridData(34));
        label = new Label(composite, 64);
        label.setText(Messages.TaskRepositoryCredentialsDialog_Saved_passwords_are_stored_that_is_difficult);
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(this.convertHorizontalDLUsToPixels(300), -1).grab(true, false).applyTo((Control)label);
    }

    public String getMessage() {
        return this.message;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean getSavePassword() {
        return this.savePassword;
    }

    public TaskRepository getTaskRepository() {
        return this.taskRepository;
    }

    public String getUserName() {
        return this.username;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setPassword(String password) {
        if (password == null) {
            throw new IllegalArgumentException();
        }
        this.password = password;
    }

    public void setSavePassword(boolean savePassword) {
        this.savePassword = savePassword;
    }

    public void setTaskRepository(TaskRepository taskRepository) {
        this.taskRepository = taskRepository;
    }

    public void setUsername(String username) {
        if (username == null) {
            throw new IllegalArgumentException();
        }
        this.username = username;
    }

    public void setFileDialog(boolean isFileDialog) {
        this.isFileDialog = isFileDialog;
    }
}

