/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.mylyn.commons.core.CoreUtil;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.identity.core.Account;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.ui.CommonUiUtil;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.monitor.ui.MonitorUiPlugin;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.ITaskJobFactory;
import org.eclipse.mylyn.internal.tasks.core.ITaskList;
import org.eclipse.mylyn.internal.tasks.core.LocalRepositoryConnector;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.UncategorizedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.UnsubmittedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataState;
import org.eclipse.mylyn.internal.tasks.core.sync.SynchronizationScheduler;
import org.eclipse.mylyn.internal.tasks.core.util.TasksCoreUtil;
import org.eclipse.mylyn.internal.tasks.ui.OpenRepositoryTaskJob;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskDropHandler;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskOpenEvent;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskOpenListener;
import org.eclipse.mylyn.internal.tasks.ui.util.WebBrowserDialog;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.internal.tasks.ui.wizards.MultiRepositoryAwareWizard;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewAttachmentWizardDialog;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewTaskWizardInternal;
import org.eclipse.mylyn.internal.tasks.ui.wizards.QueryWizardDialog;
import org.eclipse.mylyn.internal.tasks.ui.wizards.TaskAttachmentWizard;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.ITaskDataWorkingCopy;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskCommentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskHistory;
import org.eclipse.mylyn.tasks.core.data.TaskRevision;
import org.eclipse.mylyn.tasks.core.sync.SynchronizationJob;
import org.eclipse.mylyn.tasks.core.sync.TaskJob;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.progress.IProgressConstants2;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;

public class TasksUiInternal {
    private static SynchronizationScheduler synchronizationScheduler = new SynchronizationScheduler();
    private static final TaskDropHandler taskDropHandler = new TaskDropHandler();
    @Deprecated
    public static final int SWT_SHEET = 0x10000000;
    public static final String ID_MENU_ACTIVE_TASK = "org.eclipse.mylyn.tasks.ui.menus.activeTask";
    private static ObjectUndoContext undoContext;

    public static MultiRepositoryAwareWizard createNewTaskWizard(ITaskMapping taskSelection) {
        return new NewTaskWizardInternal(taskSelection);
    }

    public static Command getConfiguredDiscoveryWizardCommand() {
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command discoveryWizardCommand = service.getCommand("org.eclipse.mylyn.tasks.ui.discoveryWizardCommand");
        if (discoveryWizardCommand != null) {
            IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            EvaluationContext evaluationContext = TasksUiInternal.createDiscoveryWizardEvaluationContext(handlerService);
            if (!discoveryWizardCommand.isEnabled()) {
                discoveryWizardCommand.setEnabled((Object)evaluationContext);
            }
        }
        return discoveryWizardCommand;
    }

    public static EvaluationContext createDiscoveryWizardEvaluationContext(IHandlerService handlerService) {
        EvaluationContext evaluationContext = new EvaluationContext(handlerService.getCurrentState(), Platform.class);
        evaluationContext.addVariable("platform", Platform.class);
        return evaluationContext;
    }

    public static ImageDescriptor getPriorityImage(ITask task) {
        if (task.isCompleted()) {
            return CommonImages.COMPLETE;
        }
        return TasksUiImages.getImageDescriptorForPriority(ITask.PriorityLevel.fromString((String)task.getPriority()));
    }

    public static List<TaskEditor> getActiveRepositoryTaskEditors() {
        IWorkbenchWindow[] windows;
        ArrayList<TaskEditor> repositoryTaskEditors = new ArrayList<TaskEditor>();
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference[] editorReferences;
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IEditorReference[] iEditorReferenceArray = editorReferences = window.getActivePage().getEditorReferences();
            int n3 = editorReferences.length;
            int n4 = 0;
            while (n4 < n3) {
                IEditorReference editorReference = iEditorReferenceArray[n4];
                try {
                    IEditorPart editorPart;
                    TaskEditorInput input;
                    if (editorReference.getEditorInput() instanceof TaskEditorInput && (input = (TaskEditorInput)editorReference.getEditorInput()).getTask() != null && (editorPart = editorReference.getEditor(false)) instanceof TaskEditor) {
                        repositoryTaskEditors.add((TaskEditor)editorPart);
                    }
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
                ++n4;
            }
            ++n2;
        }
        return repositoryTaskEditors;
    }

    public static IProgressMonitor getUiMonitor(IProgressMonitor monitor) {
        return new ProgressMonitorWrapper(monitor){

            public void beginTask(final String name, final int totalWork) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        this.getWrappedProgressMonitor().beginTask(name, totalWork);
                    }
                });
            }

            public void done() {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        this.getWrappedProgressMonitor().done();
                    }
                });
            }

            public void subTask(final String name) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        this.getWrappedProgressMonitor().subTask(name);
                    }
                });
            }

            public void worked(final int work) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        this.getWrappedProgressMonitor().worked(work);
                    }
                });
            }
        };
    }

    public static void openEditor(TaskCategory category) {
        final String name = category.getSummary();
        InputDialog dialog = new InputDialog(WorkbenchUtil.getShell(), Messages.TasksUiInternal_Rename_Category_Title, Messages.TasksUiInternal_Rename_Category_Message, name, new IInputValidator(){

            public String isValid(String newName) {
                if (newName.trim().length() == 0 || newName.equals(name)) {
                    return "";
                }
                Set categories = TasksUiPlugin.getTaskList().getCategories();
                for (AbstractTaskCategory category : categories) {
                    if (!newName.equals(category.getSummary())) continue;
                    return Messages.TasksUiInternal_Rename_Category_Name_already_exists_Error;
                }
                return null;
            }
        });
        if (dialog.open() == 0) {
            TasksUiPlugin.getTaskList().renameContainer((AbstractTaskContainer)category, dialog.getValue());
        }
    }

    public static void refreshAndOpenTaskListElement(IRepositoryElement element) {
        if (element instanceof ITask) {
            final AbstractTask task = (AbstractTask)element;
            if (task instanceof LocalTask) {
                TasksUiUtil.openTask((ITask)task);
            } else {
                String repositoryKind = task.getConnectorKind();
                AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(repositoryKind);
                TaskRepository repository = TasksUi.getRepositoryManager().getRepository(repositoryKind, task.getRepositoryUrl());
                if (repository == null) {
                    TasksUiInternal.displayStatus(Messages.TasksUiInternal_Failed_to_open_task, (IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", Messages.TasksUiInternal_No_repository_found));
                    return;
                }
                if (connector != null) {
                    boolean opened = false;
                    if (TasksUiPlugin.getTaskDataManager().hasTaskData((ITask)task)) {
                        opened = TasksUiUtil.openTask((ITask)task);
                    }
                    if (!opened) {
                        if (connector.canSynchronizeTask(repository, (ITask)task)) {
                            TasksUiInternal.synchronizeTask(connector, (ITask)task, true, (IJobChangeListener)new JobChangeAdapter(){

                                public void done(IJobChangeEvent event) {
                                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            TasksUiUtil.openTask((ITask)task);
                                        }
                                    });
                                }
                            });
                        } else {
                            TasksUiUtil.openTask((ITask)task);
                        }
                    }
                }
            }
        } else if (element instanceof TaskCategory) {
            TasksUiInternal.openEditor((TaskCategory)element);
        } else if (element instanceof IRepositoryQuery) {
            RepositoryQuery query = (RepositoryQuery)element;
            AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(query.getConnectorKind());
            TasksUiInternal.openEditQueryDialog(connectorUi, (IRepositoryQuery)query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskJob updateRepositoryConfiguration(final TaskRepository taskRepository) {
        TaskRepository taskRepository2 = taskRepository;
        synchronized (taskRepository2) {
            taskRepository.setUpdating(true);
        }
        AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(taskRepository.getConnectorKind());
        final TaskJob job = TasksUiInternal.getJobFactory().createUpdateRepositoryConfigurationJob(connector, taskRepository, null);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void done(IJobChangeEvent event) {
                TaskRepository taskRepository2 = taskRepository;
                synchronized (taskRepository2) {
                    taskRepository.setUpdating(false);
                }
                if (job.getStatus() != null) {
                    TasksUiInternal.asyncLogAndDisplayStatus(Messages.TasksUiInternal_Configuration_Refresh_Failed, job.getStatus());
                }
            }
        });
        job.schedule();
        return job;
    }

    private static void joinIfInTestMode(SynchronizationJob job) {
        if (CoreUtil.TEST_MODE) {
            try {
                job.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static final Job synchronizeQueries(AbstractRepositoryConnector connector, TaskRepository repository, Set<RepositoryQuery> queries, IJobChangeListener listener, boolean force) {
        Assert.isTrue((queries.size() > 0 ? 1 : 0) != 0);
        TaskList taskList = TasksUiPlugin.getTaskList();
        for (RepositoryQuery query : queries) {
            query.setSynchronizing(true);
        }
        taskList.notifySynchronizationStateChanged(queries);
        SynchronizationJob job = TasksUiPlugin.getTaskJobFactory().createSynchronizeQueriesJob(connector, repository, queries);
        job.setUser(force);
        if (force) {
            job.setProperty(IProgressConstants2.SHOW_IN_TASKBAR_ICON_PROPERTY, (Object)Boolean.TRUE);
        }
        if (listener != null) {
            job.addJobChangeListener(listener);
        }
        if (force) {
            final RepositoryQuery query = queries.iterator().next();
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (query.getStatus() != null) {
                        TasksUiInternal.asyncLogAndDisplayStatus(Messages.TasksUiInternal_Query_Synchronization_Failed, query.getStatus());
                    }
                }
            });
        }
        job.schedule();
        TasksUiInternal.joinIfInTestMode(job);
        return job;
    }

    public static final Job synchronizeQuery(AbstractRepositoryConnector connector, RepositoryQuery repositoryQuery, IJobChangeListener listener, boolean force) {
        TaskRepository repository = TasksUi.getRepositoryManager().getRepository(repositoryQuery.getConnectorKind(), repositoryQuery.getRepositoryUrl());
        return TasksUiInternal.synchronizeQueries(connector, repository, Collections.singleton(repositoryQuery), listener, force);
    }

    public static SynchronizationJob synchronizeAllRepositories(boolean force) {
        SynchronizationJob job = TasksUiPlugin.getTaskJobFactory().createSynchronizeRepositoriesJob(null);
        job.setUser(force);
        if (force) {
            job.setProperty(IProgressConstants2.SHOW_IN_TASKBAR_ICON_PROPERTY, (Object)Boolean.TRUE);
        }
        job.schedule();
        TasksUiInternal.joinIfInTestMode(job);
        return job;
    }

    public static void synchronizeRepositoryInBackground(final TaskRepository repository) {
        synchronizationScheduler.schedule((Object)repository, (SynchronizationScheduler.Synchronizer)new SynchronizationScheduler.Synchronizer<SynchronizationJob>(){

            public SynchronizationJob createJob() {
                return TasksUiInternal.synchronizeRepositoryInternal(repository, false);
            }
        });
    }

    public static SynchronizationJob synchronizeRepository(TaskRepository repository, boolean force) {
        SynchronizationJob job = TasksUiInternal.synchronizeRepositoryInternal(repository, force);
        synchronizationScheduler.cancel((Object)repository);
        job.schedule();
        return job;
    }

    private static SynchronizationJob synchronizeRepositoryInternal(TaskRepository repository, boolean force) {
        SynchronizationJob job = TasksUiInternal.getJobFactory().createSynchronizeRepositoriesJob(Collections.singleton(repository));
        job.setSystem(true);
        job.setUser(force);
        if (force) {
            job.setProperty(IProgressConstants2.SHOW_IN_TASKBAR_ICON_PROPERTY, (Object)Boolean.TRUE);
        }
        job.setFullSynchronization(false);
        return job;
    }

    public static void synchronizeTaskInBackground(final AbstractRepositoryConnector connector, final ITask task) {
        synchronizationScheduler.schedule((Object)task, (SynchronizationScheduler.Synchronizer)new SynchronizationScheduler.Synchronizer<Job>(){

            public Job createJob() {
                SynchronizationJob job = TasksUiPlugin.getTaskJobFactory().createSynchronizeTasksJob(connector, Collections.singleton(task));
                job.setUser(false);
                job.setSystem(true);
                return job;
            }
        });
    }

    public static Job synchronizeTask(AbstractRepositoryConnector connector, ITask task, boolean force, IJobChangeListener listener) {
        return TasksUiInternal.synchronizeTasks(connector, Collections.singleton(task), force, listener);
    }

    public static Job synchronizeTasks(AbstractRepositoryConnector connector, Set<ITask> tasks, boolean force, IJobChangeListener listener) {
        ITaskList taskList = TasksUiInternal.getTaskList();
        for (ITask task : tasks) {
            ((AbstractTask)task).setSynchronizing(true);
            synchronizationScheduler.cancel((Object)task);
        }
        ((TaskList)taskList).notifySynchronizationStateChanged(tasks);
        SynchronizationJob job = TasksUiPlugin.getTaskJobFactory().createSynchronizeTasksJob(connector, tasks);
        job.setUser(force);
        job.setSystem(!force);
        job.setPriority(50);
        if (listener != null) {
            job.addJobChangeListener(listener);
        }
        if (force && tasks.size() == 1) {
            final ITask task = tasks.iterator().next();
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (task instanceof AbstractTask && ((AbstractTask)task).getStatus() != null) {
                        TasksUiInternal.asyncLogAndDisplayStatus(Messages.TasksUiInternal_Task_Synchronization_Failed, ((AbstractTask)task).getStatus());
                    }
                }
            });
        }
        job.schedule();
        TasksUiInternal.joinIfInTestMode(job);
        return job;
    }

    public static ITaskJobFactory getJobFactory() {
        return TasksUiPlugin.getTaskJobFactory();
    }

    public static NewAttachmentWizardDialog openNewAttachmentWizard(Shell shell, TaskRepository taskRepository, ITask task, TaskAttribute taskAttribute, TaskAttachmentWizard.Mode mode, AbstractTaskAttachmentSource source) {
        TaskAttachmentWizard attachmentWizard = new TaskAttachmentWizard(taskRepository, task, taskAttribute);
        attachmentWizard.setSource(source);
        attachmentWizard.setMode(mode);
        NewAttachmentWizardDialog dialog = new NewAttachmentWizardDialog(shell, (IWizard)attachmentWizard, false);
        dialog.setBlockOnOpen(false);
        dialog.create();
        dialog.open();
        return dialog;
    }

    private static MessageDialog createDialog(Shell shell, String title, String message, int type) {
        return new MessageDialog(shell, title, null, message, type, new String[]{IDialogConstants.OK_LABEL}, 0);
    }

    private static void displayStatus(Shell shell, String title, IStatus status, boolean showLinkToErrorLog) {
        if (CoreUtil.TEST_MODE) {
            StatusHandler.log((IStatus)status);
            return;
        }
        if (status instanceof RepositoryStatus && ((RepositoryStatus)status).isHtmlMessage()) {
            WebBrowserDialog.openAcceptAgreement(shell, title, status.getMessage(), ((RepositoryStatus)status).getHtmlMessage());
        } else {
            Object message = status.getMessage();
            if (message == null || ((String)message).trim().length() == 0) {
                message = Messages.TasksUiInternal_An_unknown_error_occurred;
            }
            if (((String)message).length() > 256) {
                message = ((String)message).substring(0, 256) + "...";
            }
            if (showLinkToErrorLog) {
                message = (String)message + "\n\n" + Messages.TasksUiInternal_See_error_log_for_details;
            }
            switch (status.getSeverity()) {
                case 1: 
                case 8: {
                    TasksUiInternal.createDialog(shell, title, (String)message, 2).open();
                    break;
                }
                case 2: {
                    TasksUiInternal.createDialog(shell, title, (String)message, 4).open();
                    break;
                }
                default: {
                    TasksUiInternal.createDialog(shell, title, (String)message, 1).open();
                }
            }
        }
    }

    public static void asyncDisplayStatus(final String title, final IStatus status) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (!display.isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    TasksUiInternal.displayStatus(title, status);
                }
            });
        } else {
            StatusHandler.log((IStatus)status);
        }
    }

    public static void asyncLogAndDisplayStatus(final String title, final IStatus status) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (!display.isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    TasksUiInternal.logAndDisplayStatus(title, status);
                }
            });
        } else {
            StatusHandler.log((IStatus)status);
        }
    }

    public static void logAndDisplayStatus(String title, IStatus status) {
        StatusHandler.log((IStatus)status);
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && !workbench.getDisplay().isDisposed()) {
            TasksUiInternal.displayStatus(WorkbenchUtil.getShell(), title, status, false);
        }
    }

    public static void displayStatus(String title, IStatus status) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && !workbench.getDisplay().isDisposed()) {
            TasksUiInternal.displayStatus(WorkbenchUtil.getShell(), title, status, false);
        } else {
            StatusHandler.log((IStatus)status);
        }
    }

    public static LocalTask createNewLocalTask(String summary) {
        if (summary == null) {
            summary = LocalRepositoryConnector.DEFAULT_SUMMARY;
        }
        TaskList taskList = TasksUiPlugin.getTaskList();
        LocalTask newTask = new LocalTask("" + taskList.getNextLocalTaskId(), summary);
        newTask.setPriority(ITask.PriorityLevel.P3.toString());
        TasksUiInternal.getTaskList().addTask((ITask)newTask);
        TasksUiInternal.scheduleNewTask(newTask);
        TaskListView view = TaskListView.getFromActivePerspective();
        AbstractTaskCategory category = TasksUiInternal.getSelectedCategory(view);
        if (view != null && view.getDrilledIntoCategory() != null && view.getDrilledIntoCategory() != category) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.TasksUiInternal_Create_Task, (String)MessageFormat.format(Messages.TasksUiInternal_The_new_task_will_be_added_to_the_X_container, UncategorizedTaskContainer.LABEL));
        }
        newTask.setAttribute("org.eclipse.mylyn.tasks.ui.new.unsaved.task", Boolean.TRUE.toString());
        taskList.addTask((ITask)newTask, (AbstractTaskContainer)category);
        return newTask;
    }

    public static void scheduleNewTask(LocalTask newTask) {
        IPreferenceStore preferenceStore = TasksUiPlugin.getDefault().getPreferenceStore();
        String preference = preferenceStore.getString("org.eclipse.mylyn.tasks.ui.planning.schedule.new.tasks.for");
        DateRange dateRange = TasksUiInternal.getNewTaskScheduleDateRange(preference);
        TasksUiPlugin.getTaskActivityManager().scheduleNewTask((AbstractTask)newTask, dateRange);
    }

    private static DateRange getNewTaskScheduleDateRange(String preference) {
        switch (preference) {
            case "org.eclipse.mylyn.tasks.ui.planning.schedule.new.tasks.for.unscheduled": {
                return null;
            }
            case "org.eclipse.mylyn.tasks.ui.planning.schedule.new.tasks.for.today": {
                return TaskActivityUtil.getCurrentWeek().getToday();
            }
            case "org.eclipse.mylyn.tasks.ui.planning.schedule.new.tasks.for.tomorrow": {
                return TaskActivityUtil.getCurrentWeek().getToday().next();
            }
            case "org.eclipse.mylyn.tasks.ui.planning.schedule.new.tasks.for.this.week": {
                return TaskActivityUtil.getCurrentWeek();
            }
        }
        return TaskActivityUtil.getCurrentWeek();
    }

    public static AbstractTaskCategory getSelectedCategory(TaskListView view) {
        Object selectedObject = null;
        if (view != null) {
            selectedObject = ((IStructuredSelection)view.getViewer().getSelection()).getFirstElement();
        }
        if (selectedObject instanceof TaskCategory) {
            return (TaskCategory)selectedObject;
        }
        if (selectedObject instanceof ITask) {
            ITask task = (ITask)selectedObject;
            AbstractTaskCategory container = TaskCategory.getParentTaskCategory((ITask)task);
            if (container instanceof TaskCategory) {
                return (TaskCategory)container;
            }
            if (view != null && view.getDrilledIntoCategory() instanceof TaskCategory) {
                return (TaskCategory)view.getDrilledIntoCategory();
            }
        } else if (view != null && view.getDrilledIntoCategory() instanceof TaskCategory) {
            return (TaskCategory)view.getDrilledIntoCategory();
        }
        return TasksUiPlugin.getTaskList().getDefaultCategory();
    }

    public static Set<AbstractTaskContainer> getContainersFromWorkingSet(Set<IWorkingSet> containers) {
        HashSet<AbstractTaskContainer> allTaskContainersInWorkingSets = new HashSet<AbstractTaskContainer>();
        for (IWorkingSet workingSet : containers) {
            IAdaptable[] elements;
            IAdaptable[] iAdaptableArray = elements = workingSet.getElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IAdaptable adaptable = iAdaptableArray[n2];
                if (adaptable instanceof AbstractTaskContainer) {
                    allTaskContainersInWorkingSets.add((AbstractTaskContainer)adaptable);
                }
                ++n2;
            }
        }
        return allTaskContainersInWorkingSets;
    }

    public static boolean openEditQueryDialog(AbstractRepositoryConnectorUi connectorUi, final IRepositoryQuery query) {
        TaskRepository repository;
        block4: {
            repository = TasksUi.getRepositoryManager().getRepository(query.getConnectorKind(), query.getRepositoryUrl());
            if (repository != null) break block4;
            return false;
        }
        try {
            IWizard wizard = connectorUi.getQueryWizard(repository, query);
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            if (wizard != null && shell != null && !shell.isDisposed()) {
                QueryWizardDialog dialog = new QueryWizardDialog(shell, wizard){
                    private static final String DIALOG_SETTINGS = "EditQueryWizardWizard";

                    protected IDialogSettings getDialogBoundsSettings() {
                        String settingsSectionId;
                        IDialogSettings settings = TasksUiPlugin.getDefault().getDialogSettings();
                        IDialogSettings section = settings.getSection(settingsSectionId = "EditQueryWizardWizard." + query.getRepositoryUrl());
                        if (section == null) {
                            section = settings.addNewSection(settingsSectionId);
                        }
                        return section;
                    }
                };
                dialog.create();
                dialog.setBlockOnOpen(true);
                return dialog.open() != 1;
            }
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Failed to open query dialog", (Throwable)e));
        }
        return false;
    }

    public static ITaskList getTaskList() {
        return TasksUiPlugin.getTaskList();
    }

    public static boolean isAnimationsEnabled() {
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        return store.getBoolean("ENABLE_ANIMATIONS");
    }

    public static boolean hasValidUrl(ITask task) {
        return TasksUiInternal.isValidUrl(task.getUrl());
    }

    public static boolean isValidUrl(String url) {
        if (!(url == null || url.equals("") || url.equals("http://") || url.equals("https://"))) {
            try {
                new URL(url);
                return true;
            }
            catch (MalformedURLException e) {
                return false;
            }
        }
        return false;
    }

    @Deprecated
    public static void closeEditorInActivePage(ITask task, boolean save) {
        Assert.isNotNull((Object)task);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        TaskRepository taskRepository = TasksUi.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
        TaskEditorInput input = new TaskEditorInput(taskRepository, task);
        IEditorPart editor = page.findEditor((IEditorInput)input);
        if (editor != null) {
            page.closeEditor(editor, save);
        }
    }

    public static void closeTaskEditorInAllPages(ITask task, boolean save) {
        IWorkbenchWindow[] windows;
        Assert.isNotNull((Object)task);
        TaskRepository taskRepository = TasksUi.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
        TaskEditorInput input = new TaskEditorInput(taskRepository, task);
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage[] pages;
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
            int n3 = pages.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorPart editor = page.findEditor((IEditorInput)input);
                if (editor != null) {
                    page.closeEditor(editor, save);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static boolean hasLocalCompletionState(ITask task) {
        TaskRepository taskRepository = TasksUi.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
        AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(task.getConnectorKind());
        return connector.hasLocalCompletionState(taskRepository, task);
    }

    @Deprecated
    public static Shell getShell() {
        return WorkbenchUtil.getShell();
    }

    public static TaskData createTaskData(TaskRepository taskRepository, ITaskMapping initializationData, ITaskMapping selectionData, IProgressMonitor monitor) throws CoreException {
        TaskAttributeMapper mapper;
        TaskData taskData;
        AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(taskRepository.getConnectorKind());
        AbstractTaskDataHandler taskDataHandler = connector.getTaskDataHandler();
        boolean result = taskDataHandler.initializeTaskData(taskRepository, taskData = new TaskData(mapper = taskDataHandler.getAttributeMapper(taskRepository), taskRepository.getConnectorKind(), taskRepository.getRepositoryUrl(), ""), initializationData, monitor);
        if (!result) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Initialization of task failed. The provided data is insufficient."));
        }
        if (selectionData != null) {
            connector.getTaskMapping(taskData).merge(selectionData);
        }
        return taskData;
    }

    public static void createAndOpenNewTask(TaskData taskData) throws CoreException {
        UnsubmittedTaskContainer unsubmitted;
        String taskKind;
        ITask task = TasksUiUtil.createOutgoingNewTask(taskData.getConnectorKind(), taskData.getRepositoryUrl());
        AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(taskData.getConnectorKind());
        ITaskMapping mapping = connector.getTaskMapping(taskData);
        String summary = mapping.getSummary();
        if (StringUtils.isNotEmpty((CharSequence)summary)) {
            task.setSummary(summary);
        }
        if (StringUtils.isNotEmpty((CharSequence)(taskKind = mapping.getTaskKind()))) {
            task.setTaskKind(taskKind);
        }
        if ((unsubmitted = TasksUiPlugin.getTaskList().getUnsubmittedContainer(taskData.getRepositoryUrl())) != null) {
            TasksUiPlugin.getTaskList().addTask(task, (AbstractTaskContainer)unsubmitted);
        }
        ITaskDataWorkingCopy workingCopy = TasksUi.getTaskDataManager().createWorkingCopy(task, taskData);
        workingCopy.save(null, null);
        TaskRepository taskRepository = TasksUi.getRepositoryManager().getRepository(taskData.getConnectorKind(), taskData.getRepositoryUrl());
        connector.updateNewTaskFromTaskData(taskRepository, task, taskData);
        TaskRepository localTaskRepository = TasksUi.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
        TaskEditorInput editorInput = new TaskEditorInput(localTaskRepository, task);
        TasksUiUtil.openEditor(editorInput, "org.eclipse.mylyn.tasks.ui.editors.task", null);
    }

    public static boolean openTask(TaskRepository repository, String taskId, TaskOpenListener listener) {
        AbstractTask task = TasksUiInternal.getTaskFromTaskList(repository, taskId);
        if (task != null) {
            return TasksUiInternal.openKnownTaskInEditor(task, taskId, listener);
        }
        AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(repository.getConnectorKind());
        if (connectorUi != null) {
            try {
                return TasksUiInternal.openRepositoryTask(connectorUi.getConnectorKind(), repository.getRepositoryUrl(), taskId, listener);
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Internal error while opening repository task", (Throwable)e));
            }
        }
        return false;
    }

    public static boolean openTaskByIdOrKey(TaskRepository repository, String taskIdOrKey, TaskOpenListener listener) {
        AbstractTask task = TasksUiInternal.getTaskFromTaskList(repository, taskIdOrKey);
        if (task != null) {
            return TasksUiInternal.openKnownTaskInEditor(task, taskIdOrKey, listener);
        }
        AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(repository.getConnectorKind());
        if (connectorUi != null) {
            try {
                return TasksUiInternal.openRepositoryTaskByIdOrKey(connectorUi.getConnectorKind(), repository.getRepositoryUrl(), taskIdOrKey, listener);
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Internal error while opening repository task", (Throwable)e));
            }
        }
        return false;
    }

    private static boolean openKnownTaskInEditor(AbstractTask task, String taskIdOrKey, TaskOpenListener listener) {
        TaskOpenEvent event = TasksUiInternal.openTask((ITask)task, taskIdOrKey);
        if (listener != null && event != null) {
            listener.taskOpened(event);
        }
        return event != null;
    }

    private static AbstractTask getTaskFromTaskList(TaskRepository repository, String taskIdOrKey) {
        Assert.isNotNull((Object)repository);
        Assert.isNotNull((Object)taskIdOrKey);
        AbstractTask task = (AbstractTask)TasksUiInternal.getTaskList().getTask(repository.getRepositoryUrl(), taskIdOrKey);
        if (task == null) {
            task = TasksUiPlugin.getTaskList().getTaskByKey(repository.getRepositoryUrl(), taskIdOrKey);
        }
        return task;
    }

    public static TaskOpenEvent openTask(ITask task, String taskId) {
        Assert.isNotNull((Object)task);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            boolean openWithBrowser;
            TaskRepository taskRepository = TasksUi.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
            boolean bl = openWithBrowser = !TasksUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.reporting.open.editor");
            if (openWithBrowser && !(task instanceof LocalTask)) {
                TasksUiUtil.openWithBrowser(taskRepository, (IRepositoryElement)task);
                return new TaskOpenEvent(taskRepository, task, taskId, null, true);
            }
            IEditorInput editorInput = TasksUiInternal.getTaskEditorInput(taskRepository, task);
            IEditorPart editor = TasksUiInternal.refreshEditorContentsIfOpen(task, editorInput);
            if (editor != null) {
                TasksUiInternal.synchronizeTask(taskRepository, task);
                return new TaskOpenEvent(taskRepository, task, taskId, editor, false);
            }
            IWorkbenchPage page = window.getActivePage();
            editor = TasksUiUtil.openEditor(editorInput, TasksUiInternal.getTaskEditorId(task), page);
            if (editor != null) {
                TasksUiInternal.synchronizeTask(taskRepository, task);
                return new TaskOpenEvent(taskRepository, task, taskId, editor, false);
            }
        } else {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Unable to open editor for \"" + task.getSummary() + "\": no active workbench window"));
        }
        return null;
    }

    private static IEditorInput getTaskEditorInput(TaskRepository repository, ITask task) {
        Assert.isNotNull((Object)task);
        Assert.isNotNull((Object)repository);
        AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(task.getConnectorKind());
        IEditorInput editorInput = connectorUi.getTaskEditorInput(repository, task);
        if (editorInput != null) {
            return editorInput;
        }
        return new TaskEditorInput(repository, task);
    }

    private static String getTaskEditorId(ITask task) {
        ITask repositoryTask;
        AbstractRepositoryConnectorUi repositoryUi;
        String customTaskEditorId;
        String taskEditorId = "org.eclipse.mylyn.tasks.ui.editors.task";
        if (task != null && (customTaskEditorId = (repositoryUi = TasksUiPlugin.getConnectorUi((repositoryTask = task).getConnectorKind())).getTaskEditorId(repositoryTask)) != null) {
            taskEditorId = customTaskEditorId;
        }
        return taskEditorId;
    }

    private static IEditorPart refreshEditorContentsIfOpen(ITask task, IEditorInput editorInput) {
        if (task != null && (task.getSynchronizationState() == ITask.SynchronizationState.INCOMING || task.getSynchronizationState() == ITask.SynchronizationState.CONFLICT)) {
            for (TaskEditor editor : TasksUiInternal.getActiveRepositoryTaskEditors()) {
                if (!editor.getEditorInput().equals(editorInput)) continue;
                editor.refreshPages();
                editor.getEditorSite().getPage().activate((IWorkbenchPart)editor);
                return editor;
            }
        }
        return null;
    }

    private static void synchronizeTask(TaskRepository taskRepository, ITask task) {
        if (task instanceof LocalTask) {
            return;
        }
        AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(task.getConnectorKind());
        if (connector.canSynchronizeTask(taskRepository, task)) {
            TasksUiInternal.synchronizeTaskInBackground(connector, task);
        }
    }

    public static boolean openRepositoryTask(String connectorKind, String repositoryUrl, String id) {
        return TasksUiInternal.openRepositoryTask(connectorKind, repositoryUrl, id, null);
    }

    public static boolean openRepositoryTask(String connectorKind, String repositoryUrl, String id, TaskOpenListener listener) {
        return TasksUiInternal.openRepositoryTask(connectorKind, repositoryUrl, id, listener, 0L);
    }

    public static boolean openRepositoryTask(String connectorKind, String repositoryUrl, String id, TaskOpenListener listener, long timestamp) {
        String taskUrl = TasksUiInternal.getTaskUrl(connectorKind, repositoryUrl, id);
        if (taskUrl == null) {
            return false;
        }
        IWorkbenchWindow window = TasksUiInternal.getWorkbenchWindow();
        if (window == null) {
            return false;
        }
        IWorkbenchPage page = window.getActivePage();
        OpenRepositoryTaskJob job = new OpenRepositoryTaskJob(connectorKind, repositoryUrl, id, taskUrl, timestamp, page);
        job.setListener(listener);
        job.schedule();
        return true;
    }

    public static boolean openRepositoryTaskByIdOrKey(String connectorKind, String repositoryUrl, String idOrKey, TaskOpenListener listener) {
        String taskUrl = TasksUiInternal.getTaskUrl(connectorKind, repositoryUrl, idOrKey);
        if (taskUrl == null) {
            return false;
        }
        IWorkbenchWindow window = TasksUiInternal.getWorkbenchWindow();
        if (window == null) {
            return false;
        }
        IWorkbenchPage page = window.getActivePage();
        OpenRepositoryTaskJob job = new OpenRepositoryTaskJob(page, connectorKind, repositoryUrl, idOrKey, taskUrl);
        job.setListener(listener);
        job.schedule();
        return true;
    }

    private static IWorkbenchWindow getWorkbenchWindow() {
        IWorkbenchWindow[] windows;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null && (windows = PlatformUI.getWorkbench().getWorkbenchWindows()) != null && windows.length > 0) {
            window = windows[0];
        }
        return window;
    }

    private static String getTaskUrl(String connectorKind, String repositoryUrl, String idOrKey) {
        IRepositoryManager repositoryManager = TasksUi.getRepositoryManager();
        AbstractRepositoryConnector connector = repositoryManager.getRepositoryConnector(connectorKind);
        return connector.getTaskUrl(repositoryUrl, idOrKey);
    }

    public static boolean openTaskInBackground(ITask task, boolean bringToTop) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            boolean opened;
            IEditorPart activeEditor = null;
            IWorkbenchPart activePart = null;
            IWorkbenchPage activePage = window.getActivePage();
            if (activePage != null) {
                activeEditor = activePage.getActiveEditor();
                activePart = activePage.getActivePart();
            }
            if ((opened = TasksUiUtil.openTask(task)) && activePage != null) {
                if (!bringToTop && activeEditor != null) {
                    activePage.bringToTop((IWorkbenchPart)activeEditor);
                }
                if (activePart != null) {
                    activePage.activate(activePart);
                }
            }
            return opened;
        }
        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Unable to open editor for \"" + task.getSummary() + "\": no active workbench window"));
        return false;
    }

    @Deprecated
    public static String escapeLabelText(String text) {
        return CommonUiUtil.toLabel((String)text);
    }

    public static void preservingSelection(final TreeViewer viewer, Runnable runnable) {
        final ISelection selection = viewer.getSelection();
        runnable.run();
        if (selection != null) {
            ISelection newSelection = viewer.getSelection();
            if ((newSelection == null || newSelection.isEmpty()) && selection != null && !selection.isEmpty()) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        viewer.setSelection(selection, true);
                    }
                });
            } else if (newSelection instanceof ITreeSelection && !newSelection.isEmpty()) {
                viewer.reveal(((ITreeSelection)newSelection).getFirstElement());
            }
        }
    }

    public static String getFormattedDuration(long duration, boolean includeSeconds) {
        long seconds = duration / 1000L;
        long minutes = 0L;
        long hours = 0L;
        long MIN = 60L;
        long HOUR = 3600L;
        Object formatted = "";
        Object hour = "";
        Object min = "";
        Object sec = "";
        if (seconds >= 3600L) {
            hours = seconds / 3600L;
            if (hours == 1L) {
                hour = hours + Messages.TasksUiInternal__hour_;
            } else if (hours > 1L) {
                hour = hours + Messages.TasksUiInternal__hours_;
            }
            minutes = (seconds -= hours * 3600L) / 60L;
            if (minutes == 1L) {
                min = minutes + Messages.TasksUiInternal__minute_;
            } else if (minutes != 1L) {
                min = minutes + Messages.TasksUiInternal__minutes_;
            }
            if ((seconds -= minutes * 60L) == 1L) {
                sec = seconds + Messages.TasksUiInternal__second;
            } else if (seconds > 1L) {
                sec = seconds + Messages.TasksUiInternal__seconds;
            }
            formatted = (String)formatted + (String)hour + (String)min;
            if (includeSeconds) {
                formatted = (String)formatted + (String)sec;
            }
        } else if (seconds >= 60L) {
            minutes = seconds / 60L;
            if (minutes == 1L) {
                min = minutes + Messages.TasksUiInternal__minute_;
            } else if (minutes != 1L) {
                min = minutes + Messages.TasksUiInternal__minutes_;
            }
            if ((seconds -= minutes * 60L) == 1L) {
                sec = seconds + Messages.TasksUiInternal__second;
            } else if (seconds > 1L) {
                sec = seconds + Messages.TasksUiInternal__seconds;
            }
            formatted = (String)formatted + (String)min;
            if (includeSeconds) {
                formatted = (String)formatted + (String)sec;
            }
        } else {
            if (seconds == 1L) {
                sec = seconds + Messages.TasksUiInternal__second;
            } else if (seconds > 1L) {
                sec = seconds + Messages.TasksUiInternal__seconds;
            }
            if (includeSeconds) {
                formatted = (String)formatted + (String)sec;
            }
        }
        return formatted;
    }

    public static AbstractTask getTask(String repositoryUrl, String taskId, String fullUrl) {
        AbstractTask task = null;
        if (repositoryUrl != null && taskId != null) {
            task = (AbstractTask)TasksUiInternal.getTaskList().getTask(repositoryUrl, taskId);
        }
        if (task == null && fullUrl != null) {
            task = TasksUiInternal.getTaskByUrl(fullUrl);
        }
        if (task == null && repositoryUrl != null && taskId != null) {
            task = TasksUiPlugin.getTaskList().getTaskByKey(repositoryUrl, taskId);
        }
        return task;
    }

    public static AbstractTask getTaskByUrl(String taskUrl) {
        return TasksCoreUtil.getTaskByUrl((TaskList)TasksUiPlugin.getTaskList(), (IRepositoryManager)TasksUi.getRepositoryManager(), (String)taskUrl);
    }

    public static boolean isTaskUrl(String taskUrl) {
        Assert.isNotNull((Object)taskUrl);
        List repositories = TasksUiPlugin.getRepositoryManager().getAllRepositories();
        for (TaskRepository repository : repositories) {
            if (!taskUrl.startsWith(repository.getUrl())) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static String cleanTextForAction(String label) {
        return CommonUiUtil.toMenuLabel((String)label);
    }

    public static void executeCommand(IServiceLocator serviceLocator, String commandId, String title, Object object, Event event) throws NotEnabledException {
        block11: {
            IHandlerService service = (IHandlerService)serviceLocator.getService(IHandlerService.class);
            if (service != null) {
                ICommandService commandService = (ICommandService)serviceLocator.getService(ICommandService.class);
                if (commandService != null) {
                    Command command = commandService.getCommand(commandId);
                    if (command != null) {
                        try {
                            if (object != null) {
                                IEvaluationContext context = service.createContextSnapshot(false);
                                context.addVariable("selection", (Object)new StructuredSelection(object));
                                service.executeCommandInContext(new ParameterizedCommand(command, null), event, context);
                                break block11;
                            }
                            service.executeCommand(commandId, event);
                        }
                        catch (ExecutionException e) {
                            TasksUiInternal.displayStatus(title, (IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Command execution failed", (Throwable)e));
                        }
                        catch (NotDefinedException e) {
                            TasksUiInternal.displayStatus(title, (IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", NLS.bind((String)"The command with the id ''{0}'' is not defined.", (Object)commandId), (Throwable)e));
                        }
                        catch (NotHandledException e) {
                            TasksUiInternal.displayStatus(title, (IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", NLS.bind((String)"The command with the id ''{0}'' is not bound.", (Object)commandId), (Throwable)e));
                        }
                    } else {
                        TasksUiInternal.displayStatus(title, (IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", NLS.bind((String)"The command with the id ''{0}'' does not exist.", (Object)commandId)));
                    }
                } else {
                    TasksUiInternal.displayStatus(title, (IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", NLS.bind((String)"Command service is not available to execute command with the id ''{0}''.", (Object)commandId), (Throwable)new Exception()));
                }
            } else {
                TasksUiInternal.displayStatus(title, (IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", NLS.bind((String)"Handler service is not available to execute command with the id ''{0}''.", (Object)commandId), (Throwable)new Exception()));
            }
        }
    }

    public static void activateTaskThroughCommand(ITask task) {
        try {
            TasksUiInternal.executeCommand((IServiceLocator)PlatformUI.getWorkbench(), "org.eclipse.mylyn.tasks.ui.command.activateSelectedTask", Messages.TasksUiInternal_Activate_Task, task, null);
        }
        catch (NotEnabledException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", NLS.bind((String)"Failed to activate task ''{0}''.", (Object)task.getSummary()), (Throwable)e));
        }
    }

    public static long getActiveTime(ITask task) {
        if (TasksUiInternal.isActivityTrackingEnabled()) {
            return TasksUiPlugin.getTaskActivityManager().getElapsedTime(task);
        }
        return 0L;
    }

    public static String getTaskPrefix(String connectorKind) {
        AbstractRepositoryConnector connector = TasksUiPlugin.getConnector(connectorKind);
        if (connector != null) {
            String prefix = connector.getTaskIdPrefix();
            return prefix.length() > 1 ? prefix + " " : prefix;
        }
        return "";
    }

    public static void displayFrameworkError(String message) {
        RuntimeException exception = new RuntimeException(message);
        if (!CoreUtil.TEST_MODE) {
            StatusAdapter status = new StatusAdapter((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", message, (Throwable)exception));
            status.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)"Framework Error");
            StatusManager.getManager().handle(status, 7);
        }
        throw exception;
    }

    public static String getAuthenticatedUrl(TaskRepository repository, IRepositoryElement element) {
        Assert.isNotNull((Object)repository);
        Assert.isNotNull((Object)element);
        IRepositoryManager repositoryManager = TasksUi.getRepositoryManager();
        AbstractRepositoryConnector connector = repositoryManager.getRepositoryConnector(repository.getConnectorKind());
        if (connector != null) {
            URL authenticatedUrl = connector.getAuthenticatedUrl(repository, element);
            if (authenticatedUrl != null) {
                return authenticatedUrl.toString();
            }
            String url = element.getUrl();
            if (TasksUiInternal.isValidUrl(url)) {
                return url;
            }
        }
        return null;
    }

    public static TaskRepository getRepository(IRepositoryElement element) {
        IRepositoryManager repositoryManager = TasksUi.getRepositoryManager();
        TaskRepository repository = null;
        if (element instanceof ITask) {
            repository = repositoryManager.getRepository(((ITask)element).getConnectorKind(), ((ITask)element).getRepositoryUrl());
        } else if (element instanceof IRepositoryQuery) {
            repository = repositoryManager.getRepository(((IRepositoryQuery)element).getConnectorKind(), ((IRepositoryQuery)element).getRepositoryUrl());
        }
        return repository;
    }

    public static List<ITask> getTasksFromSelection(ISelection selection) {
        Assert.isNotNull((Object)selection);
        if (selection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ITask> tasks = new ArrayList<ITask>();
        if (selection instanceof IStructuredSelection) {
            for (Object element : ((IStructuredSelection)selection).toList()) {
                ITask task = null;
                if (element instanceof ITask) {
                    task = (ITask)element;
                } else if (element instanceof IAdaptable) {
                    IAdaptable adaptable = (IAdaptable)element;
                    task = (ITask)adaptable.getAdapter(ITask.class);
                }
                if (task == null) continue;
                tasks.add(task);
            }
        }
        return tasks;
    }

    public static boolean shouldShowIncoming(ITask task) {
        ITask.SynchronizationState state = task.getSynchronizationState();
        return state == ITask.SynchronizationState.INCOMING && Boolean.valueOf(task.getAttribute("task.common.suppress.incoming")) == false || state == ITask.SynchronizationState.INCOMING_NEW || state == ITask.SynchronizationState.CONFLICT;
    }

    public static TaskData computeTaskData(TaskData taskData, TaskHistory history, String revisionId, IProgressMonitor monitor) throws CoreException {
        TaskData newTaskData = TaskDataState.createCopy((TaskData)taskData);
        List revisions = history.getRevisions();
        Collections.reverse(revisions);
        TaskRevision lastRevision = null;
        for (TaskRevision revision : revisions) {
            for (TaskRevision.Change change : revision.getChanges()) {
                TaskAttribute attribute = newTaskData.getRoot().getAttribute(change.getAttributeId());
                if (attribute == null) continue;
                attribute.setValue(change.getRemoved());
            }
            if (!revisionId.equals(revision.getId())) continue;
            lastRevision = revision;
            break;
        }
        if (lastRevision != null && lastRevision.getDate() != null) {
            ArrayList attributes = new ArrayList(newTaskData.getRoot().getAttributes().values());
            for (TaskAttribute attribute : attributes) {
                TaskCommentMapper mapper;
                if ("comment".equals(attribute.getMetaData().getType())) {
                    mapper = TaskCommentMapper.createFrom((TaskAttribute)attribute);
                    if (mapper.getCreationDate() == null || !mapper.getCreationDate().after(lastRevision.getDate())) continue;
                    newTaskData.getRoot().removeAttribute(attribute.getId());
                    continue;
                }
                if (!"attachment".equals(attribute.getMetaData().getType()) || (mapper = TaskAttachmentMapper.createFrom((TaskAttribute)attribute)).getCreationDate() == null || !mapper.getCreationDate().after(lastRevision.getDate())) continue;
                newTaskData.getRoot().removeAttribute(attribute.getId());
            }
        }
        return newTaskData;
    }

    public static boolean canGetTaskHistory(ITask task) {
        TaskRepository repository = TasksUi.getRepositoryManager().getRepository(task.getConnectorKind(), task.getRepositoryUrl());
        AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(repository.getConnectorKind());
        return connector.canGetTaskHistory(repository, task);
    }

    public static Account getAccount(TaskAttribute attribute) {
        Account account;
        if ("person".equals(attribute.getMetaData().getType())) {
            IRepositoryPerson person = attribute.getTaskData().getAttributeMapper().getRepositoryPerson(attribute);
            account = Account.id((String)person.getPersonId()).name(person.getName());
        } else {
            account = Account.id((String)attribute.getValue());
        }
        TaskRepository repository = attribute.getTaskData().getAttributeMapper().getTaskRepository();
        return account.kind(repository.getConnectorKind()).url(repository.getRepositoryUrl());
    }

    public static boolean isActivityTrackingEnabled() {
        return TasksUiPlugin.getTaskActivityMonitor().isEnabled() && MonitorUiPlugin.getDefault().isActivityTrackingEnabled();
    }

    public static TaskDropHandler getTaskDropHandler() {
        return taskDropHandler;
    }

    public static ImageDescriptor getIconFromStatusOfQuery(RepositoryQuery query) {
        boolean showError = false;
        Throwable exception = query.getStatus().getException();
        showError = query.getLastSynchronizedTimeStamp().equals("<never>") && (5 == query.getStatus().getCode() && exception != null && exception instanceof SocketTimeoutException || 11 == query.getStatus().getCode() && query.getStatus().getMessage().equals("Http error: Internal Server Error"));
        ImageDescriptor image = showError ? CommonImages.OVERLAY_SYNC_ERROR : CommonImages.OVERLAY_SYNC_WARNING;
        return image;
    }

    public static synchronized IUndoContext getUndoContext() {
        if (undoContext == null) {
            undoContext = new ObjectUndoContext(new Object(), "Tasks Context");
        }
        return undoContext;
    }

    public static void deleteTask(ITask task) {
        TasksUiInternal.getTaskList().deleteTask(task);
        TasksUiPlugin.getContextStore().deleteContext(task);
        try {
            TasksUiPlugin.getTaskDataManager().deleteTaskData(task);
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Failed to delete task data", (Throwable)e));
        }
    }
}

