/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;

public class TracingOptionsManager {
    private Map<String, String> template;

    public Map<String, String> getTemplateTable(String pluginId) {
        Map<String, String> tracingTemplate = this.getTracingTemplate();
        HashMap<String, String> defaults = new HashMap<String, String>();
        tracingTemplate.forEach((key, value) -> {
            if (this.belongsTo((String)key, pluginId)) {
                defaults.put((String)key, (String)value);
            }
        });
        return defaults;
    }

    private boolean belongsTo(String option, String pluginId) {
        String firstSegment = IPath.fromOSString((String)option).segment(0);
        return pluginId.equalsIgnoreCase(firstSegment);
    }

    public Map<String, String> getTracingOptions(Map<String, String> storedOptions) {
        Map<String, String> defaults = this.getTracingTemplateCopy();
        if (storedOptions != null) {
            storedOptions.forEach((key, value) -> {
                if (defaults.containsKey(key)) {
                    defaults.put((String)key, (String)value);
                }
            });
        }
        return defaults;
    }

    public Map<String, String> getTracingTemplateCopy() {
        return new HashMap<String, String>(this.getTracingTemplate());
    }

    private synchronized Map<String, String> getTracingTemplate() {
        if (this.template == null) {
            HashMap<String, String> temp = new HashMap<String, String>();
            IPluginModelBase[] models = PluginRegistry.getAllModels();
            Arrays.stream(models).map(TracingOptionsManager::getOptions).filter(Objects::nonNull).forEach(p -> {
                Properties entries = p;
                temp.putAll(entries);
            });
            this.template = temp;
        }
        return this.template;
    }

    /*
     * Loose catch block
     */
    public static boolean isTraceable(IPluginModelBase model) {
        block23: {
            String location = model.getInstallLocation();
            if (location == null) {
                return false;
            }
            File pluginLocation = new File(location);
            if (pluginLocation.isDirectory()) {
                return new File(pluginLocation, ".options").exists();
            }
            try {
                Throwable throwable = null;
                Object var4_5 = null;
                try (ZipFile jarFile = new ZipFile(pluginLocation, 1);){
                    boolean bl;
                    InputStream stream;
                    Throwable throwable2;
                    block24: {
                        ZipEntry manifestEntry = jarFile.getEntry(".options");
                        if (manifestEntry == null) break block23;
                        throwable2 = null;
                        Object var8_11 = null;
                        stream = jarFile.getInputStream(manifestEntry);
                        bl = stream != null;
                        if (stream == null) break block24;
                        stream.close();
                    }
                    return bl;
                    {
                        catch (Throwable throwable3) {
                            try {
                                if (stream != null) {
                                    stream.close();
                                }
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (throwable2 == null) {
                                    throwable2 = throwable4;
                                } else if (throwable2 != throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                throw throwable2;
                            }
                        }
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                    } else if (throwable != throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    public synchronized void reset() {
        this.template = null;
    }

    private void saveOptions(Path file, Map<String, String> entries) {
        Properties properties = new Properties();
        properties.putAll(entries);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (OutputStream stream = Files.newOutputStream(file, new OpenOption[0]);){
                properties.store(stream, "Master Tracing Options");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            PDECore.logException(e);
        }
    }

    public void save(Path file, Map<String, String> map, Set<String> selected) {
        Map<String, String> properties = this.getTracingOptions(map);
        properties.keySet().removeIf(key -> {
            IPath path = IPath.fromOSString((String)key);
            return path.segmentCount() < 1 || !selected.contains(path.segment(0));
        });
        this.saveOptions(file, properties);
    }

    public void save(Path file, Map<String, String> map) {
        this.saveOptions(file, this.getTracingOptions(map));
    }

    private static Properties getOptions(IPluginModelBase model) {
        block49: {
            String location = model.getInstallLocation();
            if (location == null) {
                return null;
            }
            try {
                File pluginLocation = new File(location);
                Properties modelOptions = new Properties();
                if (pluginLocation.isDirectory()) {
                    FileInputStream stream;
                    File file = new File(pluginLocation, ".options");
                    if (!file.exists()) break block49;
                    Throwable throwable = null;
                    Object var6_13 = null;
                    try {
                        stream = new FileInputStream(file);
                        try {
                            modelOptions.load(stream);
                        }
                        finally {
                            if (stream != null) {
                                ((InputStream)stream).close();
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    throwable = null;
                    var6_13 = null;
                    try {
                        stream = new FileInputStream(file);
                        try {
                            TracingOptionsManager.loadComments(stream, modelOptions);
                        }
                        finally {
                            if (stream != null) {
                                ((InputStream)stream).close();
                            }
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                    return modelOptions;
                }
                Throwable throwable = null;
                Object var5_11 = null;
                try (ZipFile jarFile = new ZipFile(pluginLocation, 1);){
                    InputStream stream;
                    ZipEntry manifestEntry = jarFile.getEntry(".options");
                    if (manifestEntry == null) break block49;
                    Throwable throwable4 = null;
                    Object var9_22 = null;
                    try {
                        stream = jarFile.getInputStream(manifestEntry);
                        try {
                            modelOptions.load(stream);
                        }
                        finally {
                            if (stream != null) {
                                stream.close();
                            }
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable4 == null) {
                            throwable4 = throwable5;
                        } else if (throwable4 != throwable5) {
                            throwable4.addSuppressed(throwable5);
                        }
                        throw throwable4;
                    }
                    throwable4 = null;
                    var9_22 = null;
                    try {
                        stream = jarFile.getInputStream(manifestEntry);
                        try {
                            TracingOptionsManager.loadComments(stream, modelOptions);
                        }
                        finally {
                            if (stream != null) {
                                stream.close();
                            }
                        }
                    }
                    catch (Throwable throwable6) {
                        if (throwable4 == null) {
                            throwable4 = throwable6;
                        } else if (throwable4 != throwable6) {
                            throwable4.addSuppressed(throwable6);
                        }
                        throw throwable4;
                    }
                    return modelOptions;
                }
                catch (Throwable throwable7) {
                    if (throwable == null) {
                        throwable = throwable7;
                    } else if (throwable != throwable7) {
                        throwable.addSuppressed(throwable7);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                PDECore.logException(e);
            }
        }
        return null;
    }

    private static void loadComments(InputStream stream, Properties modelOptions) throws IOException {
        Object prevComment = "";
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.ISO_8859_1));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                if (line.startsWith("#") || line.trim().isEmpty()) {
                    prevComment = (String)prevComment + "\n" + line.trim();
                    continue;
                }
                if (((String)prevComment).isBlank()) continue;
                int eq = line.indexOf(61);
                if (eq >= 0) {
                    String key = line.substring(0, eq).trim();
                    modelOptions.put("#" + key, ((String)prevComment).strip());
                }
                prevComment = "";
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

