/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.text;

import java.util.Iterator;
import java.util.ResourceBundle;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.texteditor.SelectMarkerRulerAction;

public class PDESelectAnnotationRulerAction
extends SelectMarkerRulerAction {
    private boolean fIsEditable;
    private final ITextEditor fTextEditor;
    private Position fPosition;
    private final ResourceBundle fBundle;
    private final String fPrefix;

    public PDESelectAnnotationRulerAction(ResourceBundle bundle, String prefix, ITextEditor editor, IVerticalRulerInfo ruler) {
        super(bundle, prefix, editor, ruler);
        this.fTextEditor = editor;
        this.fBundle = bundle;
        this.fPrefix = prefix;
    }

    public void run() {
        this.runWithEvent(null);
    }

    public void runWithEvent(Event event) {
        if (this.fIsEditable) {
            ITextOperationTarget operation = (ITextOperationTarget)this.fTextEditor.getAdapter(ITextOperationTarget.class);
            if (operation != null && operation.canDoOperation(22)) {
                this.fTextEditor.selectAndReveal(this.fPosition.getOffset(), this.fPosition.getLength());
                operation.doOperation(22);
            }
            return;
        }
        super.run();
    }

    public void update() {
        this.checkReadOnly();
        if (this.fIsEditable) {
            this.initialize(this.fBundle, this.fPrefix + "QuickFix.");
        }
        super.update();
    }

    private void checkReadOnly() {
        this.fPosition = null;
        this.fIsEditable = false;
        AbstractMarkerAnnotationModel model = this.getAnnotationModel();
        IAnnotationAccessExtension annotationAccess = this.getAnnotationAccessExtension();
        IDocument document = this.getDocument();
        if (model == null) {
            return;
        }
        Iterator iter = model.getAnnotationIterator();
        int layer = Integer.MIN_VALUE;
        while (iter.hasNext()) {
            boolean isReadOnly;
            Position position;
            int annotationLayer;
            Annotation annotation = (Annotation)iter.next();
            if (annotation.isMarkedDeleted() || (annotationLayer = annotationAccess.getLayer(annotation)) < layer || !this.includesRulerLine(position = model.getPosition(annotation), document)) continue;
            boolean bl = isReadOnly = this.fTextEditor instanceof ITextEditorExtension && ((ITextEditorExtension)this.fTextEditor).isEditorInputReadOnly();
            if (isReadOnly) continue;
            this.fPosition = position;
            this.fIsEditable = true;
            layer = annotationLayer;
        }
    }
}

