/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.ctf.core.event.metadata.DeclarationScope;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.VariantDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.parser.CTFParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.AbstractScopedCommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonFieldClassAliasMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonStructureFieldMemberMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.BlobDeclarationParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypeAliasAliasParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypeAliasTargetParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.enumeration.EnumParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.integer.IntegerDeclarationParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.string.StringDeclarationParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.variant.VariantParser;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;

public final class TypeAliasParser
extends AbstractScopedCommonTreeParser {
    private static final String SIGNED = "signed";
    public static final TypeAliasParser INSTANCE = new TypeAliasParser();

    private TypeAliasParser() {
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IDeclaration parse(ICTFMetadataNode typealias, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        if (!(param instanceof Param)) {
            throw new IllegalArgumentException("Param must be a " + Param.class.getCanonicalName());
        }
        DeclarationScope scope = ((Param)param).fDeclarationScope;
        List<ICTFMetadataNode> children = typealias.getChildren();
        ICTFMetadataNode target = null;
        ICTFMetadataNode alias = null;
        IDeclaration targetDeclaration = null;
        CTFTrace trace = ((Param)param).fTrace;
        String aliasString = null;
        if (typealias instanceof JsonStructureFieldMemberMetadataNode) {
            JsonPrimitive jPrimitive;
            JsonStructureFieldMemberMetadataNode member = (JsonStructureFieldMemberMetadataNode)typealias;
            String type = typealias.getType();
            JsonObject fieldClass = null;
            if (member.getFieldClass().isJsonObject()) {
                fieldClass = member.getFieldClass().getAsJsonObject();
                aliasString = member.getName();
                type = member.getType();
            } else if (member.getFieldClass().isJsonPrimitive() && (jPrimitive = member.getFieldClass().getAsJsonPrimitive()).isString()) {
                void var15_19;
                String fieldClassAlias = jPrimitive.getAsString();
                JsonStructureFieldMemberMetadataNode jsonStructureFieldMemberMetadataNode = member;
                while (var15_19.getParent() != null) {
                    ICTFMetadataNode iCTFMetadataNode = var15_19.getParent();
                }
                for (ICTFMetadataNode node : var15_19.getChildren()) {
                    JsonFieldClassAliasMetadataNode aliasMetadataNode;
                    if (!(node instanceof JsonFieldClassAliasMetadataNode) || !(aliasMetadataNode = (JsonFieldClassAliasMetadataNode)node).getName().equals(fieldClassAlias)) continue;
                    fieldClass = aliasMetadataNode.getFieldClass();
                    aliasString = aliasMetadataNode.getName();
                    JsonElement typeMember = fieldClass.get("type");
                    if (typeMember == null || !typeMember.isJsonPrimitive()) break;
                    type = typeMember.getAsString();
                    break;
                }
                if (fieldClass == null) {
                    throw new ParseException("no previously occurring field class alias named '" + fieldClassAlias + "'");
                }
            }
            if (fieldClass == null) throw new ParseException("field-class property is not a JSON object or JSON string");
            if ("fixed-length-unsigned-integer".equals(type)) {
                fieldClass.addProperty(SIGNED, Boolean.valueOf(false));
                targetDeclaration = IntegerDeclarationParser.INSTANCE.parse(typealias, new IntegerDeclarationParser.Param(trace));
            } else if ("fixed-length-signed-integer".equals(type)) {
                fieldClass.addProperty(SIGNED, Boolean.valueOf(true));
                targetDeclaration = IntegerDeclarationParser.INSTANCE.parse(typealias, new IntegerDeclarationParser.Param(trace));
            } else if ("static-length-blob".equals(type)) {
                targetDeclaration = BlobDeclarationParser.INSTANCE.parse(typealias, null);
            } else if ("null-terminated-string".equals(type)) {
                targetDeclaration = StringDeclarationParser.INSTANCE.parse(typealias, null);
            } else if ("variant".equals(type)) {
                targetDeclaration = VariantParser.INSTANCE.parse(typealias, new VariantParser.Param(trace, scope));
            } else {
                if (!"fixed-length-unsigned-enumeration".equals(type)) throw new ParseException("Invalid field class: " + type);
                targetDeclaration = EnumParser.INSTANCE.parse(typealias, new EnumParser.Param(trace, scope));
            }
        } else {
            for (ICTFMetadataNode child : children) {
                String type = child.getType();
                if (CTFParser.tokenNames[113].equals(type)) {
                    target = child;
                    continue;
                }
                if (!CTFParser.tokenNames[112].equals(type)) throw TsdlUtils.childTypeError(child);
                alias = child;
            }
            targetDeclaration = TypeAliasTargetParser.INSTANCE.parse(target, new TypeAliasTargetParser.Param(trace, scope));
            if (targetDeclaration instanceof VariantDeclaration && ((VariantDeclaration)targetDeclaration).isTagged()) {
                throw new ParseException("Typealias of untagged variant is not permitted");
            }
            aliasString = TypeAliasAliasParser.INSTANCE.parse(alias, null);
        }
        scope.registerType(aliasString, targetDeclaration);
        return targetDeclaration;
    }

    @NonNullByDefault
    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final DeclarationScope fDeclarationScope;
        private final CTFTrace fTrace;

        public Param(CTFTrace trace, DeclarationScope scope) {
            this.fTrace = trace;
            this.fDeclarationScope = scope;
        }
    }
}

