/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.viatra.query.tooling.ui.queryregistry;

import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeInput;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreePackage;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.xbase.lib.Pure;

@FinalFieldsConstructor
@SuppressWarnings("all")
public class QueryRegistryTreeSource {
  @Accessors(AccessorType.PUBLIC_GETTER)
  private final QueryRegistryTreeInput parent;
  
  @Accessors(AccessorType.PUBLIC_GETTER)
  private final String sourceIdentifier;
  
  @Accessors(AccessorType.PUBLIC_GETTER)
  private final Map<String, QueryRegistryTreePackage> packages = Maps.<String, QueryRegistryTreePackage>newTreeMap();
  
  @Pure
  public QueryRegistryTreeInput getParent() {
    return this.parent;
  }
  
  @Pure
  public String getSourceIdentifier() {
    return this.sourceIdentifier;
  }
  
  @Pure
  public Map<String, QueryRegistryTreePackage> getPackages() {
    return this.packages;
  }
  
  public QueryRegistryTreeSource(final QueryRegistryTreeInput parent, final String sourceIdentifier) {
    super();
    this.parent = parent;
    this.sourceIdentifier = sourceIdentifier;
  }
}
