/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.jdt.core;

import java.io.Reader;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.wb.internal.core.utils.StringUtilities;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.jdt.core.JavadocContentAccess;

public class JavaDocUtils {
    private JavaDocUtils() {
    }

    public static String getTooltip(IJavaProject project, IMethodBinding methodBinding) throws Exception {
        String declaringTypeName = AstNodeUtils.getFullyQualifiedName(methodBinding.getDeclaringClass(), false);
        String signature = AstNodeUtils.getMethodSignature(methodBinding);
        return JavaDocUtils.getTooltip(project, declaringTypeName, signature);
    }

    public static String getTooltip(IJavaProject project, String declaringTypeName, String signature) throws Exception {
        IMethod method = CodeUtils.findMethod(project, declaringTypeName, signature);
        return JavaDocUtils.getTooltip((IMember)method);
    }

    public static String getTooltip(IMember method) throws Exception {
        List<String> javaDocLines = JavaDocUtils.getJavaDocLines(method, true);
        if (javaDocLines == null) {
            return null;
        }
        String tooltip = StringUtils.join(javaDocLines.iterator(), (String)" ");
        tooltip = StringUtilities.normalizeWhitespaces((String)tooltip);
        tooltip = StringUtils.replace((String)tooltip, (String)"{@inheritDoc}", (String)"");
        tooltip = StringUtils.substringBefore((String)tooltip, (String)"@param");
        tooltip = StringUtils.substringBefore((String)tooltip, (String)"@since");
        tooltip = StringUtils.substringBefore((String)tooltip, (String)"@see");
        tooltip = StringUtils.substringBefore((String)tooltip, (String)"@author");
        tooltip = JavaDocUtils.getTooltip_useShortTypeNames(tooltip);
        tooltip = tooltip.trim();
        return tooltip;
    }

    private static String getTooltip_useShortTypeNames(String tooltip) {
        int endIndex;
        int index = 0;
        while ((index = ((String)tooltip).indexOf("{@link", index)) != -1 && (endIndex = ((String)tooltip).indexOf("}", index)) != -1) {
            String link = ((String)tooltip).substring(index += "{@link".length(), endIndex).trim();
            int lastDot = -1;
            int i = 0;
            while (i < link.length()) {
                char c = link.charAt(i);
                if (c == '.') {
                    lastDot = i;
                } else if ((c < 'a' || c > 'z') && (c < 'A' || c > 'Z')) break;
                ++i;
            }
            if (lastDot != -1) {
                link = link.substring(lastDot + 1);
            }
            tooltip = ((String)tooltip).substring(0, index) + " " + link + ((String)tooltip).substring(endIndex);
            index = endIndex;
        }
        return tooltip;
    }

    public static List<String> getJavaDocLines(IMember member, boolean allowInherited) throws Exception {
        Reader reader = JavadocContentAccess.getContentReader(member, allowInherited);
        if (reader == null) {
            return null;
        }
        return IOUtils.readLines((Reader)reader);
    }
}

