/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileProvider;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;
import org.eclipse.datatools.connectivity.internal.InternalProfileManager;
import org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepository;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.refactoring.ConnectionProfileCopyChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.CopyArguments;
import org.eclipse.ltk.core.refactoring.participants.CopyParticipant;
import org.eclipse.ltk.core.refactoring.participants.CopyProcessor;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.osgi.util.TextProcessor;

public class ConnectionProfileCopyProcessor
extends CopyProcessor {
    public static final String PROCESSOR_ID = "org.eclipse.datatools.connectivity.ui.copyProcessor";
    private IConnectionProfile[] mProfiles;
    private List mProfilesToCopy;
    private CopyArguments mArguments;

    public ConnectionProfileCopyProcessor(IConnectionProfile[] profiles, Object destination) {
        this.mProfiles = profiles;
        this.mProfilesToCopy = new ArrayList();
        this.mArguments = new CopyArguments(destination, new ReorgExecutionLog());
    }

    public Object[] getElements() {
        return this.mProfiles;
    }

    public String getIdentifier() {
        return PROCESSOR_ID;
    }

    public String getProcessorName() {
        return ConnectivityUIPlugin.getDefault().getResourceString("CPDuplicateProcessor.name");
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        this.getTargetRepository();
        return result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        ReorgExecutionLog reorgLog = this.mArguments.getExecutionLog();
        IConnectionProfileRepository repo = this.getTargetRepository();
        int index = 0;
        int count = this.mProfiles.length;
        while (index < count) {
            if (repo == null || !repo.isReadOnly() && repo.supportsProfileType(this.mProfiles[index].getProviderId()) && ((ConnectionProfileProvider)this.mProfiles[index].getProvider()).compatibleWithRepository(repo.getRepositoryProfile())) {
                String newName = this.calculateNewName(this.mProfiles[index], repo);
                reorgLog.setNewName((Object)this.mProfiles[index], TextProcessor.process((String)newName));
                this.mProfilesToCopy.add(this.mProfiles[index]);
            }
            ++index;
        }
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange change = new CompositeChange(new String());
        change.markAsSynthetic();
        Iterator it = this.mProfilesToCopy.iterator();
        while (it.hasNext()) {
            change.add((Change)new ConnectionProfileCopyChange((IConnectionProfile)it.next(), this.mArguments));
        }
        return change;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        ArrayList<CopyParticipant> participants = new ArrayList<CopyParticipant>();
        int index = 0;
        int count = this.mProfiles.length;
        while (index < count) {
            participants.addAll(Arrays.asList(ParticipantManager.loadCopyParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)this.mProfiles[index], (CopyArguments)this.mArguments, (String[])new String[0], (SharableParticipants)sharedParticipants)));
            ++index;
        }
        return participants.toArray(new RefactoringParticipant[participants.size()]);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(ReorgExecutionLog.class)) {
            return this.mArguments.getExecutionLog();
        }
        return super.getAdapter(adapter);
    }

    private String calculateNewName(IConnectionProfile profile, IConnectionProfileRepository repo) {
        String newName = profile.getName();
        String profileName = profile.getName();
        if (repo == null) {
            InternalProfileManager ipm = InternalProfileManager.getInstance();
            int i = 0;
            while (ipm.getProfileByName(newName, false) != null) {
                newName = ConnectivityPlugin.getDefault().getResourceString("duplicate.profile.name", new Object[]{profileName, i});
                ++i;
            }
        } else {
            int i = 0;
            while (repo.getProfileByName(newName) != null) {
                newName = ConnectivityPlugin.getDefault().getResourceString("duplicate.profile.name", new Object[]{profileName, i});
                ++i;
            }
        }
        return newName;
    }

    private IConnectionProfileRepository getTargetRepository() throws CoreException {
        Object destination = this.mArguments.getDestination();
        if (destination instanceof ProfileManager) {
            return null;
        }
        if (destination instanceof IConnectionProfile) {
            IManagedConnection imc = ((IConnectionProfile)destination).getManagedConnection(IConnectionProfileRepository.class.getName());
            if (imc == null) {
                Status status = new Status(4, ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName(), -1, ConnectivityUIPlugin.getDefault().getResourceString("CPCopyChange.error.InvalidTarget"), null);
                throw new CoreException((IStatus)status);
            }
            if (!imc.isConnected() || imc.getConnection() == null || imc.getConnection().getRawConnection() == null) {
                Status status = new Status(4, ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName(), -1, ConnectivityUIPlugin.getDefault().getResourceString("CPCopyChange.error.RepositoryNotConnected", new Object[]{((IConnectionProfile)destination).getName()}), null);
                throw new CoreException((IStatus)status);
            }
            return (IConnectionProfileRepository)imc.getConnection().getRawConnection();
        }
        Status status = new Status(4, ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName(), -1, ConnectivityUIPlugin.getDefault().getResourceString("CPCopyChange.error.InvalidTarget"), null);
        throw new CoreException((IStatus)status);
    }
}

