/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.profiling.core.tree;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.analysis.profiling.core.tree.WeightedTree;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.tree.ITree;
import org.eclipse.tracecompass.internal.provisional.analysis.profiling.core.tree.IWeightedTreeSet;

public class WeightedTreeSet<@NonNull N, E>
implements IWeightedTreeSet<N, E, WeightedTree<N>> {
    private final Set<E> fRootElements = new HashSet();
    private final Multimap<Object, WeightedTree<N>> fTrees = HashMultimap.create();

    @Override
    public Collection<E> getElements() {
        return this.fRootElements;
    }

    @Override
    public Collection<WeightedTree<N>> getTreesFor(Object element) {
        return Objects.requireNonNull(this.fTrees.get(element));
    }

    public void addWeightedTree(E dstGroup, WeightedTree<N> tree) {
        Object root = dstGroup;
        if (dstGroup instanceof ITree) {
            ITree parent = ((ITree)dstGroup).getParent();
            while (parent != null) {
                root = parent;
                parent = parent.getParent();
            }
            this.fRootElements.add(root);
        }
        this.fRootElements.add(root);
        Collection trees = this.fTrees.get(dstGroup);
        for (WeightedTree currentTree : trees) {
            if (!currentTree.getObject().equals(tree.getObject())) continue;
            currentTree.merge(tree);
            return;
        }
        this.fTrees.put(dstGroup, tree);
    }
}

