/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import org.burningwave.core.Memorizer;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.io.FileSystemItem;
import org.burningwave.core.io.IterableZipContainer;

class ZipFile
implements IterableZipContainer,
Memorizer {
    private static final String classId = StaticComponentContainer.Objects.getClassId(ZipFile.class);
    String absolutePath;
    String conventionedAbsolutePath;
    IterableZipContainer parent;
    IterableZipContainer.Entry currentZipEntry;
    Iterator<Entry> entriesIterator;
    Collection<Entry> entries;
    Runnable temporaryFileDeleter;
    java.util.zip.ZipFile originalZipFile;
    Boolean isDestroyed;
    Supplier<ByteBuffer> contentSupplier;

    ZipFile(String absolutePath, ByteBuffer content) {
        this.isDestroyed = Boolean.FALSE;
        this.absolutePath = StaticComponentContainer.Paths.clean(absolutePath);
        this.entries = ConcurrentHashMap.newKeySet();
        this.contentSupplier = () -> content;
        try (java.util.zip.ZipFile zipFile = this.retrieveFile(absolutePath, content);){
            Enumeration<? extends ZipEntry> entriesIterator = zipFile.entries();
            while (entriesIterator.hasMoreElements()) {
                ZipEntry zipEntry = entriesIterator.nextElement();
                this.entries.add(new Entry(this, zipEntry.getName(), () -> this.buildZipEntry(absolutePath, content, zipEntry, true)));
            }
            this.originalZipFile = null;
        }
        catch (IOException exc) {
            StaticComponentContainer.Driver.throwException((Throwable)exc);
        }
        this.entriesIterator = this.entries.iterator();
    }

    private ByteBuffer buildZipEntry(String absolutePath, ByteBuffer content, ZipEntry zipEntry, boolean recursive) {
        ByteBuffer byteBuffer;
        block9: {
            InputStream zipEntryIS = this.retrieveFile(absolutePath, content).getInputStream(zipEntry);
            try {
                byteBuffer = StaticComponentContainer.Streams.toByteBuffer(zipEntryIS);
                if (zipEntryIS == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (zipEntryIS != null) {
                        try {
                            zipEntryIS.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable exc) {
                    if (recursive) {
                        StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, "Exception occurred while building zip entry {} of {}: {}", zipEntry.getName(), absolutePath, exc.getMessage());
                        this.originalZipFile = null;
                        StaticComponentContainer.ManagedLoggerRepository.logInfo(this.getClass()::getName, "Trying recursive call");
                        return this.buildZipEntry(absolutePath, content, zipEntry, false);
                    }
                    StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, "Could not load content of {} of {}", exc, zipEntry.getName(), absolutePath);
                    return null;
                }
            }
            zipEntryIS.close();
        }
        return byteBuffer;
    }

    @Override
    public String getTemporaryFolderPrefix() {
        return classId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private java.util.zip.ZipFile retrieveFile(String absolutePath, ByteBuffer content) {
        java.util.zip.ZipFile originalZipFile = this.originalZipFile;
        if (originalZipFile == null) {
            ZipFile zipFile = this;
            synchronized (zipFile) {
                originalZipFile = this.originalZipFile;
                if (originalZipFile == null) {
                    File temporaryFolder;
                    String fileAbsolutePath;
                    File file = new File(absolutePath);
                    if (!file.exists() && !(file = new File(fileAbsolutePath = StaticComponentContainer.Paths.clean((temporaryFolder = this.getOrCreateTemporaryFolder()).getAbsolutePath()) + "/" + StaticComponentContainer.Paths.toSquaredPath(absolutePath, false))).exists()) {
                        FileSystemItem fileSystemItem = StaticComponentContainer.Streams.store(fileAbsolutePath, content);
                        this.temporaryFileDeleter = () -> {
                            StaticComponentContainer.FileSystemHelper.delete(fileSystemItem.getAbsolutePath());
                            fileSystemItem.destroy();
                        };
                    }
                    try {
                        originalZipFile = this.originalZipFile = new java.util.zip.ZipFile(file);
                    }
                    catch (IOException exc) {
                        StaticComponentContainer.Driver.throwException((Throwable)exc);
                    }
                }
            }
        }
        return originalZipFile;
    }

    private ZipFile(String absolutePath, Collection<Entry> entries, Supplier<ByteBuffer> contentSupplier) {
        this.absolutePath = absolutePath;
        this.entries = entries;
        this.entriesIterator = entries.iterator();
        this.contentSupplier = contentSupplier;
    }

    @Override
    public IterableZipContainer duplicate() {
        return new ZipFile(this.absolutePath, this.entries, this.contentSupplier);
    }

    @Override
    public String getAbsolutePath() {
        return this.absolutePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getConventionedAbsolutePath() {
        if (this.conventionedAbsolutePath == null) {
            ZipFile zipFile = this;
            synchronized (zipFile) {
                if (this.parent != null) {
                    this.conventionedAbsolutePath = this.parent.getConventionedAbsolutePath() + this.absolutePath.replace(this.parent.getAbsolutePath() + "/", "");
                } else {
                    FileSystemItem zipFis = FileSystemItem.ofPath(this.absolutePath);
                    if (zipFis.getParentContainer().isArchive()) {
                        this.parent = IterableZipContainer.create(zipFis.getParentContainer().getAbsolutePath());
                        return this.getConventionedAbsolutePath();
                    }
                    this.conventionedAbsolutePath = this.absolutePath;
                }
                this.conventionedAbsolutePath = this.conventionedAbsolutePath + "///";
            }
        }
        return this.conventionedAbsolutePath;
    }

    @Override
    public IterableZipContainer getParent() {
        if (this.conventionedAbsolutePath == null) {
            this.getConventionedAbsolutePath();
        }
        return this.parent;
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return StaticComponentContainer.Cache.pathForContents.getOrUploadIfAbsent(this.getAbsolutePath(), this.contentSupplier);
    }

    @Override
    public synchronized <Z extends IterableZipContainer.Entry> Z getNextEntry() {
        this.currentZipEntry = this.entriesIterator.hasNext() ? (IterableZipContainer.Entry)this.entriesIterator.next() : null;
        return (Z)this.currentZipEntry;
    }

    @Override
    public synchronized Entry getNextEntry(Predicate<IterableZipContainer.Entry> loadZipEntryData) {
        this.currentZipEntry = this.entriesIterator.hasNext() ? (IterableZipContainer.Entry)this.entriesIterator.next() : null;
        return (Entry)this.currentZipEntry;
    }

    @Override
    public IterableZipContainer.Entry getCurrentZipEntry() {
        return this.currentZipEntry;
    }

    @Override
    public Function<IterableZipContainer.Entry, IterableZipContainer.Entry> getEntrySupplier() {
        return entry -> entry;
    }

    @Override
    public synchronized void closeEntry() {
        this.currentZipEntry = null;
    }

    @Override
    public void close() {
        this.closeEntry();
        java.util.zip.ZipFile originalZipFile = this.originalZipFile;
        if (originalZipFile != null) {
            try {
                originalZipFile.close();
            }
            catch (IOException exc) {
                StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, "Exception while closing " + this.getAbsolutePath(), exc);
            }
        }
        this.absolutePath = null;
        this.entriesIterator = null;
        this.entries = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(boolean removeFromCache) {
        boolean destroy = false;
        ZipFile zipFile = this;
        synchronized (zipFile) {
            if (!this.isDestroyed.booleanValue()) {
                this.isDestroyed = Boolean.TRUE;
                destroy = this.isDestroyed;
            }
        }
        if (destroy) {
            this.contentSupplier = null;
            IterableZipContainer.super.destroy(removeFromCache);
            for (Entry entry : this.entries) {
                entry.destroy();
            }
            this.entries.clear();
            this.close();
            Runnable temporaryFileDeleter = this.temporaryFileDeleter;
            if (temporaryFileDeleter != null) {
                this.temporaryFileDeleter = null;
                temporaryFileDeleter.run();
            }
        }
    }

    public static class Entry
    implements IterableZipContainer.Entry {
        private ZipFile zipMemoryContainer;
        private String cleanedName;
        private String name;
        private String absolutePath;
        private Supplier<ByteBuffer> zipEntryContentSupplier;
        private Boolean archive;

        Entry(ZipFile zipMemoryContainer, String entryName, Supplier<ByteBuffer> zipEntryContentSupplier) {
            this.zipMemoryContainer = zipMemoryContainer;
            this.name = entryName;
            this.absolutePath = StaticComponentContainer.Paths.clean(zipMemoryContainer.getAbsolutePath() + "/" + entryName);
            this.zipEntryContentSupplier = zipEntryContentSupplier;
        }

        @Override
        public boolean isArchive() {
            if (this.archive != null) {
                return this.archive;
            }
            ByteBuffer content = this.toByteBuffer();
            this.archive = content != null ? StaticComponentContainer.Streams.isArchive(content) : false;
            return this.archive;
        }

        @Override
        public IterableZipContainer getParentContainer() {
            return this.zipMemoryContainer;
        }

        @Override
        public String getCleanedName() {
            if (this.cleanedName != null) {
                return this.cleanedName;
            }
            String cleanedName = this.name;
            this.cleanedName = !cleanedName.startsWith("/") ? cleanedName : (!cleanedName.equals("/") ? cleanedName.substring(1, cleanedName.length()) : "");
            return this.cleanedName;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getAbsolutePath() {
            return this.absolutePath;
        }

        @Override
        public boolean isDirectory() {
            return this.name.endsWith("/");
        }

        @Override
        public ByteBuffer toByteBuffer() {
            return StaticComponentContainer.Cache.pathForContents.getOrUploadIfAbsent(this.getAbsolutePath(), this.zipEntryContentSupplier);
        }

        public void destroy() {
            this.absolutePath = null;
            this.name = null;
            this.archive = null;
            this.cleanedName = null;
            this.zipEntryContentSupplier = null;
            this.zipMemoryContainer = null;
        }
    }
}

