/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.schemaobjecteditor.ui.core;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentServiceImpl;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.DatabaseDefinitionRegistryImpl;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.common.ui.dialog.SaveAsDialog;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.schemaobjecteditor.model.AbstractSchemaObjectEditModel;
import org.eclipse.datatools.sqltools.schemaobjecteditor.model.ISchemaObjectEditModel;
import org.eclipse.datatools.sqltools.schemaobjecteditor.model.ISchemaObjectImmutableModel;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.IErrorItem;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.IResourceChangeEvent;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditor;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditorHandler;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditorInput;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditorPage;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.SchemaObjectEditorModelListenersNotifier;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.core.Messages;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.core.SQLExecutionJobListener;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.core.SchemaObjectEditor;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.extensions.IEditorPageDescriptor;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.SOEUIPlugin;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.core.ScriptsExecutionRunnable;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.ui.SavePreviewDialog;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.util.SQLUtil;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.util.SchemaObjectEditorUtils;
import org.eclipse.datatools.sqltools.sql.util.ModelUtil;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorConnectionInfo;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class DefaultSchemaObjectEditorHandler
implements ISchemaObjectEditorHandler {
    protected ISchemaObjectEditor _editor;
    protected SchemaObjectEditorModelListenersNotifier _notifier;
    protected boolean _inSavingProcess = false;

    protected IStatus constructStatus(Map pageErrors) {
        if (this._editor == null) {
            return null;
        }
        MultiStatus errorStatus = new MultiStatus("org.eclipse.datatools.sqltools.schemaobjecteditor.ui", 1, Messages.DefaultSchemaObjectEditorHandler_validation_fail, null);
        ISchemaObjectEditorPage[] pages = this._editor.getAllPages();
        int i = 0;
        while (i < pages.length) {
            if (pages[i] != null) {
                MultiStatus pageStatus = new MultiStatus("org.eclipse.datatools.sqltools.schemaobjecteditor.ui", 1, String.valueOf(Messages.DefaultSchemaObjectEditorHandler_page) + pages[i].getPageDescriptor().getPageName(), null);
                IErrorItem[] items = (IErrorItem[])pageErrors.get(pages[i]);
                if (items != null) {
                    int j = 0;
                    while (j < items.length) {
                        if (items[j] != null) {
                            Status status = new Status(4, "org.eclipse.datatools.sqltools.schemaobjecteditor.ui", 1, items[j].getMessage(), null);
                            pageStatus.add((IStatus)status);
                        }
                        ++j;
                    }
                    errorStatus.add((IStatus)pageStatus);
                }
            }
            ++i;
        }
        return errorStatus;
    }

    @Override
    public void dispose() {
        if (this.getEditorInput() != null) {
            this.getEditorInput().getEditModelObject().stopLogging();
        }
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        if (this._editor == null) {
            return;
        }
        this._inSavingProcess = true;
        Map pageErrors = this._editor.validate();
        if (!this.hasError(pageErrors)) {
            IPreferenceStore store = SOEUIPlugin.getDefault().getPreferenceStore();
            boolean showPreview = store.getBoolean("SchemaObjectEditorPreferencePage.show.preview.dialog");
            String scripts = this.generateScript();
            if (showPreview && scripts.length() != 0) {
                ISchemaObjectEditorInput input = (ISchemaObjectEditorInput)this._editor.getEditorInput();
                SavePreviewDialog dlg = new SavePreviewDialog(SOEUIPlugin.getActiveWorkbenchShell(), scripts, input.getDatabaseIdentifier(), this._editor, this._editor.isSyncSave(), monitor, this.getGroupExecDisplayString(), this._editor.getEditorDescriptor().getEditorName());
                dlg.open();
            } else {
                ISchemaObjectEditorInput input = (ISchemaObjectEditorInput)this._editor.getEditorInput();
                ScriptsExecutionRunnable scriptsRunnable = new ScriptsExecutionRunnable(scripts, input.getDatabaseIdentifier(), new SQLExecutionJobListener(this._editor, monitor), this._editor.isSyncSave(), monitor, this.getGroupExecDisplayString(), this._editor.getEditorDescriptor().getEditorName());
                scriptsRunnable.run();
            }
        } else {
            IStatus status = this.constructStatus(pageErrors);
            ErrorDialog dlg = new ErrorDialog(SOEUIPlugin.getActiveWorkbenchShell(), Messages.DefaultSchemaObjectEditorHandler_validation_problem, Messages.DefaultSchemaObjectEditorHandler_existing_errors, status, 4);
            dlg.open();
        }
        this._inSavingProcess = false;
    }

    @Override
    public void doSaveAs() {
    }

    @Override
    public String generateScript() {
        return this.getEditorInput().getEditModelObject().getDeltaDDL();
    }

    @Override
    public Object getAdapter(Class adapter) {
        return null;
    }

    protected boolean hasError(Map pageErrors) {
        if (pageErrors == null || pageErrors.keySet().size() == 0 || this._editor == null) {
            return false;
        }
        ISchemaObjectEditorPage[] pages = this._editor.getAllPages();
        int i = 0;
        while (i < pages.length) {
            IErrorItem[] items;
            if (pages[i] != null && (items = (IErrorItem[])pageErrors.get(pages[i])) != null && items.length > 0) {
                int j = 0;
                while (j < items.length) {
                    if (items[j].getSeverity() == 4 || items[j].getSeverity() == 1) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isSaveAsAllowed() {
        return false;
    }

    @Override
    public void pageChanged(int newPageIndex) {
    }

    protected boolean isEditorDisposed() {
        IEditorPart part = SOEUIPlugin.getActiveWorkbenchPage().findEditor(this._editor.getEditorInput());
        return part == null;
    }

    @Override
    public void refreshFromDB(IProgressMonitor monitor) {
        if (this._editor == null) {
            return;
        }
        SOEUIPlugin.getActiveWorkbenchShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                DefaultSchemaObjectEditorHandler.this._editor.clearDirty();
            }
        });
        if (monitor != null) {
            if (this.isEditorDisposed()) {
                monitor.beginTask(Messages.DefaultSchemaObjectEditorHandler_refreshing, -1);
            } else {
                monitor.beginTask(Messages.DefaultSchemaObjectEditorHandler_refreshing_schema_editor, -1);
            }
            monitor.subTask(Messages.DefaultSchemaObjectEditorHandler_subtask_name);
        }
        int theStatus = -1;
        SQLObject sqlObject = this.getEditorInput().getEditModelObject().getMainSQLObject();
        theStatus = sqlObject == null ? 1 : this.getEditorInput().getEditModelObject().refreshFromDB();
        final int status = theStatus;
        SOEUIPlugin.getActiveWorkbenchShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (status == 1) {
                    DefaultSchemaObjectEditorHandler.this.promptSaveAndCloseEditor();
                }
            }
        });
        if (status != 1) {
            if (this._notifier == null) {
                this._notifier = this.getNotifier();
            }
            this._notifier.registerListener(this.getEditorInput());
            final ISchemaObjectEditorPage[] pages = this._editor.getAllPages();
            SOEUIPlugin.getActiveWorkbenchShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    int i = 0;
                    while (i < pages.length) {
                        if (pages[i] != null) {
                            try {
                                pages[i].modelRegenerated();
                            }
                            catch (Exception exception) {}
                        }
                        ++i;
                    }
                    DefaultSchemaObjectEditorHandler.this._editor.setEditorPartName(SQLUtil.unquote(DefaultSchemaObjectEditorHandler.this.getEditorInput().getName()));
                    SchemaObjectEditorUtils.expandNode(DefaultSchemaObjectEditorHandler.this.getEditorInput().getEditModelObject().getSchemaObjectImmutableModel().getMainSQLObject());
                }
            });
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    private void promptSaveAndCloseEditor() {
        MessageDialog dialog = new MessageDialog(SOEUIPlugin.getActiveWorkbenchShell(), Messages.MainSQLObjectLostPromoptSavingTitle, null, Messages.MainSQLObjectLostPromoptSavingMessage, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        if (dialog.open() == 0) {
            ISchemaObjectEditModel schemaObjectEditModel = this.getEditorInput().getEditModelObject();
            String ddl = null;
            if (schemaObjectEditModel instanceof AbstractSchemaObjectEditModel) {
                ddl = ((AbstractSchemaObjectEditModel)schemaObjectEditModel).getBackupedDDL();
            }
            SaveAsDialog dia = new SaveAsDialog(SOEUIPlugin.getActiveWorkbenchShell(), ddl);
            dia.setOriginalName(String.valueOf(this._editor.getDisplayName()) + "_ddl.sql");
            dia.setOpenMode(this.getOpenFileAfterSaveasOption());
            dia.open();
            IEditorPart editor = dia.getEditor();
            if (editor != null && editor instanceof SQLEditor) {
                ISchemaObjectEditorInput input = (ISchemaObjectEditorInput)this._editor.getEditorInput();
                DatabaseIdentifier databaseIdentifier = input.getDatabaseIdentifier();
                SQLEditorConnectionInfo connInfo = new SQLEditorConnectionInfo(SQLToolsFacade.getConfigurationByProfileName((String)databaseIdentifier.getProfileName()).getDatabaseVendorDefinitionId(), databaseIdentifier.getProfileName(), databaseIdentifier.getDBname(), databaseIdentifier.getDBname());
                ((SQLEditor)editor).setConnectionInfo((ISQLEditorConnectionInfo)connInfo);
            }
        }
        IWorkbenchPage workPage = SOEUIPlugin.getActiveWorkbenchPage();
        workPage.closeEditor((IEditorPart)this._editor, false);
    }

    @Override
    public void resouceChanged(IResourceChangeEvent event) {
    }

    @Override
    public void revert() {
        if (this._editor == null) {
            return;
        }
        ISchemaObjectEditModel model = this.getEditorInput().getEditModelObject();
        if (!model.checkModelExistence()) {
            this.promptObjectLost(model);
            this.promptSaveAndCloseEditor();
            return;
        }
        this.getEditorInput().getEditModelObject().revert();
        if (this._notifier == null) {
            this._notifier = this.getNotifier();
        }
        this._notifier.registerListener(this.getEditorInput());
        ISchemaObjectEditorPage[] pages = this._editor.getAllPages();
        int i = 0;
        while (i < pages.length) {
            if (pages[i] != null) {
                try {
                    pages[i].revert();
                }
                catch (Exception exception) {}
            }
            ++i;
        }
        this._editor.clearDirty();
    }

    @Override
    public void setEditor(ISchemaObjectEditor editor) {
        this._editor = editor;
        editor.setEditorPartName(SQLUtil.unquote(this.getEditorInput().getName()));
    }

    @Override
    public String getDisplayName() {
        return Messages.SavePreviewDialog_noname_sql;
    }

    public ISchemaObjectEditorInput getEditorInput() {
        if (this._editor == null) {
            return null;
        }
        ISchemaObjectEditorInput input = (ISchemaObjectEditorInput)this._editor.getEditorInput();
        return input;
    }

    @Override
    public void hookInitialization() {
    }

    @Override
    public synchronized SchemaObjectEditorModelListenersNotifier getNotifier() {
        if (this._notifier == null) {
            this._notifier = new SchemaObjectEditorModelListenersNotifier();
            this._notifier.registerListener(this.getEditorInput());
        }
        return this._notifier;
    }

    @Override
    public boolean inSavingProcess() {
        return this._inSavingProcess;
    }

    public String getGroupExecDisplayString() {
        return String.valueOf(Messages.DefaultSchemaObjectEditorHandler_modifying) + " " + this._editor.getEditorDescriptor().getObjectTypeName() + ": " + this.getQualifiedObjectName();
    }

    protected String getQualifiedObjectName() {
        ISchemaObjectImmutableModel immutableModel = this.getEditorInput().getEditModelObject().getSchemaObjectImmutableModel();
        StringBuffer sb = new StringBuffer("");
        EObject root = ContainmentServiceImpl.INSTANCE.getRootElement((EObject)immutableModel.getMainSQLObject());
        if (root != null && root instanceof Database) {
            Database db = (Database)root;
            DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition(db);
            sb.append(ModelUtil.getDatabaseName((EObject)immutableModel.getMainSQLObject())).append(".");
            String schemaName = new String();
            SQLObject sqlObject = immutableModel.getMainSQLObject();
            if (sqlObject instanceof Table) {
                schemaName = ((Table)sqlObject).getSchema().getName();
            } else if (sqlObject instanceof Routine) {
                schemaName = ((Routine)sqlObject).getSchema().getName();
            }
            sb.append(schemaName);
        }
        sb.append(immutableModel.getMainSQLObject().getName());
        return sb.toString();
    }

    public boolean getOpenFileAfterSaveasOption() {
        IPreferenceStore store = SOEUIPlugin.getDefault().getPreferenceStore();
        boolean isOpenFile = store.getBoolean("SchemaObjectEditorPreferencePage.open.file.after.saveas");
        return isOpenFile;
    }

    @Override
    public void forceFocusObject(SQLObject object) {
        SOEUIPlugin.getActiveWorkbenchPage().activate((IWorkbenchPart)this._editor);
        ISchemaObjectEditorPage[] pages = this._editor.getAllPages();
        int i = 0;
        while (i < pages.length) {
            if (pages[i] != null) {
                IEditorPageDescriptor pageDesp = pages[i].getPageDescriptor();
                try {
                    Class<?> c = null;
                    try {
                        c = Class.forName(pageDesp.getObjectClassType());
                    }
                    catch (Exception exception) {}
                    if (c != null && c.isInstance(object)) {
                        ((SchemaObjectEditor)this._editor).setActivePage(pages[i].getPageDescriptor().getPageId());
                        pages[i].setFocus(-1, object);
                        return;
                    }
                }
                catch (Exception exception) {}
            }
            ++i;
        }
    }

    @Override
    public boolean checkSchemaObjectExistence(boolean doCheck) {
        if (!doCheck) {
            return true;
        }
        ISchemaObjectEditModel editModel = this.getEditorInput().getEditModelObject();
        if (!editModel.checkModelExistence()) {
            this.promptObjectLost(editModel);
            MessageDialog dialog = new MessageDialog(SOEUIPlugin.getActiveWorkbenchShell(), Messages.MainSQLObjectLostPromoptSavingTitle, null, Messages.MainSQLObjectLostPromoptSavingMessage, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            ISchemaObjectEditModel schemaObjectEditModel = this.getEditorInput().getEditModelObject();
            String ddl = null;
            if (schemaObjectEditModel instanceof AbstractSchemaObjectEditModel) {
                ddl = ((AbstractSchemaObjectEditModel)schemaObjectEditModel).getBackupedDDL();
            }
            if (ddl != null && dialog.open() == 0) {
                final SaveAsDialog dia = new SaveAsDialog(SOEUIPlugin.getActiveWorkbenchShell(), ddl);
                dia.setOriginalName(String.valueOf(this._editor.getDisplayName()) + "_ddl.sql");
                dia.setOpenMode(this.getOpenFileAfterSaveasOption());
                SOEUIPlugin.getActiveWorkbenchShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        dia.open();
                        IEditorPart editor = dia.getEditor();
                        if (editor != null && editor instanceof SQLEditor) {
                            ISchemaObjectEditorInput input = (ISchemaObjectEditorInput)DefaultSchemaObjectEditorHandler.this._editor.getEditorInput();
                            DatabaseIdentifier databaseIdentifier = input.getDatabaseIdentifier();
                            SQLEditorConnectionInfo connInfo = new SQLEditorConnectionInfo(SQLToolsFacade.getConfigurationByProfileName((String)databaseIdentifier.getProfileName()).getDatabaseVendorDefinitionId(), databaseIdentifier.getProfileName(), databaseIdentifier.getDBname(), databaseIdentifier.getDBname());
                            ((SQLEditor)editor).setConnectionInfo((ISQLEditorConnectionInfo)connInfo);
                        }
                    }
                });
            }
            final IWorkbenchPage workPage = SOEUIPlugin.getActiveWorkbenchPage();
            SOEUIPlugin.getActiveWorkbenchShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    workPage.closeEditor((IEditorPart)DefaultSchemaObjectEditorHandler.this._editor, false);
                }
            });
            return false;
        }
        return true;
    }

    private void promptObjectLost(final ISchemaObjectEditModel editModel) {
        SOEUIPlugin.getActiveWorkbenchShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                String[] buttons = new String[]{IDialogConstants.OK_LABEL};
                MessageDialog d = new MessageDialog(SOEUIPlugin.getActiveWorkbenchShell(), Messages.AbstractSchemaObjectEditModel_fatal_error, null, Messages.bind((String)Messages.AbstractSchemaObjectEditModel_main_object_lost, (Object)editModel.getMainSQLObject().getName()), 1, buttons, 0);
                d.open();
            }
        });
    }
}

