/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilderPlugin;
import org.eclipse.datatools.sqltools.sqlbuilder.model.IOmitSchemaInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.model.OmitSchemaInfo;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorConnectionInfo;

public class SQLFileUtil {
    private static final String ENCODED_CONNECTION_PROPERTYNAME = "encodedConnection";
    private static final String ENCODED_OMIT_SCHEMA_PROPERTYNAME = "encodedOmitSchemaInfo";

    public static ISQLEditorConnectionInfo getConnectionInfo(IFile file) {
        String encodedConnection = null;
        encodedConnection = SQLFileUtil.getEncodedConnectionInfo(file);
        ISQLEditorConnectionInfo connectionInfo = encodedConnection != null && !encodedConnection.trim().equals("") ? SQLEditorConnectionInfo.decode((String)encodedConnection) : SQLEditorConnectionInfo.DEFAULT_SQLEDITOR_CONNECTION_INFO;
        return connectionInfo;
    }

    public static String getEncodedConnectionInfo(IFile file) {
        String encodedConnection = null;
        if (file != null) {
            try {
                encodedConnection = file.getPersistentProperty(new QualifiedName("org.eclipse.datatools.sqltools.sqlscrapbook", ENCODED_CONNECTION_PROPERTYNAME));
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return encodedConnection;
    }

    public static void setEncodedConnectionInfo(IFile fileResource, String encodedConnection) {
        try {
            if (fileResource.exists()) {
                fileResource.setPersistentProperty(new QualifiedName("org.eclipse.datatools.sqltools.sqlscrapbook", ENCODED_CONNECTION_PROPERTYNAME), encodedConnection);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static IOmitSchemaInfo getOmitSchemaInfo(IFile file) {
        OmitSchemaInfo omitSchemaInfo;
        String encodedOmitSchemaInfo = null;
        encodedOmitSchemaInfo = SQLFileUtil.getEncodedOmitSchemaInfo(file);
        if (encodedOmitSchemaInfo != null && !encodedOmitSchemaInfo.trim().equals("")) {
            omitSchemaInfo = OmitSchemaInfo.decode(encodedOmitSchemaInfo);
        } else {
            omitSchemaInfo = new OmitSchemaInfo();
            omitSchemaInfo.initFromPreferences();
        }
        return omitSchemaInfo;
    }

    public static String getEncodedOmitSchemaInfo(IFile file) {
        String encodedOmitSchemaInfo = null;
        if (file != null) {
            try {
                encodedOmitSchemaInfo = file.getPersistentProperty(new QualifiedName(SQLBuilderPlugin.getPlugin().getBundle().getSymbolicName(), ENCODED_OMIT_SCHEMA_PROPERTYNAME));
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return encodedOmitSchemaInfo;
    }

    public static void setEncodedOmitSchemaInfo(IFile fileResource, String encodedOmitSchemaInfo) {
        try {
            if (fileResource.exists()) {
                fileResource.setPersistentProperty(new QualifiedName(SQLBuilderPlugin.getPlugin().getBundle().getSymbolicName(), ENCODED_OMIT_SCHEMA_PROPERTYNAME), encodedOmitSchemaInfo);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

