/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.tutorial.features;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IDirectEditingContext;
import org.eclipse.graphiti.features.impl.AbstractDirectEditingFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class TutorialDirectEditEClassFeature
extends AbstractDirectEditingFeature {
    public TutorialDirectEditEClassFeature(IFeatureProvider fp) {
        super(fp);
    }

    public int getEditingType() {
        return 1;
    }

    public boolean canDirectEdit(IDirectEditingContext context) {
        PictogramElement pe = context.getPictogramElement();
        Object bo = this.getBusinessObjectForPictogramElement(pe);
        GraphicsAlgorithm ga = context.getGraphicsAlgorithm();
        return bo instanceof EClass && ga instanceof Text;
    }

    public String getInitialValue(IDirectEditingContext context) {
        PictogramElement pe = context.getPictogramElement();
        EClass eClass = (EClass)this.getBusinessObjectForPictogramElement(pe);
        return eClass.getName();
    }

    public String checkValueValid(String value, IDirectEditingContext context) {
        if (value.length() < 1) {
            return "Please enter any text as class name.";
        }
        if (value.contains(" ")) {
            return "Spaces are not allowed in class names.";
        }
        if (value.contains("\n")) {
            return "Line breakes are not allowed in class names.";
        }
        return null;
    }

    public void setValue(String value, IDirectEditingContext context) {
        PictogramElement pe = context.getPictogramElement();
        EClass eClass = (EClass)this.getBusinessObjectForPictogramElement(pe);
        eClass.setName(value);
        this.updatePictogramElement((PictogramElement)((Shape)pe).getContainer());
    }
}

