/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.corext.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.php.core.compiler.ast.nodes.FullyQualifiedReference;
import org.eclipse.php.core.compiler.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.core.compiler.ast.nodes.PHPModuleDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.core.compiler.ast.nodes.UseStatement;
import org.eclipse.php.core.compiler.ast.visitor.PHPASTVisitor;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;

public class DocumentUtils {
    public static List<UseStatement> flatten(List<UseStatement> statements) {
        Vector<UseStatement> total = new Vector<UseStatement>();
        for (UseStatement statement : statements) {
            for (UsePart part : statement.getParts()) {
                Vector<UsePart> parts = new Vector<UsePart>();
                parts.add(part);
                total.add(new UseStatement(statement.start(), statement.end(), statement.getNamespace(), parts, statement.getStatementType()));
            }
        }
        return total;
    }

    public static boolean containsUseStatement(UsePart part, String contents, List<Position> excludePositions) {
        String className = part.getAlias() != null ? part.getAlias().toString() : (part.getNamespace() != null ? part.getNamespace().toString() : "");
        Pattern p = Pattern.compile("(?i)\\b(" + Pattern.quote(className) + ")\\b");
        Matcher m = p.matcher(contents);
        int restartPos = 0;
        block0: while (m.find()) {
            if (excludePositions.isEmpty()) {
                return true;
            }
            int i = restartPos;
            while (i < excludePositions.size()) {
                Position position = excludePositions.get(i);
                if (position.getOffset() + position.getLength() <= m.start()) {
                    if (i == excludePositions.size() - 1) {
                        return true;
                    }
                    ++restartPos;
                } else {
                    if (position.getOffset() >= m.end()) {
                        return true;
                    }
                    assert (position.getOffset() <= m.start() && m.end() <= position.getOffset() + position.getLength());
                    continue block0;
                }
                ++i;
            }
        }
        return false;
    }

    public static List<Position> getExcludeSortedAndFilteredPositions(ASTNode[] nodes) {
        ArrayList<Position> excludePositions = new ArrayList<Position>();
        ASTNode[] aSTNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            ASTNode n3 = aSTNodeArray[n2];
            if (!(n3 instanceof PHPDocBlock)) {
                excludePositions.add(new Position(n3.sourceStart(), n3.sourceEnd() - n3.sourceStart()));
            }
            ++n2;
        }
        return excludePositions;
    }

    public static String stripUseStatements(UseStatement[] statements, IDocument old_doc, List<Position> excludePositions) {
        return DocumentUtils.stripUseStatements(statements, old_doc, 0, old_doc.getLength(), excludePositions);
    }

    public static String stripUseStatements(UseStatement[] statements, IDocument old_doc, int start, int end, List<Position> excludePositions) {
        int removedLength = 0;
        Document doc = new Document(old_doc.get());
        UseStatement[] useStatementArray = statements;
        int n = statements.length;
        int n2 = 0;
        while (n2 < n) {
            UseStatement statement = useStatementArray[n2];
            if (statement.sourceStart() >= start && statement.sourceEnd() <= end) {
                int length = statement.sourceEnd() - statement.sourceStart();
                try {
                    doc.replace(statement.sourceStart() - removedLength, length, "");
                }
                catch (BadLocationException badLocationException) {}
                int i = excludePositions.size() - 1;
                while (i >= 0) {
                    Position position = excludePositions.get(i);
                    int offset = position.getOffset() + removedLength;
                    if (offset >= statement.sourceEnd()) {
                        position.setOffset(position.getOffset() - length);
                    } else {
                        if (offset + position.getLength() <= statement.sourceStart()) break;
                        excludePositions.remove(i);
                    }
                    --i;
                }
                removedLength += length;
            }
            ++n2;
        }
        try {
            return doc.get(start, end - start - removedLength);
        }
        catch (BadLocationException badLocationException) {
            return doc.get();
        }
    }

    public static String createStringFromUseStatement(List<UseStatement> statements, String indent) {
        StringBuilder total = new StringBuilder();
        for (UseStatement statement : statements) {
            total.append(DocumentUtils.createStringFromUseStatement(statement, indent));
        }
        return total.toString().trim();
    }

    public static String createStringFromUseStatement(UseStatement statement) {
        return DocumentUtils.createStringFromUseStatement(statement, "");
    }

    public static String createStringFromUseStatement(UseStatement statement, String indent) {
        return DocumentUtils.createStringFromUseStatement(statement, indent, -1);
    }

    private static String createStringFromUseStatement(UseStatement statement, int usePartIndex) {
        return DocumentUtils.createStringFromUseStatement(statement, "", usePartIndex);
    }

    private static String createStringFromUseStatement(UseStatement statement, String indent, int usePartIndex) {
        String use = String.valueOf(indent) + "use ";
        switch (statement.getStatementType()) {
            case 1: {
                use = String.valueOf(use) + "function ";
                break;
            }
            case 2: {
                use = String.valueOf(use) + "const ";
            }
        }
        if (statement.getNamespace() != null) {
            use = String.valueOf(use) + statement.getNamespace().getFullyQualifiedName();
            use = String.valueOf(use) + "\\{";
        }
        assert (usePartIndex < 0 || usePartIndex < statement.getParts().size());
        int index = -1;
        for (UsePart part : statement.getParts()) {
            if (usePartIndex >= 0 && usePartIndex != ++index) continue;
            if (usePartIndex < 0 && index > 0) {
                use = String.valueOf(use) + ", ";
            }
            if (statement.getStatementType() == 0) {
                switch (part.getStatementType()) {
                    case 1: {
                        use = String.valueOf(use) + "function ";
                        break;
                    }
                    case 2: {
                        use = String.valueOf(use) + "const ";
                    }
                }
            }
            use = String.valueOf(use) + part.getNamespace().getFullyQualifiedName();
            if (part.getAlias() == null) continue;
            use = String.valueOf(use) + " as " + part.getAlias().getName();
        }
        if (statement.getNamespace() != null) {
            use = String.valueOf(use) + "}";
        }
        return String.valueOf(use) + ";\n";
    }

    public static List<UseStatement> filterAndSort(UseStatement[] statements, IDocument doc, ModuleDeclaration moduleDeclaration) {
        Vector<UseStatement> total = new Vector<UseStatement>();
        NamespaceFinder visitor = new NamespaceFinder();
        try {
            moduleDeclaration.traverse((ASTVisitor)visitor);
        }
        catch (Exception exception) {}
        UseStatement[] useStatementArray = statements;
        int n = statements.length;
        int n2 = 0;
        while (n2 < n) {
            UseStatement statement = useStatementArray[n2];
            List<Object> excludePositions = moduleDeclaration instanceof PHPModuleDeclaration ? DocumentUtils.getExcludeSortedAndFilteredPositions(((PHPModuleDeclaration)moduleDeclaration).getCommentList().toArray(new ASTNode[0])) : new ArrayList();
            NamespaceDeclaration currentNamespace = visitor.getNamespaceDeclarationFor(statement);
            String contents = currentNamespace != null && currentNamespace.isBracketed() ? DocumentUtils.stripUseStatements(statements, doc, currentNamespace.sourceStart(), currentNamespace.sourceEnd(), excludePositions) : DocumentUtils.stripUseStatements(statements, doc, excludePositions);
            Vector<UsePart> parts = new Vector<UsePart>();
            for (UsePart part : statement.getParts()) {
                if (!DocumentUtils.containsUseStatement(part, contents, excludePositions)) continue;
                parts.add(part);
            }
            if (parts.size() > 0) {
                total.add(new UseStatement(statement.start(), statement.end(), statement.getNamespace(), parts, statement.getStatementType()));
            }
            ++n2;
        }
        TreeSet<UseStatement> set = new TreeSet<UseStatement>(new Comparator<UseStatement>(){

            @Override
            private int compare(FullyQualifiedReference a, FullyQualifiedReference b) {
                if (a == b) {
                    return 0;
                }
                if (a == null) {
                    return b == null ? 0 : -1;
                }
                if (b == null) {
                    return 1;
                }
                return a.getFullyQualifiedName().toLowerCase().compareTo(b.getFullyQualifiedName().toLowerCase());
            }

            @Override
            public int compare(UseStatement a, UseStatement b) {
                if (a == b) {
                    return 0;
                }
                int comp = a.getStatementType() - b.getStatementType();
                if (comp != 0) {
                    return comp;
                }
                comp = this.compare(a.getNamespace(), b.getNamespace());
                if (comp != 0) {
                    return comp;
                }
                UsePart[] partsA = a.getParts().toArray(new UsePart[a.getParts().size()]);
                UsePart[] partsB = b.getParts().toArray(new UsePart[b.getParts().size()]);
                int minPartslength = Math.min(partsA.length, partsB.length);
                int i = 0;
                while (i < minPartslength) {
                    comp = partsA[i].getStatementType() - partsB[i].getStatementType();
                    if (comp != 0) {
                        return comp;
                    }
                    String partA = DocumentUtils.createStringFromUseStatement(a, i).toLowerCase();
                    String partB = DocumentUtils.createStringFromUseStatement(b, i).toLowerCase();
                    String[] splitsA = partA.split("\\\\");
                    String[] splitsB = partB.split("\\\\");
                    int minSplitsLength = Math.min(splitsA.length, splitsB.length);
                    int j = 0;
                    while (j < minSplitsLength) {
                        comp = splitsA[j].compareTo(splitsB[j]);
                        if (comp != 0) {
                            return comp;
                        }
                        ++j;
                    }
                    comp = splitsA.length - splitsB.length;
                    if (comp != 0) {
                        return comp;
                    }
                    ++i;
                }
                return partsA.length - partsB.length;
            }
        });
        set.addAll(total);
        return new ArrayList<UseStatement>(set);
    }

    public static void sortUseStatements(ModuleDeclaration moduleDeclaration, IDocument doc) {
        UseStatement[] statements = ASTUtils.getUseStatements(moduleDeclaration, doc.getLength());
        int start = 0;
        Vector<ReplaceAction> queue = new Vector<ReplaceAction>();
        while (start < statements.length) {
            int last_item = statements.length - 1;
            int i = start;
            while (i < statements.length - 1) {
                block10: {
                    try {
                        if (doc.getLineOfOffset(statements[i + 1].sourceStart()) > doc.getLineOfOffset(statements[i].sourceStart()) + 1) {
                            last_item = i;
                        }
                        break block10;
                    }
                    catch (BadLocationException badLocationException) {
                        last_item = i;
                    }
                    break;
                }
                ++i;
            }
            String indent = "";
            try {
                int lineOffset = doc.getLineOffset(doc.getLineOfOffset(statements[start].sourceStart()));
                indent = doc.get(lineOffset, statements[start].sourceStart() - lineOffset);
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
            queue.add(new ReplaceAction(DocumentUtils.filterAndSort(Arrays.copyOfRange(statements, start, last_item + 1), doc, moduleDeclaration), statements[start].sourceStart(), statements[last_item].sourceEnd(), indent));
            start = last_item + 1;
        }
        int offset = 0;
        for (ReplaceAction item : queue) {
            List<UseStatement> sorted = item.statements;
            int length = item.end - item.start;
            String newNamespaces = DocumentUtils.createStringFromUseStatement(sorted, item.indent);
            try {
                doc.replace(item.start - offset, length, newNamespaces);
            }
            catch (BadLocationException badLocationException) {}
            offset += length - newNamespaces.length();
        }
    }

    private static class NamespaceFinder
    extends PHPASTVisitor {
        Vector<NamespaceDeclaration> declarations = new Vector();

        private NamespaceFinder() {
        }

        @Override
        public boolean visit(NamespaceDeclaration n) throws Exception {
            this.declarations.add(n);
            return super.visit(n);
        }

        public NamespaceDeclaration getNamespaceDeclarationFor(UseStatement statement) {
            for (NamespaceDeclaration n : this.declarations) {
                if (n.sourceStart() > statement.sourceStart() || n.sourceEnd() < statement.sourceEnd()) continue;
                return n;
            }
            return null;
        }
    }

    private static class ReplaceAction {
        public List<UseStatement> statements;
        public int start;
        public int end;
        public String indent;

        public ReplaceAction(List<UseStatement> statements, int start, int end, String indent) {
            this.statements = statements;
            this.start = start;
            this.end = end;
            this.indent = indent;
        }
    }
}

