/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.launch;

import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.internal.debug.ui.launch.setup.PeerPropsControl;

class PeerPropsDialog
extends Dialog {
    private final Map<String, String> attrs;
    private final boolean enable_editing;
    private final Image image;
    private PeerPropsControl props;

    PeerPropsDialog(Shell parent, Image image, Map<String, String> attrs, boolean enable_editing) {
        super(parent);
        this.image = image;
        this.attrs = attrs;
        this.enable_editing = enable_editing;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("TCF Peer Properties");
        shell.setImage(this.image);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        if (this.enable_editing) {
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }
        this.updateButtons();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.props = new PeerPropsControl(composite, this.attrs, this.enable_editing, new Runnable(){

            @Override
            public void run() {
                PeerPropsDialog.this.updateButtons();
            }
        });
        composite.setSize(composite.computeSize(-1, -1));
        return composite;
    }

    private void updateButtons() {
        this.getButton(0).setEnabled(this.props.isComplete());
    }

    protected void okPressed() {
        this.props.okPressed();
        super.okPressed();
    }
}

