/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.converter;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Locale;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.converter.ExpressionConverter;
import org.eclipse.wb.internal.core.model.property.converter.StringConverter;

public final class LocaleConverter
extends ExpressionConverter {
    public static final LocaleConverter INSTANCE = new LocaleConverter();

    private LocaleConverter() {
    }

    @Override
    public String toJavaSource(JavaInfo javaInfo, Object value) throws Exception {
        if (value == null) {
            return "(java.util.Locale) null";
        }
        Field[] fieldArray = Locale.class.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            int fModifiers = field.getModifiers();
            if (Modifier.isFinal(fModifiers) && Modifier.isStatic(fModifiers) && field.getType() == Locale.class && value.equals(field.get(null))) {
                return "java.util.Locale." + field.getName();
            }
            ++n2;
        }
        Locale locale = (Locale)value;
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("new java.util.Locale(");
        buffer.append(StringConverter.INSTANCE.toJavaSource(javaInfo, locale.getLanguage()));
        String country = locale.getCountry();
        if (country.length() != 0) {
            buffer.append(", ");
            buffer.append(StringConverter.INSTANCE.toJavaSource(javaInfo, country));
        }
        buffer.append(")");
        return buffer.toString();
    }
}

