/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.client.messages.Platform;

final class ImmutablePlatform
implements Platform {
    private final String architecture;
    private final String os;
    private final String osVersion;
    private final List<String> osFeatures;
    private final String variant;
    private final List<String> features;

    private ImmutablePlatform(String architecture, String os, String osVersion, List<String> osFeatures, String variant, List<String> features) {
        this.architecture = architecture;
        this.os = os;
        this.osVersion = osVersion;
        this.osFeatures = osFeatures;
        this.variant = variant;
        this.features = features;
    }

    @Override
    @JsonProperty(value="Architecture")
    public String architecture() {
        return this.architecture;
    }

    @Override
    @JsonProperty(value="OS")
    public String os() {
        return this.os;
    }

    @Override
    @JsonProperty(value="OSVersion")
    public String osVersion() {
        return this.osVersion;
    }

    @Override
    @JsonProperty(value="OSFeatures")
    public List<String> osFeatures() {
        return this.osFeatures;
    }

    @Override
    @JsonProperty(value="Variant")
    public String variant() {
        return this.variant;
    }

    @Override
    @JsonProperty(value="Features")
    public List<String> features() {
        return this.features;
    }

    public final ImmutablePlatform withArchitecture(String value) {
        String newValue = Objects.requireNonNull(value, "architecture");
        if (this.architecture.equals(newValue)) {
            return this;
        }
        return new ImmutablePlatform(newValue, this.os, this.osVersion, this.osFeatures, this.variant, this.features);
    }

    public final ImmutablePlatform withOs(String value) {
        String newValue = Objects.requireNonNull(value, "os");
        if (this.os.equals(newValue)) {
            return this;
        }
        return new ImmutablePlatform(this.architecture, newValue, this.osVersion, this.osFeatures, this.variant, this.features);
    }

    public final ImmutablePlatform withOsVersion(String value) {
        String newValue = Objects.requireNonNull(value, "osVersion");
        if (this.osVersion.equals(newValue)) {
            return this;
        }
        return new ImmutablePlatform(this.architecture, this.os, newValue, this.osFeatures, this.variant, this.features);
    }

    public final ImmutablePlatform withOsFeatures(String ... elements) {
        List<String> newValue = ImmutablePlatform.createUnmodifiableList(false, ImmutablePlatform.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePlatform(this.architecture, this.os, this.osVersion, newValue, this.variant, this.features);
    }

    public final ImmutablePlatform withOsFeatures(Iterable<String> elements) {
        if (this.osFeatures == elements) {
            return this;
        }
        List<String> newValue = ImmutablePlatform.createUnmodifiableList(false, ImmutablePlatform.createSafeList(elements, true, false));
        return new ImmutablePlatform(this.architecture, this.os, this.osVersion, newValue, this.variant, this.features);
    }

    public final ImmutablePlatform withVariant(String value) {
        String newValue = Objects.requireNonNull(value, "variant");
        if (this.variant.equals(newValue)) {
            return this;
        }
        return new ImmutablePlatform(this.architecture, this.os, this.osVersion, this.osFeatures, newValue, this.features);
    }

    public final ImmutablePlatform withFeatures(String ... elements) {
        List<String> newValue = ImmutablePlatform.createUnmodifiableList(false, ImmutablePlatform.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePlatform(this.architecture, this.os, this.osVersion, this.osFeatures, this.variant, newValue);
    }

    public final ImmutablePlatform withFeatures(Iterable<String> elements) {
        if (this.features == elements) {
            return this;
        }
        List<String> newValue = ImmutablePlatform.createUnmodifiableList(false, ImmutablePlatform.createSafeList(elements, true, false));
        return new ImmutablePlatform(this.architecture, this.os, this.osVersion, this.osFeatures, this.variant, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePlatform && this.equalTo(0, (ImmutablePlatform)another);
    }

    private boolean equalTo(int synthetic, ImmutablePlatform another) {
        return this.architecture.equals(another.architecture) && this.os.equals(another.os) && this.osVersion.equals(another.osVersion) && this.osFeatures.equals(another.osFeatures) && this.variant.equals(another.variant) && this.features.equals(another.features);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.architecture.hashCode();
        h += (h << 5) + this.os.hashCode();
        h += (h << 5) + this.osVersion.hashCode();
        h += (h << 5) + this.osFeatures.hashCode();
        h += (h << 5) + this.variant.hashCode();
        h += (h << 5) + this.features.hashCode();
        return h;
    }

    public String toString() {
        return "Platform{architecture=" + this.architecture + ", os=" + this.os + ", osVersion=" + this.osVersion + ", osFeatures=" + String.valueOf(this.osFeatures) + ", variant=" + this.variant + ", features=" + String.valueOf(this.features) + "}";
    }

    public static ImmutablePlatform copyOf(Platform instance) {
        if (instance instanceof ImmutablePlatform) {
            return (ImmutablePlatform)instance;
        }
        return ImmutablePlatform.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    static final class Builder {
        private static final long INIT_BIT_ARCHITECTURE = 1L;
        private static final long INIT_BIT_OS = 2L;
        private static final long INIT_BIT_OS_VERSION = 4L;
        private static final long INIT_BIT_VARIANT = 8L;
        private long initBits = 15L;
        private String architecture;
        private String os;
        private String osVersion;
        private List<String> osFeatures = new ArrayList<String>();
        private String variant;
        private List<String> features = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(Platform instance) {
            Objects.requireNonNull(instance, "instance");
            this.architecture(instance.architecture());
            this.os(instance.os());
            this.osVersion(instance.osVersion());
            this.addAllOsFeatures(instance.osFeatures());
            this.variant(instance.variant());
            this.addAllFeatures(instance.features());
            return this;
        }

        @JsonProperty(value="Architecture")
        public final Builder architecture(String architecture) {
            this.architecture = Objects.requireNonNull(architecture, "architecture");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="OS")
        public final Builder os(String os) {
            this.os = Objects.requireNonNull(os, "os");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="OSVersion")
        public final Builder osVersion(String osVersion) {
            this.osVersion = Objects.requireNonNull(osVersion, "osVersion");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder osFeature(String element) {
            this.osFeatures.add(Objects.requireNonNull(element, "osFeatures element"));
            return this;
        }

        public final Builder osFeatures(String ... elements) {
            for (String element : elements) {
                this.osFeatures.add(Objects.requireNonNull(element, "osFeatures element"));
            }
            return this;
        }

        @JsonProperty(value="OSFeatures")
        public final Builder osFeatures(Iterable<String> elements) {
            this.osFeatures.clear();
            return this.addAllOsFeatures(elements);
        }

        public final Builder addAllOsFeatures(Iterable<String> elements) {
            for (String element : elements) {
                this.osFeatures.add(Objects.requireNonNull(element, "osFeatures element"));
            }
            return this;
        }

        @JsonProperty(value="Variant")
        public final Builder variant(String variant) {
            this.variant = Objects.requireNonNull(variant, "variant");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder feature(String element) {
            this.features.add(Objects.requireNonNull(element, "features element"));
            return this;
        }

        public final Builder features(String ... elements) {
            for (String element : elements) {
                this.features.add(Objects.requireNonNull(element, "features element"));
            }
            return this;
        }

        @JsonProperty(value="Features")
        public final Builder features(Iterable<String> elements) {
            this.features.clear();
            return this.addAllFeatures(elements);
        }

        public final Builder addAllFeatures(Iterable<String> elements) {
            for (String element : elements) {
                this.features.add(Objects.requireNonNull(element, "features element"));
            }
            return this;
        }

        public ImmutablePlatform build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePlatform(this.architecture, this.os, this.osVersion, ImmutablePlatform.createUnmodifiableList(true, this.osFeatures), this.variant, ImmutablePlatform.createUnmodifiableList(true, this.features));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("architecture");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("os");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("osVersion");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("variant");
            }
            return "Cannot build Platform, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

