/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.SortedDependencies;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;

public final class ClosureSortedDependencies<INPUT extends DependencyInfo>
implements SortedDependencies<INPUT> {
    private final List<INPUT> inputs;
    private final List<INPUT> sortedList;
    private final List<INPUT> noProvides;
    private final Map<String, INPUT> provideMap = new HashMap<String, INPUT>();

    public ClosureSortedDependencies(List<INPUT> inputs) throws SortedDependencies.CircularDependencyException {
        this.inputs = new ArrayList<INPUT>(inputs);
        this.noProvides = new ArrayList<INPUT>();
        for (Object input : inputs) {
            Collection<String> currentProvides = input.getProvides();
            if (currentProvides.isEmpty()) {
                this.noProvides.add(input);
            }
            for (String provide : currentProvides) {
                this.provideMap.put(provide, input);
            }
        }
        HashMultimap deps = HashMultimap.create();
        for (DependencyInfo input : inputs) {
            for (String req : input.getRequires()) {
                DependencyInfo dep = (DependencyInfo)this.provideMap.get(req);
                if (dep == null || dep == input) continue;
                deps.put((Object)input, (Object)dep);
            }
        }
        this.sortedList = ClosureSortedDependencies.topologicalStableSort(inputs, deps);
        if (this.sortedList.size() < inputs.size()) {
            ArrayList<INPUT> subGraph = new ArrayList<INPUT>(inputs);
            subGraph.removeAll(this.sortedList);
            throw new SortedDependencies.CircularDependencyException(this.cycleToString(this.findCycle((List<INPUT>)subGraph, (Multimap<INPUT, INPUT>)deps)));
        }
    }

    @Override
    public INPUT getInputProviding(String symbol) throws SortedDependencies.MissingProvideException {
        if (this.provideMap.containsKey(symbol)) {
            return (INPUT)((DependencyInfo)this.provideMap.get(symbol));
        }
        throw new SortedDependencies.MissingProvideException(symbol);
    }

    @Override
    public INPUT maybeGetInputProviding(String symbol) {
        return (INPUT)((DependencyInfo)this.provideMap.get(symbol));
    }

    private List<INPUT> findCycle(List<INPUT> subGraph, Multimap<INPUT, INPUT> deps) {
        return this.findCycle((DependencyInfo)subGraph.get(0), new HashSet<INPUT>(subGraph), deps, new HashSet());
    }

    private List<INPUT> findCycle(INPUT current, Set<INPUT> subGraph, Multimap<INPUT, INPUT> deps, Set<INPUT> covered) {
        if (covered.add(current)) {
            List<INPUT> cycle = this.findCycle(this.findRequireInSubGraphOrFail(current, subGraph), subGraph, deps, covered);
            if (current == cycle.get(0)) {
                return cycle;
            }
            if (cycle.size() == 1 && cycle.get(0) != current) {
                cycle.add(current);
            } else if (cycle.get(0) != current && cycle.get(0) != cycle.get(cycle.size() - 1) && cycle.get(cycle.size() - 1) != current) {
                cycle.add(current);
            }
            return cycle;
        }
        ArrayList<INPUT> cycle = new ArrayList<INPUT>();
        cycle.add(current);
        return cycle;
    }

    private INPUT findRequireInSubGraphOrFail(INPUT input, Set<INPUT> subGraph) {
        for (String symbol : input.getRequires()) {
            DependencyInfo candidate = (DependencyInfo)this.provideMap.get(symbol);
            if (!subGraph.contains(candidate)) continue;
            return (INPUT)candidate;
        }
        throw new IllegalStateException("no require found in subgraph");
    }

    private String cycleToString(List<INPUT> cycle) {
        ArrayList<String> symbols = new ArrayList<String>();
        for (int i = cycle.size() - 1; i >= 0; --i) {
            symbols.add(((DependencyInfo)cycle.get(i)).getProvides().iterator().next());
        }
        symbols.add((String)symbols.get(0));
        return Joiner.on((String)" -> ").join(symbols);
    }

    @Override
    public List<INPUT> getSortedList() {
        return Collections.unmodifiableList(this.sortedList);
    }

    @Override
    public List<INPUT> getSortedDependenciesOf(List<INPUT> roots) {
        return this.getDependenciesOf(roots, true);
    }

    @Override
    public List<INPUT> getDependenciesOf(List<INPUT> roots, boolean sorted) {
        Preconditions.checkArgument((boolean)this.inputs.containsAll(roots));
        HashSet<DependencyInfo> included = new HashSet<DependencyInfo>();
        ArrayDeque<INPUT> worklist = new ArrayDeque<INPUT>(roots);
        while (!worklist.isEmpty()) {
            DependencyInfo current = (DependencyInfo)worklist.pop();
            if (!included.add(current)) continue;
            for (String req : current.getRequires()) {
                DependencyInfo dep = (DependencyInfo)this.provideMap.get(req);
                if (dep == null) continue;
                worklist.add(dep);
            }
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (DependencyInfo current : sorted ? this.sortedList : this.inputs) {
            if (!included.contains(current)) continue;
            builder.add((Object)current);
        }
        return builder.build();
    }

    @Override
    public List<INPUT> getInputsWithoutProvides() {
        return Collections.unmodifiableList(this.noProvides);
    }

    private static <T> List<T> topologicalStableSort(List<T> items, Multimap<T, T> deps) {
        if (items.isEmpty()) {
            return new ArrayList();
        }
        final HashMap<T, Integer> originalIndex = new HashMap<T, Integer>();
        for (int i = 0; i < items.size(); ++i) {
            originalIndex.put(items.get(i), i);
        }
        PriorityQueue<Object> inDegreeZero = new PriorityQueue<Object>(items.size(), new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                return (Integer)originalIndex.get(a) - (Integer)originalIndex.get(b);
            }
        });
        ArrayList result = new ArrayList();
        HashMultiset inDegree = HashMultiset.create();
        ArrayListMultimap reverseDeps = ArrayListMultimap.create();
        Multimaps.invertFrom(deps, (Multimap)reverseDeps);
        for (T item : items) {
            Collection itemDeps = deps.get(item);
            inDegree.add(item, itemDeps.size());
            if (!itemDeps.isEmpty()) continue;
            inDegreeZero.add(item);
        }
        while (!inDegreeZero.isEmpty()) {
            Object item = inDegreeZero.remove();
            result.add(item);
            for (Object inWaiting : reverseDeps.get(item)) {
                inDegree.remove(inWaiting, 1);
                if (inDegree.count(inWaiting) != 0) continue;
                inDegreeZero.add(inWaiting);
            }
        }
        return result;
    }
}

