/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.actions;

import java.util.Iterator;
import org.eclipse.datatools.modelbase.sql.query.QueryDeleteStatement;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryUpdateStatement;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.TableExpression;
import org.eclipse.datatools.modelbase.sql.query.helper.TableHelper;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.model.DatabaseHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.DeleteHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SelectHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.UpdateHelper;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class TableAliasAction
extends Action {
    SQLDomainModel domainModel;
    SQLQueryObject statement;
    TableExpression tableExpr;

    public TableAliasAction(SQLDomainModel domainModel) {
        super(Messages._UI_ACTION_UPDATE_ALIAS);
        this.domainModel = domainModel;
    }

    public void setStatement(SQLQueryObject statement) {
        this.statement = statement;
    }

    public void setTable(TableExpression table) {
        this.tableExpr = table;
    }

    public void run() {
        String tableAliasName = TableHelper.getExposedTableName((TableExpression)this.tableExpr);
        if (tableAliasName == null || tableAliasName.equals(this.tableExpr.getName())) {
            tableAliasName = "";
        }
        AliasValidator aliasValidator = new AliasValidator(tableAliasName);
        Shell aliasShell = Display.getCurrent().getActiveShell();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)aliasShell, "org.eclipse.datatools.sqltools.sqlbuilder.sqlg0030");
        UpdateTableAliasDialog updateAliasDialog = new UpdateTableAliasDialog(aliasShell, Messages._UI_DIALOG_CHANGE_ALIAS_TITLE, Messages._UI_DIALOG_CHANGE_ALIAS_TEXT, tableAliasName, aliasValidator);
        updateAliasDialog.setBlockOnOpen(true);
        int value = updateAliasDialog.open();
        if (value == 1) {
            return;
        }
        String newName = null;
        newName = updateAliasDialog.getNewAlias();
        TableHelper.setTableAliasInTableExpression((TableExpression)this.tableExpr, (String)newName);
        if (this.statement instanceof QuerySelectStatement) {
            SelectHelper.refresh((QuerySelectStatement)this.statement);
        } else if (this.statement instanceof QueryUpdateStatement) {
            UpdateHelper.refresh((QueryUpdateStatement)this.statement);
        } else if (this.statement instanceof QueryDeleteStatement) {
            DeleteHelper.refresh((QueryDeleteStatement)this.statement);
        }
    }

    class AliasValidator
    implements IInputValidator {
        String initialAlias;

        public AliasValidator(String initialAlias) {
            this.initialAlias = initialAlias;
        }

        public String getInitialAlias() {
            return this.initialAlias;
        }

        public String isValid(String newText) {
            newText = newText.toUpperCase().trim();
            if (TableAliasAction.this.statement instanceof QuerySelectStatement) {
                boolean aliasIsUnique = true;
                boolean tableUsed = true;
                if (newText.equals("") && tableUsed) {
                    return Messages._ERROR_ENTER_ALIAS;
                }
                if (!aliasIsUnique && !newText.equals(this.initialAlias.toUpperCase())) {
                    return Messages._ERROR_ALIAS_NOT_UNIQUE_TEXT;
                }
            }
            if (this.equalsDatabaseTableName(newText)) {
                return Messages._ERROR_ALIAS_TABLE_USED;
            }
            return null;
        }

        private boolean equalsDatabaseTableName(String aliasString) {
            Iterator dbTableIterator = null;
            Database database = TableAliasAction.this.domainModel.getDatabase();
            for (Table table : DatabaseHelper.getTableList(database)) {
                if (table == null || !table.getName().toUpperCase().equals(aliasString)) continue;
                return true;
            }
            return false;
        }
    }

    class UpdateTableAliasDialog
    extends InputDialog {
        Object object;
        String newAlias;
        String initialAlias;

        public UpdateTableAliasDialog(Shell parentShell, String title, String message, String initialAlias, AliasValidator aliasValidator) {
            super(parentShell, title, message, initialAlias, (IInputValidator)aliasValidator);
            this.newAlias = null;
            this.initialAlias = null;
            this.initialAlias = initialAlias;
        }

        public String getNewAlias() {
            return this.getValue();
        }
    }
}

