/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.source;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.TableExpression;
import org.eclipse.datatools.modelbase.sql.query.TableInDatabase;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.modelbase.sql.query.helper.TableHelper;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.helper.DatabaseHelper;
import org.eclipse.datatools.modelbase.sql.schema.helper.SchemaHelper;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilderPlugin;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.views.source.IDBContext;
import org.eclipse.datatools.sqltools.sqlbuilder.views.source.SQLBuilderDBProposal;
import org.eclipse.datatools.sqltools.sqlbuilder.views.source.SQLBuilderDBProposalsService;
import org.eclipse.datatools.sqltools.sqlbuilder.views.source.SQLCompletionProposal;
import org.eclipse.datatools.sqltools.sqlbuilder.views.source.SQLCompletionProposalFactory;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.SQLDBProposal;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;

public class SQLCompletionEngine {
    private SQLCompletionProposalFactory fProposalFactory = new SQLCompletionProposalFactory();
    private IDBContext fDBContext;
    private SQLBuilderDBProposalsService fSQLDBProposalsService;

    private List addSchemaNameIfNeeded(List tokenList) {
        List improvedTokenList = tokenList;
        SQLDomainModel domainModel = null;
        String defaultSchemaName = null;
        QueryStatement statement = null;
        IDBContext dbContext = this.getDBContext();
        if (dbContext == null || dbContext.getDomainModel() == null) {
            return improvedTokenList;
        }
        domainModel = dbContext.getDomainModel();
        defaultSchemaName = domainModel.getCurrentSchema();
        statement = domainModel.getSQLStatement();
        if (tokenList.size() == 1) {
            List tableExprList = StatementHelper.getTablesForStatement((QueryStatement)statement);
            HashSet<String> schemaNameSet = new HashSet<String>();
            String entry = "";
            String upperEntry = "";
            if (tokenList.size() > 0) {
                entry = (String)tokenList.get(0);
                upperEntry = entry.toUpperCase();
            }
            if (tableExprList.isEmpty()) {
                Table table;
                Database db = domainModel.getDatabase();
                Schema defaultSchema = DatabaseHelper.findSchema((Database)db, (String)defaultSchemaName);
                if (defaultSchema != null && (table = SchemaHelper.findTable((Schema)defaultSchema, (String)upperEntry)) != null) {
                    improvedTokenList.clear();
                    improvedTokenList.add(defaultSchemaName);
                    improvedTokenList.add(upperEntry);
                }
            } else {
                schemaNameSet.add(defaultSchemaName);
                for (TableExpression tableExpr : tableExprList) {
                    String schemaName = TableHelper.getSchemaNameForTableExpression((TableExpression)tableExpr);
                    if (schemaName == null) continue;
                    schemaNameSet.add(schemaName);
                }
                if (!schemaNameSet.contains(upperEntry)) {
                    Iterator tableExprListIter = tableExprList.iterator();
                    String realTableName = null;
                    String realSchemaName = null;
                    while (tableExprListIter.hasNext() && realTableName == null) {
                        TableExpression tableExpr = (TableExpression)tableExprListIter.next();
                        String exposedName = TableHelper.getExposedTableName((TableExpression)tableExpr);
                        if (!exposedName.equalsIgnoreCase(entry)) continue;
                        realTableName = tableExpr.getName();
                        realSchemaName = TableHelper.getSchemaNameForTableExpression((TableExpression)tableExpr);
                        improvedTokenList.clear();
                        improvedTokenList.add(realSchemaName);
                        improvedTokenList.add(realTableName);
                    }
                }
            }
        }
        return improvedTokenList;
    }

    public ICompletionProposal[] computeDBProposals(IDocument doc, ITypedRegion partition, int docOffset, IDBContext dbcontext) {
        ICompletionProposal[] dbProposalArray = null;
        if (partition.getType().equals("__dftl_partition_content_type")) {
            return null;
        }
        if (docOffset < 0) {
            return dbProposalArray;
        }
        this.setDBContext(dbcontext);
        List proposalList = null;
        String contextString = "";
        String filterString = "";
        try {
            List<String> dbContextList = new ArrayList();
            if (docOffset > 0) {
                int wordOffset = this.getPartitionOffset(doc, partition, docOffset, partition.getOffset());
                filterString = contextString = doc.get(wordOffset, docOffset - wordOffset);
                if (contextString.indexOf(".") > -1) {
                    StringTokenizer tokenizer = new StringTokenizer(contextString, ".");
                    while (tokenizer.hasMoreTokens()) {
                        dbContextList.add(tokenizer.nextToken());
                    }
                    filterString = !contextString.endsWith(".") ? (String)dbContextList.remove(dbContextList.size() - 1) : "";
                    if ((dbContextList = this.addSchemaNameIfNeeded(dbContextList)).size() == 1 || dbContextList.size() == 2) {
                        contextString = String.valueOf((String)dbContextList.get(0)) + ".";
                        if (dbContextList.size() == 2) {
                            contextString = String.valueOf(contextString) + dbContextList.get(1) + ".";
                        }
                    }
                } else {
                    dbContextList = this.addSchemaNameIfNeeded(dbContextList);
                }
            }
            proposalList = this.getDBObjectProposals(dbContextList);
        }
        catch (BadLocationException badLocationException) {}
        Vector dbProposals = this.filterProposals(proposalList, filterString, false);
        String replacementStr = null;
        String displayStr = null;
        dbProposalArray = new ICompletionProposal[dbProposals.size()];
        int dbProposalArrayIndex = 0;
        int proposalType = 0;
        int i = 0;
        while (i < dbProposals.size()) {
            Image image = null;
            dbProposals.get(i);
            replacementStr = displayStr = dbProposals.get(i).toString();
            if (dbProposals.get(i) instanceof SQLBuilderDBProposal) {
                SQLBuilderDBProposal sbProposal;
                String extraInfo;
                SQLBuilderDBProposal dbProposal = (SQLBuilderDBProposal)((Object)dbProposals.get(i));
                String parentNameUC = dbProposal.getParentName().toUpperCase();
                String prefixStringUC = contextString.toUpperCase();
                StringTokenizer strTokens = new StringTokenizer(parentNameUC, ".");
                int dbProposalType = dbProposal.getType();
                switch (dbProposalType) {
                    case 1: {
                        proposalType = 2;
                        break;
                    }
                    case 2: {
                        proposalType = 3;
                        break;
                    }
                    case 3: {
                        proposalType = 4;
                    }
                }
                if (dbProposal instanceof SQLBuilderDBProposal && dbProposalType == 3 && (extraInfo = (sbProposal = dbProposal).getExtraInfo()) != null && extraInfo.length() > 0) {
                    displayStr = String.valueOf(displayStr) + " - " + extraInfo;
                }
                if (strTokens.countTokens() > 1 && parentNameUC.startsWith(prefixStringUC)) {
                    String preceedingNames = parentNameUC.replaceFirst(prefixStringUC, "");
                    replacementStr = String.valueOf(preceedingNames) + "." + dbProposal.toString();
                }
                image = ((SQLDBProposal)dbProposals.get(i)).getImage();
            }
            if (dbProposals.size() <= proposalList.size() && replacementStr != null && docOffset >= 0) {
                int replacementLen = filterString.length();
                int replacementOffset = docOffset - replacementLen;
                SQLCompletionProposal sqlProposal = new SQLCompletionProposal(replacementStr, replacementOffset, replacementOffset, replacementLen, image, displayStr, null);
                sqlProposal.setProposalType(proposalType);
                dbProposalArray[dbProposalArrayIndex] = sqlProposal;
                ++dbProposalArrayIndex;
            }
            ++i;
        }
        return dbProposalArray;
    }

    public ICompletionProposal[] computeSyntaxProposals(IDocument doc, ITypedRegion partition, int docOffset) {
        ICompletionProposal[] syntaxProposalArray = null;
        String[] proposals = null;
        String partitionId = partition.getType();
        if (docOffset < 0) {
            return syntaxProposalArray;
        }
        Image image = SQLBuilderPlugin.getSQLImage("icons/SQL_keyword.gif");
        syntaxProposalArray = null;
        if (partitionId == "__sql__select__statement__") {
            proposals = this.fProposalFactory.getSelectProposals();
            int offset = this.getPartitionOffset(doc, partition, docOffset, "SELECT ", 1);
            String statement = null;
            try {
                if (docOffset > offset) {
                    statement = doc.get(offset, docOffset - offset);
                }
            }
            catch (BadLocationException badLocationException) {}
            Vector pList = this.sortProposals(proposals, statement, false);
            syntaxProposalArray = new ICompletionProposal[pList.size()];
            int i = 0;
            while (i < pList.size()) {
                String tmpStr = (String)pList.get(i);
                IContextInformation info = null;
                SQLCompletionProposal sqlProposal = null;
                sqlProposal = docOffset > offset ? new SQLCompletionProposal(tmpStr, offset, offset, docOffset - offset, image, tmpStr, info) : new SQLCompletionProposal(tmpStr, offset, offset, 0, image, tmpStr, info);
                sqlProposal.setProposalType(1);
                syntaxProposalArray[i] = sqlProposal;
                ++i;
            }
        } else if (partitionId == "__sql__insert__statement__") {
            proposals = this.fProposalFactory.getInsertProposals();
            int offset = this.getPartitionOffset(doc, partition, docOffset, "INSERT ", 1);
            String statement = null;
            try {
                if (docOffset > offset) {
                    statement = doc.get(offset, docOffset - offset);
                }
            }
            catch (BadLocationException badLocationException) {}
            Vector pList = this.sortProposals(proposals, statement, false);
            syntaxProposalArray = new ICompletionProposal[pList.size()];
            int i = 0;
            while (i < pList.size()) {
                String tmpStr = (String)pList.get(i);
                IContextInformation info = null;
                SQLCompletionProposal sqlProposal = null;
                sqlProposal = docOffset > offset ? new SQLCompletionProposal(tmpStr, offset, offset, docOffset - offset, image, tmpStr, info) : new SQLCompletionProposal(tmpStr, offset, offset, 0, image, tmpStr, info);
                sqlProposal.setProposalType(1);
                syntaxProposalArray[i] = sqlProposal;
                ++i;
            }
        } else if (partitionId == "__sql__update__statement__") {
            proposals = this.fProposalFactory.getUpdateProposals();
            int offset = this.getPartitionOffset(doc, partition, docOffset, "UPDATE ", 1);
            String statement = null;
            try {
                if (docOffset > offset) {
                    statement = doc.get(offset, docOffset - offset);
                }
            }
            catch (BadLocationException badLocationException) {}
            Vector pList = this.sortProposals(proposals, statement, false);
            syntaxProposalArray = new ICompletionProposal[pList.size()];
            int i = 0;
            while (i < pList.size()) {
                String tmpStr = (String)pList.get(i);
                IContextInformation info = null;
                SQLCompletionProposal sqlProposal = null;
                sqlProposal = docOffset > offset ? new SQLCompletionProposal(tmpStr, offset, offset, docOffset - offset, image, tmpStr, info) : new SQLCompletionProposal(tmpStr, offset, offset, 0, image, tmpStr, info);
                sqlProposal.setProposalType(1);
                syntaxProposalArray[i] = sqlProposal;
                ++i;
            }
        } else if (partitionId == "__sql__delete__statement__") {
            proposals = this.fProposalFactory.getDeleteProposals();
            int offset = this.getPartitionOffset(doc, partition, docOffset, "DELETE ", 1);
            String statement = null;
            try {
                if (docOffset > offset) {
                    statement = doc.get(offset, docOffset - offset);
                }
            }
            catch (BadLocationException badLocationException) {}
            Vector pList = this.sortProposals(proposals, statement, false);
            syntaxProposalArray = new ICompletionProposal[pList.size()];
            int i = 0;
            while (i < pList.size()) {
                String tmpStr = (String)pList.get(i);
                IContextInformation info = null;
                SQLCompletionProposal sqlProposal = null;
                sqlProposal = docOffset > offset ? new SQLCompletionProposal(tmpStr, offset, offset, docOffset - offset, image, tmpStr, info) : new SQLCompletionProposal(tmpStr, offset, offset, 0, image, tmpStr, info);
                sqlProposal.setProposalType(1);
                syntaxProposalArray[i] = sqlProposal;
                ++i;
            }
        } else if (partitionId == "__sql__create__statement__") {
            proposals = this.fProposalFactory.getCreateProposals();
            int offset = this.getPartitionOffset(doc, partition, docOffset, "CREATE ", 1);
            String statement = null;
            try {
                if (docOffset > offset) {
                    statement = doc.get(offset, docOffset - offset);
                }
            }
            catch (BadLocationException badLocationException) {}
            Vector pList = this.sortProposals(proposals, statement, false);
            syntaxProposalArray = new ICompletionProposal[pList.size()];
            int i = 0;
            while (i < pList.size()) {
                String tmpStr = (String)pList.get(i);
                IContextInformation info = null;
                syntaxProposalArray[i] = docOffset > offset ? new SQLCompletionProposal(tmpStr, offset, offset, docOffset - offset, null, tmpStr, info) : new SQLCompletionProposal(tmpStr, offset, offset, 0, null, tmpStr, info);
                ++i;
            }
        } else if (partitionId == "__sql__drop__statement__") {
            proposals = this.fProposalFactory.getDropProposals();
            int offset = this.getPartitionOffset(doc, partition, docOffset, "DROP ", 0);
            String statement = null;
            try {
                if (docOffset > offset) {
                    statement = doc.get(offset, docOffset - offset);
                }
            }
            catch (BadLocationException badLocationException) {}
            Vector pList = this.sortProposals(proposals, statement, false);
            syntaxProposalArray = new ICompletionProposal[pList.size()];
            int i = 0;
            while (i < pList.size()) {
                String tmpStr = (String)pList.get(i);
                IContextInformation info = null;
                syntaxProposalArray[i] = docOffset > offset ? new SQLCompletionProposal(tmpStr, offset, offset, docOffset - offset, null, tmpStr, info) : new SQLCompletionProposal(tmpStr, offset, offset, 0, null, tmpStr, info);
                ++i;
            }
        } else if (partitionId == "__sql__alter__statement__") {
            proposals = this.fProposalFactory.getAlterProposals();
            int offset = this.getPartitionOffset(doc, partition, docOffset, "ALTER ", 1);
            String statement = null;
            try {
                if (docOffset > offset) {
                    statement = doc.get(offset, docOffset - offset);
                }
            }
            catch (BadLocationException badLocationException) {}
            Vector pList = this.sortProposals(proposals, statement, false);
            syntaxProposalArray = new ICompletionProposal[pList.size()];
            int i = 0;
            while (i < pList.size()) {
                String tmpStr = (String)pList.get(i);
                IContextInformation info = null;
                syntaxProposalArray[i] = docOffset > offset ? new SQLCompletionProposal(tmpStr, offset, offset, docOffset - offset, null, tmpStr, info) : new SQLCompletionProposal(tmpStr, offset, offset, 0, null, tmpStr, info);
                ++i;
            }
        } else if (partitionId == "__sql__grant__statement__") {
            proposals = this.fProposalFactory.getGrantProposals();
            int offset = this.getPartitionOffset(doc, partition, docOffset, "GRANT ", 1);
            String statement = null;
            try {
                if (docOffset > offset) {
                    statement = doc.get(offset, docOffset - offset);
                }
            }
            catch (BadLocationException badLocationException) {}
            Vector pList = this.sortProposals(proposals, statement, false);
            syntaxProposalArray = new ICompletionProposal[pList.size()];
            int i = 0;
            while (i < pList.size()) {
                String tmpStr = (String)pList.get(i);
                IContextInformation info = null;
                syntaxProposalArray[i] = docOffset > offset ? new SQLCompletionProposal(tmpStr, offset, offset, docOffset - offset, null, tmpStr, info) : new SQLCompletionProposal(tmpStr, offset, offset, 0, null, tmpStr, info);
                ++i;
            }
        } else if (partitionId == "__sql__revoke__statement__") {
            proposals = this.fProposalFactory.getRevokeProposals();
            int offset = this.getPartitionOffset(doc, partition, docOffset, "REVOKE ", 1);
            String statement = null;
            try {
                if (docOffset > offset) {
                    statement = doc.get(offset, docOffset - offset);
                }
            }
            catch (BadLocationException badLocationException) {}
            Vector pList = this.sortProposals(proposals, statement, false);
            syntaxProposalArray = new ICompletionProposal[pList.size()];
            int i = 0;
            while (i < pList.size()) {
                String tmpStr = (String)pList.get(i);
                IContextInformation info = null;
                syntaxProposalArray[i] = docOffset > offset ? new SQLCompletionProposal(tmpStr, offset, offset, docOffset - offset, null, tmpStr, info) : new SQLCompletionProposal(tmpStr, offset, offset, 0, null, tmpStr, info);
                ++i;
            }
        } else if (partitionId == "__sql__commit__statement__") {
            proposals = this.fProposalFactory.getCommitProposals();
            int offset = this.getPartitionOffset(doc, partition, docOffset, "COMMIT", 1);
            String statement = null;
            try {
                if (docOffset > offset) {
                    statement = doc.get(offset, docOffset - offset);
                }
            }
            catch (BadLocationException badLocationException) {}
            Vector pList = this.sortProposals(proposals, statement, false);
            syntaxProposalArray = new ICompletionProposal[pList.size()];
            int i = 0;
            while (i < pList.size()) {
                String tmpStr = (String)pList.get(i);
                IContextInformation info = null;
                syntaxProposalArray[i] = docOffset > offset ? new SQLCompletionProposal(tmpStr, offset, offset, docOffset - offset, null, tmpStr, info) : new SQLCompletionProposal(tmpStr, offset, offset, 0, null, tmpStr, info);
                ++i;
            }
        } else if (partitionId == "__sql__rollback__statement__") {
            proposals = this.fProposalFactory.getRollbackProposals();
            int offset = this.getPartitionOffset(doc, partition, docOffset, "ROLLBACK", 1);
            String statement = null;
            try {
                if (docOffset > offset) {
                    statement = doc.get(offset, docOffset - offset);
                }
            }
            catch (BadLocationException badLocationException) {}
            Vector pList = this.sortProposals(proposals, statement, false);
            syntaxProposalArray = new ICompletionProposal[pList.size()];
            int i = 0;
            while (i < pList.size()) {
                String tmpStr = (String)pList.get(i);
                IContextInformation info = null;
                syntaxProposalArray[i] = docOffset > offset ? new SQLCompletionProposal(tmpStr, offset, offset, docOffset - offset, null, tmpStr, info) : new SQLCompletionProposal(tmpStr, offset, offset, 0, null, tmpStr, info);
                ++i;
            }
        } else if (partitionId == "__sql__set__statement__") {
            proposals = this.fProposalFactory.getSetProposals();
            int offset = this.getPartitionOffset(doc, partition, docOffset, "SET ", 1);
            String statement = null;
            try {
                if (docOffset > offset) {
                    statement = doc.get(offset, docOffset - offset);
                }
            }
            catch (BadLocationException badLocationException) {}
            Vector pList = this.sortProposals(proposals, statement, false);
            syntaxProposalArray = new ICompletionProposal[pList.size()];
            int i = 0;
            while (i < pList.size()) {
                String tmpStr = (String)pList.get(i);
                IContextInformation info = null;
                syntaxProposalArray[i] = docOffset > offset ? new SQLCompletionProposal(tmpStr, offset, offset, docOffset - offset, null, tmpStr, info) : new SQLCompletionProposal(tmpStr, offset, offset, 0, null, tmpStr, info);
                ++i;
            }
        } else if (partitionId == "__sql__connect__statement__") {
            proposals = this.fProposalFactory.getConnectProposals();
            int offset = this.getPartitionOffset(doc, partition, docOffset, "CONNECT", 1);
            String statement = null;
            try {
                if (docOffset > offset) {
                    statement = doc.get(offset, docOffset - offset);
                }
            }
            catch (BadLocationException badLocationException) {}
            Vector pList = this.sortProposals(proposals, statement, false);
            syntaxProposalArray = new ICompletionProposal[pList.size()];
            int i = 0;
            while (i < pList.size()) {
                String tmpStr = (String)pList.get(i);
                IContextInformation info = null;
                syntaxProposalArray[i] = docOffset > offset ? new SQLCompletionProposal(tmpStr, offset, offset, docOffset - offset, null, tmpStr, info) : new SQLCompletionProposal(tmpStr, offset, offset, 0, null, tmpStr, info);
                ++i;
            }
        } else if (partitionId == "__sql__disconnect__statement__") {
            proposals = this.fProposalFactory.getDisconnectProposals();
            int offset = this.getPartitionOffset(doc, partition, docOffset, "DISCONNECT ", 1);
            String statement = null;
            try {
                if (docOffset > offset) {
                    statement = doc.get(offset, docOffset - offset);
                }
            }
            catch (BadLocationException badLocationException) {}
            Vector pList = this.sortProposals(proposals, statement, false);
            syntaxProposalArray = new ICompletionProposal[pList.size()];
            int i = 0;
            while (i < pList.size()) {
                String tmpStr = (String)pList.get(i);
                IContextInformation info = null;
                syntaxProposalArray[i] = docOffset > offset ? new SQLCompletionProposal(tmpStr, offset, offset, docOffset - offset, null, tmpStr, info) : new SQLCompletionProposal(tmpStr, offset, offset, 0, null, tmpStr, info);
                ++i;
            }
        } else if (partitionId == "__sql__catalog__statement__") {
            proposals = this.fProposalFactory.getCatalogProposals();
            int offset = this.getPartitionOffset(doc, partition, docOffset, "CATALOG ", 1);
            String statement = null;
            try {
                if (docOffset > offset) {
                    statement = doc.get(offset, docOffset - offset);
                }
            }
            catch (BadLocationException badLocationException) {}
            Vector pList = this.sortProposals(proposals, statement, false);
            syntaxProposalArray = new ICompletionProposal[pList.size()];
            int i = 0;
            while (i < pList.size()) {
                String tmpStr = (String)pList.get(i);
                IContextInformation info = null;
                syntaxProposalArray[i] = docOffset > offset ? new SQLCompletionProposal(tmpStr, offset, offset, docOffset - offset, null, tmpStr, info) : new SQLCompletionProposal(tmpStr, offset, offset, 0, null, tmpStr, info);
                ++i;
            }
        } else if (partitionId == "__sql__uncatalog__statement__") {
            proposals = this.fProposalFactory.getUncatalogProposals();
            int offset = this.getPartitionOffset(doc, partition, docOffset, "UNCATALOG ", 1);
            String statement = null;
            try {
                if (docOffset > offset) {
                    statement = doc.get(offset, docOffset - offset);
                }
            }
            catch (BadLocationException badLocationException) {}
            Vector pList = this.sortProposals(proposals, statement, false);
            syntaxProposalArray = new ICompletionProposal[pList.size()];
            int i = 0;
            while (i < pList.size()) {
                String tmpStr = (String)pList.get(i);
                IContextInformation info = null;
                syntaxProposalArray[i] = docOffset > offset ? new SQLCompletionProposal(tmpStr, offset, offset, docOffset - offset, null, tmpStr, info) : new SQLCompletionProposal(tmpStr, offset, offset, 0, null, tmpStr, info);
                ++i;
            }
        } else if (partitionId == "__sql__comment__statement__") {
            proposals = this.fProposalFactory.getCommentOnProposals();
            int offset = this.getPartitionOffset(doc, partition, docOffset, "COMMENT ON ", 1);
            String statement = null;
            try {
                if (docOffset > offset) {
                    statement = doc.get(offset, docOffset - offset);
                }
            }
            catch (BadLocationException badLocationException) {}
            Vector pList = this.sortProposals(proposals, statement, false);
            syntaxProposalArray = new ICompletionProposal[pList.size()];
            int i = 0;
            while (i < pList.size()) {
                String tmpStr = (String)pList.get(i);
                IContextInformation info = null;
                syntaxProposalArray[i] = docOffset > offset ? new SQLCompletionProposal(tmpStr, offset, offset, docOffset - offset, null, tmpStr, info) : new SQLCompletionProposal(tmpStr, offset, offset, 0, null, tmpStr, info);
                ++i;
            }
        } else {
            try {
                if (docOffset == 0 || doc.getChar(docOffset - 1) != '.') {
                    proposals = this.fProposalFactory.getStatementProposals();
                }
            }
            catch (BadLocationException badLocationException) {}
            int offset = this.getPartitionOffset(doc, docOffset, partition.getOffset());
            String statement = null;
            try {
                statement = doc.get(offset, docOffset - offset);
            }
            catch (BadLocationException badLocationException) {}
            Vector pList = this.sortProposals(proposals, statement, false);
            syntaxProposalArray = new ICompletionProposal[pList.size()];
            int i = 0;
            while (i < pList.size()) {
                String tmpStr = (String)pList.get(i);
                IContextInformation info = null;
                SQLCompletionProposal sqlProposal = null;
                sqlProposal = pList.size() < proposals.length ? new SQLCompletionProposal(tmpStr, offset, offset, docOffset - offset, image, tmpStr, info) : new SQLCompletionProposal(tmpStr, docOffset, offset, docOffset - offset, image, tmpStr, info);
                sqlProposal.setProposalType(1);
                syntaxProposalArray[i] = sqlProposal;
                ++i;
            }
        }
        return syntaxProposalArray;
    }

    public Vector filterProposals(List proposalList, String prefixString, boolean showAll) {
        Vector proposalVec = new Vector();
        if (proposalList == null) {
            return proposalVec;
        }
        if (prefixString != null && prefixString.length() > 0) {
            char triggerChar = prefixString.charAt(prefixString.length() - 1);
            String precedingName = null;
            if (triggerChar == '.') {
                precedingName = prefixString.substring(0, prefixString.length() - 1);
                if (!precedingName.equals("")) {
                    ListIterator listIterator = proposalList.listIterator();
                    while (listIterator.hasNext()) {
                        String precedingNameUC;
                        String parentNameUC;
                        Object proposal = listIterator.next();
                        if (!(proposal instanceof SQLDBProposal) || !(parentNameUC = ((SQLDBProposal)proposal).getParentName().toUpperCase()).endsWith(precedingNameUC = precedingName.toUpperCase())) continue;
                        proposalVec.add(proposal);
                    }
                }
            } else {
                int i = 0;
                while (i < proposalList.size()) {
                    Object proposal = proposalList.get(i);
                    String proposalText = proposal instanceof Object[] ? (String)((Object[])proposal)[0] : (proposal instanceof SQLDBProposal ? ((SQLDBProposal)proposal).getName() : proposal.toString());
                    if (proposalText.toUpperCase().trim().indexOf(prefixString.toUpperCase()) == 0) {
                        proposalVec.add(proposalList.get(i));
                    }
                    ++i;
                }
            }
        } else {
            proposalVec.addAll(proposalList);
        }
        if (showAll && proposalVec.size() == 0) {
            proposalVec.addAll(proposalList);
        }
        return proposalVec;
    }

    public int getPartitionOffset(IDocument doc, int docOffset, int offset) {
        boolean loop = true;
        int offset1 = docOffset - 1;
        try {
            while (loop && offset <= offset1) {
                switch (doc.getChar(offset1)) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        loop = false;
                        break;
                    }
                    default: {
                        --offset1;
                    }
                }
            }
        }
        catch (BadLocationException badLocationException) {}
        offset = offset1 + 1;
        return offset;
    }

    public int getPartitionOffset(IDocument doc, ITypedRegion partition, int docOffset, int offset) {
        boolean loop = true;
        int offset1 = docOffset - 1;
        try {
            while (loop && offset <= offset1) {
                switch (doc.getChar(offset1)) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        loop = false;
                        break;
                    }
                    default: {
                        --offset1;
                    }
                }
            }
        }
        catch (BadLocationException badLocationException) {}
        offset = offset1 + 1;
        return offset;
    }

    public int getPartitionOffset(IDocument doc, ITypedRegion partition, int docOffset, String leadingString, int position) {
        int offset = partition.getOffset() + leadingString.length();
        if (docOffset <= offset) {
            return offset;
        }
        switch (position) {
            case 0: {
                break;
            }
            default: {
                boolean loop = true;
                int offset1 = docOffset - 1;
                try {
                    while (loop && offset <= offset1) {
                        switch (doc.getChar(offset1)) {
                            case '\t': 
                            case '\n': 
                            case '\r': 
                            case ' ': {
                                loop = false;
                                break;
                            }
                            default: {
                                --offset1;
                            }
                        }
                    }
                }
                catch (BadLocationException badLocationException) {}
                offset = offset1 + 1;
            }
        }
        return this.getPartitionOffset(doc, docOffset, offset);
    }

    public static boolean showContextInformation(IDocument doc, ITypedRegion partition, int docOffset, String leadingString) {
        int offset = partition.getOffset() + leadingString.length();
        if (docOffset <= offset) {
            return true;
        }
        boolean loop = true;
        int offset1 = docOffset;
        try {
            while (loop && offset <= offset1) {
                switch (doc.getChar(offset1)) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        --offset1;
                        break;
                    }
                    default: {
                        loop = false;
                    }
                }
            }
        }
        catch (BadLocationException badLocationException) {}
        return offset1 <= offset;
    }

    public Vector sortProposals(String[] proposals, String sortingString, boolean showAll) {
        int i;
        Vector<String> aList = new Vector<String>();
        if (sortingString != null && sortingString.length() > 0) {
            i = 0;
            while (i < proposals.length) {
                if (proposals[i].toUpperCase().trim().indexOf(sortingString.toUpperCase()) == 0) {
                    aList.add(proposals[i]);
                }
                ++i;
            }
        } else {
            showAll = true;
        }
        if (showAll && aList.size() == 0) {
            i = 0;
            while (i < proposals.length) {
                aList.add(proposals[i]);
                ++i;
            }
        }
        return aList;
    }

    public List getAvailableColumns() {
        ArrayList<SQLBuilderDBProposal> dbProposalsList = new ArrayList<SQLBuilderDBProposal>();
        IDBContext dbContext = this.getDBContext();
        if (dbContext != null && dbContext.getDomainModel() != null) {
            SQLDomainModel domainModel = dbContext.getDomainModel();
            QueryStatement statement = domainModel.getSQLStatement();
            List tableExprList = StatementHelper.getTablesForStatement((QueryStatement)statement);
            boolean multiTable = tableExprList.size() > 1;
            for (TableExpression tableExpr : tableExprList) {
                TableInDatabase tableInDB;
                Table dbTable;
                String exposedTableName = TableHelper.getExposedTableName((TableExpression)tableExpr);
                if (!(tableExpr instanceof TableInDatabase) || (dbTable = (tableInDB = (TableInDatabase)tableExpr).getDatabaseTable()) == null) continue;
                EList colList = dbTable.getColumns();
                for (Column colObj : colList) {
                    SQLBuilderDBProposal proposal = new SQLBuilderDBProposal((EObject)colObj);
                    proposal.setParentName(exposedTableName);
                    if (multiTable) {
                        String name = proposal.getName();
                        name = String.valueOf(exposedTableName) + "." + name;
                        proposal.setName(name);
                    }
                    dbProposalsList.add(proposal);
                }
            }
        }
        return dbProposalsList;
    }

    public List getAvailableTables() {
        ArrayList<SQLBuilderDBProposal> dbProposalsList = new ArrayList<SQLBuilderDBProposal>();
        IDBContext dbContext = this.getDBContext();
        if (dbContext != null && dbContext.getDomainModel() != null) {
            Schema defaultSchema;
            SQLDomainModel domainModel = dbContext.getDomainModel();
            Database db = domainModel.getDatabase();
            String schemaName = domainModel.getCurrentSchema();
            if (db != null && schemaName != null && (defaultSchema = DatabaseHelper.findSchema((Database)db, (String)schemaName)) != null) {
                EList tableList = defaultSchema.getTables();
                for (Table tableObj : tableList) {
                    SQLBuilderDBProposal proposal = new SQLBuilderDBProposal((EObject)tableObj);
                    dbProposalsList.add(proposal);
                }
            }
        }
        return dbProposalsList;
    }

    public List getAvailableColumnsForTable(String schemaName, String tableName) {
        TableInDatabase tableInDB;
        Table tableObj;
        SQLDomainModel domainModel;
        QueryStatement statement;
        List tableExprList;
        TableExpression tableExpr;
        EList colObjList = new ArrayList();
        IDBContext dbContext = this.getDBContext();
        if (dbContext != null && dbContext.getDomainModel() != null && (tableExpr = TableHelper.findTableExpressionInTableExpressionList((String)schemaName, (String)tableName, (List)(tableExprList = StatementHelper.getTablesForStatement((QueryStatement)(statement = (domainModel = dbContext.getDomainModel()).getSQLStatement()))))) instanceof TableInDatabase && (tableObj = (tableInDB = (TableInDatabase)tableExpr).getDatabaseTable()) != null) {
            colObjList = tableObj.getColumns();
        }
        return colObjList;
    }

    public List getDBObjectProposals(List dbContextList) {
        List<SQLBuilderDBProposal> dbProposalsList = new ArrayList();
        SQLBuilderDBProposalsService dbProposalsService = this.getSQLDBProposalsService();
        if (dbProposalsService == null) {
            IDBContext dbContext = this.getDBContext();
            dbProposalsService = dbContext.getDBProposalsService();
            this.setSQLDBProposalsService(dbProposalsService);
        }
        if (dbContextList != null && dbContextList.size() > 0) {
            String tableName;
            String schemaName;
            List colObjList;
            if (dbContextList.size() == 2 && (colObjList = this.getAvailableColumnsForTable(schemaName = (String)dbContextList.get(0), tableName = (String)dbContextList.get(1))).size() > 0) {
                for (Column colObj : colObjList) {
                    SQLBuilderDBProposal proposal = new SQLBuilderDBProposal((EObject)colObj);
                    dbProposalsList.add(proposal);
                }
            }
            if (dbProposalsList.size() == 0 && dbProposalsService != null && dbProposalsService.populate(dbContextList)) {
                dbProposalsList.addAll(dbProposalsService.getDBProposals());
            }
        } else {
            dbProposalsList = this.getAvailableColumns();
            dbProposalsList.addAll(this.getAvailableTables());
            if (dbProposalsService.populate(null)) {
                dbProposalsList.addAll(dbProposalsService.getDBProposals());
            }
        }
        return dbProposalsList;
    }

    public IDBContext getDBContext() {
        return this.fDBContext;
    }

    public void setDBContext(IDBContext dbContext) {
        this.fDBContext = dbContext;
    }

    public SQLBuilderDBProposalsService getSQLDBProposalsService() {
        return this.fSQLDBProposalsService;
    }

    public void setSQLDBProposalsService(SQLBuilderDBProposalsService sqlDBProposalsService) {
        this.fSQLDBProposalsService = sqlDBProposalsService;
    }
}

