/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.communication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.php.internal.debug.core.zend.communication.IRemoteFileContentRequestor;

public class RemoteFileContentRequestorsRegistry {
    private static RemoteFileContentRequestorsRegistry instance;
    private Map<String, IRemoteFileContentRequestor> requestors = Collections.synchronizedMap(new HashMap());
    private List<IRemoteFileContentRequestor> externalRequestHandlers = Collections.synchronizedList(new ArrayList());

    public static synchronized RemoteFileContentRequestorsRegistry getInstance() {
        if (instance == null) {
            instance = new RemoteFileContentRequestorsRegistry();
        }
        return instance;
    }

    public void addRequestor(IRemoteFileContentRequestor requestor, String fileName, int lineNumber) {
        this.requestors.put(String.valueOf(fileName) + ":" + lineNumber, requestor);
    }

    public void addExternalRequestHandler(IRemoteFileContentRequestor requestor) {
        this.externalRequestHandlers.add(requestor);
    }

    public IRemoteFileContentRequestor removeRequestor(String fileName, int lineNumber) {
        return this.requestors.remove(String.valueOf(fileName) + ":" + lineNumber);
    }

    public void removeExternalRequestHandler(IRemoteFileContentRequestor requestor) {
        this.externalRequestHandlers.remove(requestor);
    }

    public void handleExternalRequest(byte[] content, String serverAddress, String originalURL, String fileName, int lineNumber) {
        for (IRemoteFileContentRequestor requestor : this.externalRequestHandlers) {
            requestor.fileContentReceived(content, serverAddress, originalURL, fileName, lineNumber);
            requestor.requestCompleted(null);
        }
    }
}

