/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.mysql.ddl;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.datatools.enablement.mysql.catalog.MySqlCatalogTable;
import org.eclipse.datatools.enablement.mysql.ddl.shared.MySqlDdlBuilderHelper;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatement;
import org.eclipse.datatools.modelbase.sql.tables.ActionGranularityType;
import org.eclipse.datatools.modelbase.sql.tables.ActionTimeType;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.CheckType;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;
import org.eclipse.emf.common.util.EList;

public class MySqlDdlBuilder
extends MySqlDdlBuilderHelper {
    @Override
    public String dropIndex(Index index, boolean quoteIdentifiers, boolean qualifyNames) {
        Table table = index.getTable();
        return "ALTER TABLE " + this.getName(table, quoteIdentifiers, qualifyNames) + " " + "DROP" + " " + "INDEX" + " " + this.getName(index, quoteIdentifiers, qualifyNames);
    }

    @Override
    public String createTable(BaseTable table, boolean quoteIdentifiers, boolean qualifyNames, boolean generatePk) {
        MySqlCatalogTable mySqlTable;
        String tableType;
        PrimaryKey pk = table.getPrimaryKey();
        boolean hasPK = false;
        if (pk != null && pk.getMembers() != null && !pk.getMembers().isEmpty()) {
            hasPK = true;
        }
        String statement = "CREATE TABLE " + this.getName((Table)table, quoteIdentifiers, qualifyNames) + " " + "(" + NEWLINE;
        Iterator it = table.getColumns().iterator();
        while (it.hasNext()) {
            Column column = (Column)it.next();
            statement = String.valueOf(statement) + "\t" + this.getColumnString(column, quoteIdentifiers, generatePk);
            if (it.hasNext()) {
                statement = String.valueOf(statement) + ",";
            } else if (hasPK && generatePk) {
                statement = String.valueOf(statement) + ",";
            }
            statement = String.valueOf(statement) + NEWLINE;
        }
        if (hasPK && generatePk) {
            this.setCreateDone(pk);
            String pkStatement = "\tPRIMARY KEY (";
            ArrayList<Column> colList = new ArrayList<Column>();
            for (Column c : pk.getMembers()) {
                if (c.getIdentitySpecifier() == null) continue;
                colList.add(c);
            }
            for (Column c : pk.getMembers()) {
                if (c.getIdentitySpecifier() != null) continue;
                colList.add(c);
            }
            Iterator iter = colList.iterator();
            while (iter.hasNext()) {
                Column c;
                c = (Column)iter.next();
                String columnName = c.getName();
                pkStatement = quoteIdentifiers ? String.valueOf(pkStatement) + this.getQuotedString(columnName) : String.valueOf(pkStatement) + columnName;
                if (!iter.hasNext()) continue;
                pkStatement = String.valueOf(pkStatement) + ",";
            }
            pkStatement = String.valueOf(pkStatement) + ")" + NEWLINE;
            statement = String.valueOf(statement) + pkStatement;
        }
        statement = String.valueOf(statement) + ")";
        if (table instanceof MySqlCatalogTable && (tableType = (mySqlTable = (MySqlCatalogTable)table).getTableType()) != null) {
            statement = String.valueOf(statement) + " ENGINE=" + tableType;
        }
        return statement;
    }

    @Override
    public String createView(ViewTable view, boolean quoteIdentifiers, boolean qualifyNames) {
        String viewDefinition = "CREATE ";
        viewDefinition = String.valueOf(viewDefinition) + "VIEW " + this.getName((Table)view, quoteIdentifiers, qualifyNames) + " ";
        String columns = this.getViewColumnList(view);
        if (columns != null) {
            viewDefinition = String.valueOf(viewDefinition) + "(" + columns + ")" + " ";
        }
        viewDefinition = String.valueOf(viewDefinition) + "AS" + NEWLINE;
        viewDefinition = String.valueOf(viewDefinition) + view.getQueryExpression().getSQL();
        CheckType checkType = view.getCheckType();
        if (checkType == CheckType.CASCADED_LITERAL) {
            viewDefinition = String.valueOf(viewDefinition) + NEWLINE + "WITH" + " " + "CASCADED" + " " + "CHECK" + " " + "OPTION";
        } else if (checkType == CheckType.LOCAL_LITERAL) {
            viewDefinition = String.valueOf(viewDefinition) + NEWLINE + "WITH" + " " + "LOCAL" + " " + "CHECK" + " " + "OPTION";
        }
        return viewDefinition;
    }

    @Override
    public String createIndex(Index index, boolean quoteIdentifiers, boolean qualifyNames) {
        String statement = "CREATE ";
        if (index.isUnique()) {
            statement = String.valueOf(statement) + "UNIQUE ";
        }
        statement = String.valueOf(statement) + "INDEX " + this.getName(index, quoteIdentifiers, false) + " " + "ON" + " " + this.getName(index.getTable(), quoteIdentifiers, qualifyNames) + " " + "(" + this.getIndexKeyColumns(index, quoteIdentifiers) + ")";
        return statement;
    }

    @Override
    public String createTrigger(Trigger trigger, boolean quoteIdentifiers, boolean qualifyNames) {
        String statement = "CREATE TRIGGER " + this.getName(trigger, quoteIdentifiers, qualifyNames) + " ";
        ActionTimeType actionTime = trigger.getActionTime();
        if (actionTime == ActionTimeType.AFTER_LITERAL) {
            statement = String.valueOf(statement) + "AFTER";
        } else if (actionTime == ActionTimeType.BEFORE_LITERAL) {
            statement = String.valueOf(statement) + "BEFORE";
        } else if (actionTime == ActionTimeType.INSTEADOF_LITERAL) {
            statement = String.valueOf(statement) + "INSTEAD OF";
        }
        statement = String.valueOf(statement) + " ";
        if (trigger.isDeleteType()) {
            statement = String.valueOf(statement) + "DELETE";
        } else if (trigger.isInsertType()) {
            statement = String.valueOf(statement) + "INSERT";
        } else if (trigger.isUpdateType()) {
            statement = String.valueOf(statement) + "UPDATE";
            EList updateColumns = trigger.getTriggerColumn();
            if (!updateColumns.isEmpty()) {
                statement = String.valueOf(statement) + " OF ";
                Iterator it = updateColumns.iterator();
                while (it.hasNext()) {
                    Column column = (Column)it.next();
                    statement = String.valueOf(statement) + column.getName();
                    if (!it.hasNext()) continue;
                    statement = String.valueOf(statement) + ", ";
                }
            }
        }
        statement = String.valueOf(statement) + " ON " + this.getName(trigger.getSubjectTable(), quoteIdentifiers, qualifyNames) + NEWLINE;
        String newRow = trigger.getNewRow();
        String oldRow = trigger.getOldRow();
        if (newRow != null && newRow.length() != 0) {
            statement = String.valueOf(statement) + "REFERENCING NEW AS " + newRow + NEWLINE;
        }
        if (oldRow != null && oldRow.length() != 0) {
            statement = String.valueOf(statement) + "REFERENCING OLD AS " + oldRow + NEWLINE;
        }
        statement = trigger.getActionGranularity() == ActionGranularityType.ROW_LITERAL ? String.valueOf(statement) + "FOR EACH ROW" : String.valueOf(statement) + "FOR EACH STATEMENT";
        for (SQLStatement s : trigger.getActionStatement()) {
            statement = String.valueOf(statement) + s.getSQL();
        }
        return statement;
    }

    @Override
    protected String getName(Index index, boolean quoteIdentifiers, boolean qualifyNames) {
        String indexName = index.getName();
        String dbName = null;
        if (quoteIdentifiers) {
            indexName = this.getQuotedString(indexName);
            if (qualifyNames) {
                dbName = index.getSchema().getDatabase().getName();
                dbName = this.getQuotedString(dbName);
                indexName = String.valueOf(dbName) + "." + indexName;
            }
        }
        return indexName;
    }
}

